/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.dimlets;

import java.util.HashMap;
import java.util.Map;
import mcjty.rftools.items.dimlets.types.BiomeDimletType;
import mcjty.rftools.items.dimlets.types.ControllerDimletType;
import mcjty.rftools.items.dimlets.types.DigitDimletType;
import mcjty.rftools.items.dimlets.types.EffectDimletType;
import mcjty.rftools.items.dimlets.types.FeatureDimletType;
import mcjty.rftools.items.dimlets.types.FoliageDimletType;
import mcjty.rftools.items.dimlets.types.IDimletType;
import mcjty.rftools.items.dimlets.types.LiquidDimletType;
import mcjty.rftools.items.dimlets.types.MaterialDimletType;
import mcjty.rftools.items.dimlets.types.MobDimletType;
import mcjty.rftools.items.dimlets.types.PatreonDimletType;
import mcjty.rftools.items.dimlets.types.SkyDimletType;
import mcjty.rftools.items.dimlets.types.SpecialDimletType;
import mcjty.rftools.items.dimlets.types.StructureDimletType;
import mcjty.rftools.items.dimlets.types.TerrainDimletType;
import mcjty.rftools.items.dimlets.types.TimeDimletType;
import mcjty.rftools.items.dimlets.types.WeatherDimletType;

public enum DimletType {
    DIMLET_BIOME(new BiomeDimletType()),
    DIMLET_FOLIAGE(new FoliageDimletType()),
    DIMLET_LIQUID(new LiquidDimletType()),
    DIMLET_MATERIAL(new MaterialDimletType()),
    DIMLET_MOBS(new MobDimletType()),
    DIMLET_SKY(new SkyDimletType()),
    DIMLET_STRUCTURE(new StructureDimletType()),
    DIMLET_TERRAIN(new TerrainDimletType()),
    DIMLET_FEATURE(new FeatureDimletType()),
    DIMLET_TIME(new TimeDimletType()),
    DIMLET_DIGIT(new DigitDimletType()),
    DIMLET_EFFECT(new EffectDimletType()),
    DIMLET_SPECIAL(new SpecialDimletType()),
    DIMLET_CONTROLLER(new ControllerDimletType()),
    DIMLET_WEATHER(new WeatherDimletType()),
    DIMLET_PATREON(new PatreonDimletType());

    public final IDimletType dimletType;
    private static final Map<String, DimletType> typeByName;
    private static final Map<String, DimletType> typeByOpcode;

    private DimletType(IDimletType dimletType) {
        this.dimletType = dimletType;
    }

    public static DimletType getTypeByName(String name) {
        return typeByName.get(name);
    }

    public static DimletType getTypeByOpcode(String opcode) {
        return typeByOpcode.get(opcode);
    }

    static {
        typeByName = new HashMap<String, DimletType>();
        typeByOpcode = new HashMap<String, DimletType>();
        for (DimletType type : DimletType.values()) {
            typeByName.put(type.dimletType.getName(), type);
            typeByOpcode.put(type.dimletType.getOpcode(), type);
        }
    }
}

