/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.world.terrain;

import java.util.Random;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.dimension.world.terrain.NormalTerrainGenerator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class RoughTerrainGenerator
extends NormalTerrainGenerator {
    private final boolean filled;

    public RoughTerrainGenerator(boolean filled) {
        this.filled = filled;
    }

    @Override
    public void generate(int chunkX, int chunkZ, Block[] aBlock, byte[] abyte) {
        Block baseBlock = this.provider.dimensionInformation.getBaseBlockForTerrain().getBlock();
        byte baseMeta = this.provider.dimensionInformation.getBaseBlockForTerrain().getMeta();
        Block baseFluid = this.provider.dimensionInformation.getFluidForTerrain();
        Random random = new Random((long)chunkX * 13L + (long)chunkZ * 577L);
        int index = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height;
                byte waterLevel = (byte)(63.0f + random.nextFloat() * 32.0f - 16.0f);
                for (height = 0; height < DimletConfiguration.bedrockLayer; ++height) {
                    aBlock[index] = Blocks.field_150357_h;
                    abyte[index++] = 0;
                }
                if (baseMeta == 127) {
                    while (height < waterLevel) {
                        aBlock[index] = baseBlock;
                        abyte[index++] = (byte)(height / 2 + x / 2 + z / 2 & 0xF);
                        ++height;
                    }
                } else {
                    while (height < waterLevel) {
                        aBlock[index] = baseBlock;
                        abyte[index++] = baseMeta;
                        ++height;
                    }
                }
                if (this.filled) {
                    while (height < 63) {
                        aBlock[index] = baseFluid;
                        abyte[index++] = baseMeta;
                        ++height;
                    }
                }
                while (height < 256) {
                    aBlock[index++] = null;
                    ++height;
                }
            }
        }
    }
}

