/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.world;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.rftools.dimension.description.MobDescriptor;
import mcjty.rftools.dimension.world.mapgen.MapGenCanyons;
import mcjty.rftools.dimension.world.mapgen.MapGenDenseCaves;
import mcjty.rftools.dimension.world.mapgen.MapGenLiquidOrbs;
import mcjty.rftools.dimension.world.mapgen.MapGenOrbs;
import mcjty.rftools.dimension.world.mapgen.MapGenPyramids;
import mcjty.rftools.dimension.world.mapgen.MapGenRuinedCities;
import mcjty.rftools.dimension.world.mapgen.MapGenTendrils;
import mcjty.rftools.dimension.world.terrain.AmplifiedTerrainGenerator;
import mcjty.rftools.dimension.world.terrain.BaseTerrainGenerator;
import mcjty.rftools.dimension.world.terrain.CavernTerrainGenerator;
import mcjty.rftools.dimension.world.terrain.FlatTerrainGenerator;
import mcjty.rftools.dimension.world.terrain.GridTerrainGenerator;
import mcjty.rftools.dimension.world.terrain.IslandTerrainGenerator;
import mcjty.rftools.dimension.world.terrain.LiquidTerrainGenerator;
import mcjty.rftools.dimension.world.terrain.NearlandsTerrainGenerator;
import mcjty.rftools.dimension.world.terrain.NormalTerrainGenerator;
import mcjty.rftools.dimension.world.terrain.RoughTerrainGenerator;
import mcjty.rftools.dimension.world.terrain.VoidTerrainGenerator;
import mcjty.rftools.dimension.world.terrain.WavesTerrainGenerator;
import mcjty.rftools.dimension.world.types.FeatureType;
import mcjty.rftools.dimension.world.types.StructureType;
import mcjty.rftools.dimension.world.types.TerrainType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class GenericChunkProvider
implements IChunkProvider {
    public Random rand;
    public long seed;
    private World worldObj;
    public DimensionInformation dimensionInformation;
    private List<BiomeGenBase.SpawnListEntry> extraSpawns;
    private List<Integer> extraSpawnsMax;
    private final BaseTerrainGenerator terrainGenerator;
    public WorldType worldType;
    private MapGenBase caveGenerator = new MapGenCaves();
    private MapGenTendrils tendrilGenerator = new MapGenTendrils(this);
    private MapGenCanyons canyonGenerator = new MapGenCanyons(this);
    private MapGenPyramids pyramidGenerator = new MapGenPyramids(this);
    private MapGenOrbs sphereGenerator = new MapGenOrbs(this, false);
    private MapGenOrbs hugeSphereGenerator = new MapGenOrbs(this, true);
    private MapGenRuinedCities ruinedCitiesGenerator = new MapGenRuinedCities(this);
    private MapGenLiquidOrbs liquidSphereGenerator = new MapGenLiquidOrbs(this, false);
    private MapGenLiquidOrbs hugeLiquidSphereGenerator = new MapGenLiquidOrbs(this, true);
    private MapGenBase denseCaveGenerator = new MapGenDenseCaves(this);
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private MapGenVillage villageGenerator = new MapGenVillage();
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    public MapGenNetherBridge genNetherBridge = new MapGenNetherBridge();
    private MapGenScatteredFeature scatteredFeatureGenerator = new MapGenScatteredFeature();
    private MapGenBase ravineGenerator = new MapGenRavine();
    public BiomeGenBase[] biomesForGeneration;

    public GenericChunkProvider(World world, long seed) {
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)this.strongholdGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)this.villageGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)this.mineshaftGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.scatteredFeatureGenerator = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)this.scatteredFeatureGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.genNetherBridge = (MapGenNetherBridge)TerrainGen.getModdedMapGen((MapGenBase)this.genNetherBridge, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_BRIDGE);
        this.worldObj = world;
        this.dimensionInformation = RfToolsDimensionManager.getDimensionManager(world).getDimensionInformation(world.field_73011_w.field_76574_g);
        this.worldType = world.func_72912_H().func_76067_t();
        if (this.dimensionInformation.getTerrainType() == TerrainType.TERRAIN_AMPLIFIED) {
            this.worldType = WorldType.field_151360_e;
        } else if (this.dimensionInformation.getTerrainType() == TerrainType.TERRAIN_NORMAL && !DimletConfiguration.normalTerrainInheritsOverworld) {
            this.worldType = WorldType.field_77137_b;
        } else if (this.dimensionInformation.getTerrainType() == TerrainType.TERRAIN_FLAT) {
            this.worldType = WorldType.field_77138_c;
        }
        this.seed = seed;
        this.rand = new Random((seed + 516L) * 314L);
        switch (this.dimensionInformation.getTerrainType()) {
            case TERRAIN_VOID: {
                this.terrainGenerator = new VoidTerrainGenerator();
                break;
            }
            case TERRAIN_FLAT: {
                this.terrainGenerator = new FlatTerrainGenerator(63);
                break;
            }
            case TERRAIN_AMPLIFIED: {
                this.terrainGenerator = new AmplifiedTerrainGenerator();
                break;
            }
            case TERRAIN_NEARLANDS: {
                this.terrainGenerator = new NearlandsTerrainGenerator();
                break;
            }
            case TERRAIN_NORMAL: {
                this.terrainGenerator = new NormalTerrainGenerator();
                break;
            }
            case TERRAIN_CAVERN_OLD: {
                this.terrainGenerator = new CavernTerrainGenerator(CavernTerrainGenerator.CavernHeight.HEIGHT_256);
                break;
            }
            case TERRAIN_ISLAND: {
                this.terrainGenerator = new IslandTerrainGenerator(0);
                break;
            }
            case TERRAIN_ISLANDS: {
                this.terrainGenerator = new IslandTerrainGenerator(4);
                break;
            }
            case TERRAIN_CHAOTIC: {
                this.terrainGenerator = new IslandTerrainGenerator(1);
                break;
            }
            case TERRAIN_PLATEAUS: {
                this.terrainGenerator = new IslandTerrainGenerator(3);
                break;
            }
            case TERRAIN_GRID: {
                this.terrainGenerator = new GridTerrainGenerator();
                break;
            }
            case TERRAIN_CAVERN: {
                this.terrainGenerator = new CavernTerrainGenerator(null);
                break;
            }
            case TERRAIN_LOW_CAVERN: {
                this.terrainGenerator = new CavernTerrainGenerator(CavernTerrainGenerator.CavernHeight.HEIGHT_128);
                break;
            }
            case TERRAIN_FLOODED_CAVERN: {
                this.terrainGenerator = new CavernTerrainGenerator(CavernTerrainGenerator.CavernHeight.HEIGHT_128);
                break;
            }
            case TERRAIN_LIQUID: {
                this.terrainGenerator = new LiquidTerrainGenerator();
                break;
            }
            case TERRAIN_SOLID: {
                this.terrainGenerator = new FlatTerrainGenerator(127);
                break;
            }
            case TERRAIN_WAVES: {
                this.terrainGenerator = new WavesTerrainGenerator(false);
                break;
            }
            case TERRAIN_FILLEDWAVES: {
                this.terrainGenerator = new WavesTerrainGenerator(true);
                break;
            }
            case TERRAIN_ROUGH: {
                this.terrainGenerator = new RoughTerrainGenerator(false);
                break;
            }
            default: {
                this.terrainGenerator = new VoidTerrainGenerator();
            }
        }
        this.terrainGenerator.setup(world, this);
        this.extraSpawns = new ArrayList<BiomeGenBase.SpawnListEntry>();
        this.extraSpawnsMax = new ArrayList<Integer>();
        for (MobDescriptor mob : this.dimensionInformation.getExtraMobs()) {
            Class<? extends EntityLiving> entityClass = mob.getEntityClass();
            this.extraSpawns.add(new BiomeGenBase.SpawnListEntry(entityClass, mob.getSpawnChance(), mob.getMinGroup(), mob.getMaxGroup()));
            this.extraSpawnsMax.add(mob.getMaxLoaded());
        }
    }

    public Chunk func_73158_c(int chunkX, int chunkZ) {
        return this.func_73154_d(chunkX, chunkZ);
    }

    public Chunk func_73154_d(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L + 123456L);
        Block[] ablock = new Block[65536];
        byte[] abyte = new byte[65536];
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        this.terrainGenerator.generate(chunkX, chunkZ, ablock, abyte);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
        this.terrainGenerator.replaceBlocksForBiome(chunkX, chunkZ, ablock, abyte, this.biomesForGeneration);
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_TENDRILS)) {
            this.tendrilGenerator.generate(this.worldObj, chunkX, chunkZ, ablock, abyte);
        }
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_CANYONS)) {
            this.canyonGenerator.generate(this.worldObj, chunkX, chunkZ, ablock, abyte);
        }
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_PYRAMIDS)) {
            this.pyramidGenerator.generate(this.worldObj, chunkX, chunkZ, ablock, abyte);
        }
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_ORBS)) {
            this.sphereGenerator.generate(this.worldObj, chunkX, chunkZ, ablock, abyte);
        }
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_HUGEORBS)) {
            this.hugeSphereGenerator.generate(this.worldObj, chunkX, chunkZ, ablock, abyte);
        }
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_LIQUIDORBS)) {
            this.liquidSphereGenerator.generate(this.worldObj, chunkX, chunkZ, ablock, abyte);
        }
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_HUGELIQUIDORBS)) {
            this.hugeLiquidSphereGenerator.generate(this.worldObj, chunkX, chunkZ, ablock, abyte);
        }
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_CAVES)) {
            this.caveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, ablock);
        }
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_DENSE_CAVES)) {
            this.denseCaveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, ablock);
        }
        if (this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_RAVINES)) {
            this.ravineGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, ablock);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_MINESHAFT)) {
            this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, ablock);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_VILLAGE)) {
            this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, ablock);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_STRONGHOLD)) {
            this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, ablock);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_FORTRESS)) {
            this.genNetherBridge.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, ablock);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_SCATTERED)) {
            this.scatteredFeatureGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, ablock);
        }
        Chunk chunk = new Chunk(this.worldObj, ablock, abyte, chunkX, chunkZ);
        byte[] abyte1 = chunk.func_76605_m();
        for (int k = 0; k < abyte1.length; ++k) {
            abyte1[k] = (byte)this.biomesForGeneration[k].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public boolean func_73149_a(int chunkX, int chunkZ) {
        return true;
    }

    public void func_73153_a(IChunkProvider chunkProvider, int chunkX, int chunkZ) {
        int i2;
        int l1;
        int k1;
        boolean flag;
        BiomeGenBase biomegenbase;
        int z;
        int x;
        block13: {
            block14: {
                BlockFalling.field_149832_M = true;
                x = chunkX * 16;
                z = chunkZ * 16;
                biomegenbase = this.worldObj.func_72807_a(x + 16, z + 16);
                this.rand.setSeed(this.worldObj.func_72905_C());
                long i1 = this.rand.nextLong() / 2L * 2L + 1L;
                long j1 = this.rand.nextLong() / 2L * 2L + 1L;
                this.rand.setSeed((long)chunkX * i1 + (long)chunkZ * j1 ^ this.worldObj.func_72905_C());
                flag = false;
                MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(chunkProvider, this.worldObj, this.rand, chunkX, chunkZ, flag));
                if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_MINESHAFT)) {
                    this.mineshaftGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
                }
                if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_VILLAGE)) {
                    flag = this.villageGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
                }
                if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_STRONGHOLD)) {
                    this.strongholdGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
                }
                if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_FORTRESS)) {
                    this.genNetherBridge.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
                }
                if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_SCATTERED)) {
                    this.scatteredFeatureGenerator.func_75051_a(this.worldObj, this.rand, chunkX, chunkZ);
                }
                if (!this.dimensionInformation.hasFeatureType(FeatureType.FEATURE_LAKES)) break block13;
                if (this.dimensionInformation.getFluidsForLakes().length != 0) break block14;
                if (biomegenbase != BiomeGenBase.field_76769_d && biomegenbase != BiomeGenBase.field_76786_s && !flag && this.rand.nextInt(4) == 0 && TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
                    k1 = x + this.rand.nextInt(16) + 8;
                    l1 = this.rand.nextInt(256);
                    i2 = z + this.rand.nextInt(16) + 8;
                    new WorldGenLakes(Blocks.field_150355_j).func_76484_a(this.worldObj, this.rand, k1, l1, i2);
                }
                if (!TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA) || flag || this.rand.nextInt(8) != 0) break block13;
                k1 = x + this.rand.nextInt(16) + 8;
                l1 = this.rand.nextInt(this.rand.nextInt(248) + 8);
                i2 = z + this.rand.nextInt(16) + 8;
                if (l1 >= 63 && this.rand.nextInt(10) != 0) break block13;
                new WorldGenLakes(Blocks.field_150353_l).func_76484_a(this.worldObj, this.rand, k1, l1, i2);
                break block13;
            }
            for (Block liquid : this.dimensionInformation.getFluidsForLakes()) {
                if (flag || this.rand.nextInt(4) != 0 || !TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) continue;
                k1 = x + this.rand.nextInt(16) + 8;
                l1 = this.rand.nextInt(256);
                i2 = z + this.rand.nextInt(16) + 8;
                new WorldGenLakes(liquid).func_76484_a(this.worldObj, this.rand, k1, l1, i2);
            }
        }
        boolean doGen = false;
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_DUNGEON)) {
            doGen = TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON);
            for (k1 = 0; doGen && k1 < 8; ++k1) {
                l1 = x + this.rand.nextInt(16) + 8;
                i2 = this.rand.nextInt(256);
                int j2 = z + this.rand.nextInt(16) + 8;
                new WorldGenDungeons().func_76484_a(this.worldObj, this.rand, l1, i2, j2);
            }
        }
        biomegenbase.func_76728_a(this.worldObj, this.rand, x, z);
        if (TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biomegenbase, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.rand);
        }
        x += 8;
        z += 8;
        doGen = TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE);
        for (k1 = 0; doGen && k1 < 16; ++k1) {
            for (l1 = 0; l1 < 16; ++l1) {
                i2 = this.worldObj.func_72874_g(x + k1, z + l1);
                if (this.worldObj.func_72884_u(k1 + x, i2 - 1, l1 + z)) {
                    this.worldObj.func_147465_d(k1 + x, i2 - 1, l1 + z, Blocks.field_150432_aD, 0, 2);
                }
                if (!this.worldObj.func_147478_e(k1 + x, i2, l1 + z, true)) continue;
                this.worldObj.func_147465_d(k1 + x, i2, l1 + z, Blocks.field_150431_aC, 0, 2);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(chunkProvider, this.worldObj, this.rand, chunkX, chunkZ, flag));
        BlockFalling.field_149832_M = false;
    }

    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate progressUpdate) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType creatureType, int x, int y, int z) {
        ArrayList<BiomeGenBase.SpawnListEntry> creatures;
        block4: {
            block3: {
                creatures = this.getDefaultCreatures(creatureType, x, y, z);
                if (this.extraSpawns.isEmpty()) {
                    return creatures;
                }
                if (creatureType != EnumCreatureType.ambient) break block3;
                creatures = new ArrayList<BiomeGenBase.SpawnListEntry>(creatures);
                for (int i = 0; i < this.extraSpawns.size(); ++i) {
                    int count;
                    Class entityClass = this.extraSpawns.get((int)i).field_76300_b;
                    if (!IAnimals.class.isAssignableFrom(entityClass) || (count = this.worldObj.func_72907_a(entityClass)) >= this.extraSpawnsMax.get(i)) continue;
                    creatures.add(this.extraSpawns.get(i));
                }
                break block4;
            }
            if (creatureType != EnumCreatureType.monster) break block4;
            creatures = new ArrayList(creatures);
            for (int i = 0; i < this.extraSpawns.size(); ++i) {
                int count;
                Class entityClass = this.extraSpawns.get((int)i).field_76300_b;
                if (!IMob.class.isAssignableFrom(entityClass) || (count = this.worldObj.func_72907_a(entityClass)) >= this.extraSpawnsMax.get(i)) continue;
                creatures.add(this.extraSpawns.get(i));
            }
        }
        return creatures;
    }

    private List getDefaultCreatures(EnumCreatureType creatureType, int x, int y, int z) {
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(x, z);
        if (creatureType == EnumCreatureType.monster) {
            if (this.dimensionInformation.isPeaceful()) {
                return Collections.emptyList();
            }
            if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_SCATTERED) && this.scatteredFeatureGenerator.func_143030_a(x, y, z)) {
                return this.scatteredFeatureGenerator.func_82667_a();
            }
            if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_FORTRESS)) {
                if (this.genNetherBridge.func_75048_a(x, y, z)) {
                    return this.genNetherBridge.func_75059_a();
                }
                if (this.genNetherBridge.func_142038_b(x, y, z) && this.worldObj.func_147439_a(x, y - 1, z) == Blocks.field_150385_bj) {
                    return this.genNetherBridge.func_75059_a();
                }
            }
        } else if (creatureType == EnumCreatureType.ambient && this.dimensionInformation.isNoanimals()) {
            return Collections.emptyList();
        }
        return biomegenbase.func_76747_a(creatureType);
    }

    public ChunkPosition func_147416_a(World world, String name, int x, int y, int z) {
        return "Stronghold".equals(name) && this.strongholdGenerator != null ? this.strongholdGenerator.func_151545_a(world, x, y, z) : null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int chunkX, int chunkZ) {
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_MINESHAFT)) {
            this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, null);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_VILLAGE)) {
            this.villageGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, null);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_STRONGHOLD)) {
            this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, null);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_FORTRESS)) {
            this.genNetherBridge.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, null);
        }
        if (this.dimensionInformation.hasStructureType(StructureType.STRUCTURE_SCATTERED)) {
            this.scatteredFeatureGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, null);
        }
    }
}

