/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.List;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.storagemonitor.PacketInventoryReady;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PacketGetInventory
implements IMessage,
IMessageHandler<PacketGetInventory, PacketInventoryReady> {
    private int x;
    private int y;
    private int z;
    private int cx;
    private int cy;
    private int cz;

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.cx = buf.readInt();
        this.cy = buf.readInt();
        this.cz = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.cx);
        buf.writeInt(this.cy);
        buf.writeInt(this.cz);
    }

    public PacketGetInventory() {
    }

    public PacketGetInventory(int x, int y, int z, int cx, int cy, int cz) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.cx = cx;
        this.cy = cy;
        this.cz = cz;
    }

    public PacketInventoryReady onMessage(PacketGetInventory message, MessageContext ctx) {
        TileEntity te = ctx.getServerHandler().field_147369_b.field_70170_p.func_147438_o(message.x, message.y, message.z);
        if (!(te instanceof StorageScannerTileEntity)) {
            Logging.log((String)"createGetInventoryPacket: TileEntity is not a StorageScannerTileEntity!");
            return null;
        }
        StorageScannerTileEntity storageScannerTileEntity = (StorageScannerTileEntity)te;
        List<ItemStack> items = storageScannerTileEntity.getInventoryForBlock(message.cx, message.cy, message.cz);
        return new PacketInventoryReady(message.x, message.y, message.z, items);
    }
}

