/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spawner;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.lib.api.Infusable;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.spawner.GuiSpawner;
import mcjty.rftools.blocks.spawner.SpawnerContainer;
import mcjty.rftools.blocks.spawner.SpawnerTileEntity;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class SpawnerBlock
extends GenericRFToolsBlock
implements Infusable {
    public SpawnerBlock() {
        super(Material.field_151573_f, SpawnerTileEntity.class, true);
        this.func_149663_c("spawnerBlock");
        this.func_149647_a(RFTools.tabRfTools);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "This block can spawn creatures. It needs a syringe");
            list.add(EnumChatFormatting.WHITE + "of the appropriate type, RF power and also it");
            list.add(EnumChatFormatting.WHITE + "needs beams of energized matter.");
            list.add(EnumChatFormatting.YELLOW + "Infusing bonus: reduced power usage.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof SpawnerTileEntity) {
            SpawnerTileEntity spawnerTileEntity = (SpawnerTileEntity)te;
            float[] matter = spawnerTileEntity.getMatter();
            currenttip.add(EnumChatFormatting.GREEN + "Key Matter: " + matter[0]);
            currenttip.add(EnumChatFormatting.GREEN + "Bulk Matter: " + matter[1]);
            currenttip.add(EnumChatFormatting.GREEN + "Living Matter: " + matter[2]);
        }
        return currenttip;
    }

    public int getGuiID() {
        return RFTools.GUI_SPAWNER;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        SpawnerTileEntity spawnerTileEntity = (SpawnerTileEntity)tileEntity;
        SpawnerContainer spawnerContainer = new SpawnerContainer(entityPlayer, spawnerTileEntity);
        return new GuiSpawner(spawnerTileEntity, spawnerContainer);
    }

    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        return new SpawnerContainer(entityPlayer, (SpawnerTileEntity)tileEntity);
    }

    protected boolean wrenchUse(World world, int x, int y, int z, EntityPlayer player) {
        if (world.field_72995_K) {
            SpawnerTileEntity spawnerTileEntity = (SpawnerTileEntity)world.func_147438_o(x, y, z);
            world.func_72980_b((double)x, (double)y, (double)z, "note.pling", 1.0f, 1.0f, false);
            spawnerTileEntity.useWrench(player);
        }
        return true;
    }

    public String getIdentifyingIconName() {
        return "machineSpawner";
    }
}

