/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.TextEvent;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.Argument;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.logic.CounterTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;

public class GuiCounter
extends GenericGuiContainer<CounterTileEntity> {
    public static final int COUNTER_WIDTH = 200;
    public static final int COUNTER_HEIGHT = 30;
    private TextField counterField;
    private TextField currentField;

    public GuiCounter(CounterTileEntity counterTileEntity, Container container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)counterTileEntity, container, RFTools.GUI_MANUAL_MAIN, "counter");
        this.field_146999_f = 200;
        this.field_147000_g = 30;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout((Layout)new VerticalLayout());
        this.counterField = ((TextField)new TextField(this.field_146297_k, (Gui)this).setTooltips(new String[]{"Set the counter in pulses"})).addTextEvent(new TextEvent(){

            public void textChanged(Widget parent, String newText) {
                GuiCounter.this.setCounter();
            }
        });
        int delay = ((CounterTileEntity)this.tileEntity).getCounter();
        if (delay <= 0) {
            delay = 1;
        }
        this.counterField.setText(String.valueOf(delay));
        this.currentField = ((TextField)new TextField(this.field_146297_k, (Gui)this).setTooltips(new String[]{"Set the current value", "(fires when it reaches counter)"})).addTextEvent(new TextEvent(){

            public void textChanged(Widget parent, String newText) {
                GuiCounter.this.setCurrent();
            }
        });
        int current = ((CounterTileEntity)this.tileEntity).getCurrent();
        if (current < 0) {
            current = 0;
        }
        this.currentField.setText(String.valueOf(current));
        Panel bottomPanel = (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Counter:"))).addChild((Widget)this.counterField)).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Current:"))).addChild((Widget)this.currentField);
        toplevel.addChild((Widget)bottomPanel);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, 200, 30));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private void setCounter() {
        int counter;
        String d = this.counterField.getText();
        try {
            counter = Integer.parseInt(d);
        }
        catch (NumberFormatException e) {
            counter = 1;
        }
        ((CounterTileEntity)this.tileEntity).setCounter(counter);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setCounter", new Argument[]{new Argument("counter", counter)});
    }

    private void setCurrent() {
        int current;
        String d = this.currentField.getText();
        try {
            current = Integer.parseInt(d);
        }
        catch (NumberFormatException e) {
            current = 0;
        }
        ((CounterTileEntity)this.tileEntity).setCounter(current);
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setCurrent", new Argument[]{new Argument("current", current)});
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.drawWindow();
    }
}

