/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.dimlets;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericEnergyStorageTileEntity;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.varia.BlockTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.dimlets.DimensionEditorContainer;
import mcjty.rftools.blocks.dimlets.DimensionEditorTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.block.Block;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiDimensionEditor
extends GenericGuiContainer<DimensionEditorTileEntity> {
    public static final int EDITOR_WIDTH = 180;
    public static final int EDITOR_HEIGHT = 152;
    private EnergyBar energyBar;
    private ImageLabel arrow;
    private Label percentage;
    private Label destroy;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/dimensioneditor.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");

    public GuiDimensionEditor(DimensionEditorTileEntity dimensionEditorTileEntity, DimensionEditorContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)dimensionEditorTileEntity, (Container)container, RFTools.GUI_MANUAL_DIMENSION, "editor");
        GenericEnergyStorageTileEntity.setCurrentRF((int)dimensionEditorTileEntity.getEnergyStored(ForgeDirection.DOWN));
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxEnergyStored = ((DimensionEditorTileEntity)this.tileEntity).getMaxEnergyStored(ForgeDirection.DOWN);
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 7, 8, 54))).setShowText(false);
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        this.arrow = new ImageLabel(this.field_146297_k, (Gui)this).setImage(iconGuiElements, 192, 0);
        this.arrow.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(90, 26, 16, 16));
        this.destroy = new Label(this.field_146297_k, (Gui)this).setColor(0xFF0000);
        this.destroy.setText("Destroying dimension!");
        this.destroy.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(30, 53, 150, 16));
        this.destroy.setVisible(false);
        this.percentage = new Label(this.field_146297_k, (Gui)this).setText("0%");
        this.percentage.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(80, 43, 40, 16));
        AbstractContainerWidget toplevel = ((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.energyBar)).addChild((Widget)this.arrow)).addChild((Widget)this.percentage)).addChild((Widget)this.destroy);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        ((DimensionEditorTileEntity)this.tileEntity).requestRfFromServer(RFToolsMessages.INSTANCE);
        ((DimensionEditorTileEntity)this.tileEntity).requestBuildingPercentage();
    }

    protected void func_146976_a(float v, int i, int i2) {
        Block block;
        int pct = DimensionEditorTileEntity.getEditPercentage();
        if (pct > 0) {
            this.arrow.setImage(iconGuiElements, 144, 0);
        } else {
            this.arrow.setImage(iconGuiElements, 192, 0);
        }
        this.percentage.setText(pct + "%");
        this.drawWindow();
        this.destroy.setVisible(false);
        Slot slot = this.field_147002_h.func_75139_a(0);
        if (slot.func_75216_d() && (block = BlockTools.getBlock((ItemStack)slot.func_75211_c())) == Blocks.field_150335_W) {
            this.destroy.setVisible(true);
        }
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        ((DimensionEditorTileEntity)this.tileEntity).requestRfFromServer(RFToolsMessages.INSTANCE);
        ((DimensionEditorTileEntity)this.tileEntity).requestBuildingPercentage();
    }
}

