/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.dimletconstruction;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.dimletconstruction.BiomeAbsorberTileEntity;
import mcjty.rftools.blocks.dimletconstruction.DimletConstructionConfiguration;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import org.lwjgl.input.Keyboard;

public class BiomeAbsorberBlock
extends GenericRFToolsBlock {
    public BiomeAbsorberBlock() {
        super(Material.field_151573_f, BiomeAbsorberTileEntity.class, false);
        this.func_149663_c("biomeAbsorberBlock");
        this.func_149647_a(RFTools.tabRfTools);
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        BiomeGenBase biome;
        int biomeID;
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tagCompound = accessor.getNBTData();
        if (tagCompound != null && (biomeID = tagCompound.func_74762_e("biome")) != -1 && (biome = BiomeGenBase.func_150568_d((int)biomeID)) != null) {
            int absorbing = tagCompound.func_74762_e("absorbing");
            int pct = (DimletConstructionConfiguration.maxBiomeAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxBiomeAbsorbtion;
            currenttip.add(EnumChatFormatting.GREEN + "Biome: " + biome.field_76791_y + " (" + pct + "%)");
        }
        return currenttip;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        BiomeGenBase biome;
        int biomeID;
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && (biomeID = tagCompound.func_74762_e("biome")) != -1 && (biome = BiomeGenBase.func_150568_d((int)biomeID)) != null) {
            list.add(EnumChatFormatting.GREEN + "Biome: " + biome.field_76791_y);
            int absorbing = tagCompound.func_74762_e("absorbing");
            int pct = (DimletConstructionConfiguration.maxBiomeAbsorbtion - absorbing) * 100 / DimletConstructionConfiguration.maxBiomeAbsorbtion;
            list.add(EnumChatFormatting.GREEN + "Absorbed: " + pct + "%");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "Place this block in an area and it will");
            list.add(EnumChatFormatting.WHITE + "gradually absorb the essence of the biome it is in.");
            list.add(EnumChatFormatting.WHITE + "You can use the end result in the Dimlet Workbench.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        this.restoreBlockFromNBT(world, x, y, z, itemStack);
        if (!world.field_72995_K) {
            BiomeAbsorberTileEntity biomeAbsorberTileEntity = (BiomeAbsorberTileEntity)world.func_147438_o(x, y, z);
            biomeAbsorberTileEntity.placeDown();
        }
        this.setOwner(world, x, y, z, entityLivingBase);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.iconSide = iconRegister.func_94245_a("rftools:" + this.getSideIconName());
    }

    public String getSideIconName() {
        return "biomeAbsorber";
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149701_w() {
        return 0;
    }

    public int getGuiID() {
        return -1;
    }
}

