/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.crafter;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.rftools.blocks.crafter.CrafterBaseTE;
import mcjty.rftools.blocks.crafter.CraftingRecipe;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PacketCrafter
implements IMessage,
IMessageHandler<PacketCrafter, IMessage> {
    private int x;
    private int y;
    private int z;
    private int recipeIndex;
    private ItemStack[] items;
    private boolean keepOne;
    private boolean craftInternal;

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.keepOne = buf.readBoolean();
        this.craftInternal = buf.readBoolean();
        this.recipeIndex = buf.readByte();
        int l = buf.readByte();
        if (l == 0) {
            this.items = null;
        } else {
            this.items = new ItemStack[l];
            for (int i = 0; i < l; ++i) {
                boolean b = buf.readBoolean();
                this.items[i] = b ? NetworkTools.readItemStack((ByteBuf)buf) : null;
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeBoolean(this.keepOne);
        buf.writeBoolean(this.craftInternal);
        buf.writeByte(this.recipeIndex);
        if (this.items != null) {
            buf.writeByte(this.items.length);
            for (ItemStack item : this.items) {
                if (item == null) {
                    buf.writeBoolean(false);
                    continue;
                }
                buf.writeBoolean(true);
                NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)item);
            }
        } else {
            buf.writeByte(0);
        }
    }

    public PacketCrafter() {
    }

    public PacketCrafter(int x, int y, int z, int recipeIndex, InventoryCrafting inv, ItemStack result, boolean keepOne, boolean craftInternal) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.recipeIndex = recipeIndex;
        this.items = new ItemStack[10];
        if (inv != null) {
            for (int i = 0; i < 9; ++i) {
                this.items[i] = inv.func_70301_a(i);
            }
        }
        this.items[9] = result;
        this.keepOne = keepOne;
        this.craftInternal = craftInternal;
    }

    public IMessage onMessage(PacketCrafter message, MessageContext ctx) {
        TileEntity te = ctx.getServerHandler().field_147369_b.field_70170_p.func_147438_o(message.x, message.y, message.z);
        if (!(te instanceof CrafterBaseTE)) {
            System.out.println("createPowerMonitotPacket: TileEntity is not a CrafterBlockTileEntity!");
            return null;
        }
        CrafterBaseTE crafterBlockTileEntity = (CrafterBaseTE)te;
        if (message.recipeIndex != -1) {
            CraftingRecipe recipe = crafterBlockTileEntity.getRecipe(message.recipeIndex);
            recipe.setRecipe(message.items, message.items[9]);
            recipe.setKeepOne(message.keepOne);
            recipe.setCraftInternal(message.craftInternal);
            crafterBlockTileEntity.func_70296_d();
            crafterBlockTileEntity.func_145831_w().func_147471_g(crafterBlockTileEntity.field_145851_c, crafterBlockTileEntity.field_145848_d, crafterBlockTileEntity.field_145849_e);
        }
        return null;
    }
}

