/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Set;
import mcjty.lib.varia.Coordinate;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.blockprotector.BlockProtectorTileEntity;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.shapecard.ShapeCardItem;
import mcjty.rftools.items.smartwrench.SmartWrenchItem;
import mcjty.rftools.items.smartwrench.SmartWrenchMode;
import mcjty.rftools.render.DefaultISBRH;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderWorldLastEventHandler {
    private static final ResourceLocation yellowglow = new ResourceLocation("rftools", "textures/blocks/yellowglow.png");

    public static void tick(RenderWorldLastEvent evt) {
        RenderWorldLastEventHandler.renderHilightedBlock(evt);
        RenderWorldLastEventHandler.renderProtectedBlocks(evt);
    }

    private static void renderProtectedBlocks(RenderWorldLastEvent evt) {
        GlobalCoordinate current;
        int mode;
        Minecraft mc = Minecraft.func_71410_x();
        EntityClientPlayerMP p = mc.field_71439_g;
        ItemStack heldItem = p.func_70694_bm();
        if (heldItem == null) {
            return;
        }
        if (heldItem.func_77973_b() == ModItems.smartWrenchItem) {
            BlockProtectorTileEntity blockProtectorTileEntity;
            Set<Coordinate> coordinates;
            TileEntity te;
            GlobalCoordinate current2;
            if (SmartWrenchItem.getCurrentMode(heldItem) == SmartWrenchMode.MODE_SELECT && (current2 = SmartWrenchItem.getCurrentBlock(heldItem)) != null && current2.getDimension() == mc.field_71441_e.field_73011_w.field_76574_g && (te = mc.field_71441_e.func_147438_o(current2.getCoordinate().getX(), current2.getCoordinate().getY(), current2.getCoordinate().getZ())) instanceof BlockProtectorTileEntity && !(coordinates = (blockProtectorTileEntity = (BlockProtectorTileEntity)te).getProtectedBlocks()).isEmpty()) {
                RenderWorldLastEventHandler.renderHighlightedBlocks(evt, p, new Coordinate(te.field_145851_c, te.field_145848_d, te.field_145849_e), coordinates);
            }
        } else if (heldItem.func_77973_b() == ModItems.shapeCardItem && ((mode = ShapeCardItem.getMode(heldItem)) == 1 || mode == 2) && (current = ShapeCardItem.getCurrentBlock(heldItem)) != null && current.getDimension() == mc.field_71441_e.field_73011_w.field_76574_g) {
            HashSet<Coordinate> coordinates = new HashSet<Coordinate>();
            coordinates.add(new Coordinate(0, 0, 0));
            if (mode == 2) {
                Coordinate cur = current.getCoordinate();
                Coordinate c = ShapeCardItem.getCorner1(heldItem);
                if (c != null) {
                    coordinates.add(new Coordinate(c.getX() - cur.getX(), c.getY() - cur.getY(), c.getZ() - cur.getZ()));
                }
            }
            RenderWorldLastEventHandler.renderHighlightedBlocks(evt, p, current.getCoordinate(), coordinates);
        }
    }

    private static void renderHighlightedBlocks(RenderWorldLastEvent evt, EntityClientPlayerMP p, Coordinate base, Set<Coordinate> coordinates) {
        double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)evt.partialTicks;
        double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)evt.partialTicks;
        double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)evt.partialTicks;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        boolean depth = GL11.glIsEnabled((int)2929);
        GL11.glDisable((int)2929);
        boolean txt2D = GL11.glIsEnabled((int)3553);
        GL11.glEnable((int)3553);
        Tessellator tessellator = Tessellator.field_78398_a;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(yellowglow);
        tessellator.func_78382_b();
        tessellator.func_78370_a(255, 255, 255, 64);
        tessellator.func_78380_c(240);
        boolean blending = GL11.glIsEnabled((int)3042);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        for (Coordinate coordinate : coordinates) {
            float x = base.getX() + coordinate.getX();
            float y = base.getY() + coordinate.getY();
            float z = base.getZ() + coordinate.getZ();
            tessellator.func_78372_c(x, y, z);
            DefaultISBRH.addSideFullTexture(tessellator, ForgeDirection.UP.ordinal(), 1.1f, -0.05f);
            DefaultISBRH.addSideFullTexture(tessellator, ForgeDirection.DOWN.ordinal(), 1.1f, -0.05f);
            DefaultISBRH.addSideFullTexture(tessellator, ForgeDirection.NORTH.ordinal(), 1.1f, -0.05f);
            DefaultISBRH.addSideFullTexture(tessellator, ForgeDirection.SOUTH.ordinal(), 1.1f, -0.05f);
            DefaultISBRH.addSideFullTexture(tessellator, ForgeDirection.WEST.ordinal(), 1.1f, -0.05f);
            DefaultISBRH.addSideFullTexture(tessellator, ForgeDirection.EAST.ordinal(), 1.1f, -0.05f);
            tessellator.func_78372_c(-x, -y, -z);
        }
        tessellator.func_78381_a();
        if (!blending) {
            GL11.glDisable((int)3042);
        }
        GL11.glDisable((int)3553);
        GL11.glColor3ub((byte)-128, (byte)90, (byte)0);
        GL11.glLineWidth((float)2.0f);
        tessellator.func_78371_b(1);
        for (Coordinate coordinate : coordinates) {
            RenderWorldLastEventHandler.renderHighLightedBlocksOutline(tessellator, base.getX() + coordinate.getX(), base.getY() + coordinate.getY(), base.getZ() + coordinate.getZ());
        }
        tessellator.func_78381_a();
        if (depth) {
            GL11.glEnable((int)2929);
        }
        if (txt2D) {
            GL11.glEnable((int)3553);
        }
        GL11.glPopMatrix();
    }

    private static void renderHighLightedBlocksOutline(Tessellator tessellator, float mx, float my, float mz) {
        tessellator.func_78377_a((double)mx, (double)my, (double)mz);
        tessellator.func_78377_a((double)(mx + 1.0f), (double)my, (double)mz);
        tessellator.func_78377_a((double)mx, (double)my, (double)mz);
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f), (double)mz);
        tessellator.func_78377_a((double)mx, (double)my, (double)mz);
        tessellator.func_78377_a((double)mx, (double)my, (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f));
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz);
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f), (double)mz);
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f));
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f), (double)mz);
        tessellator.func_78377_a((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz);
        tessellator.func_78377_a((double)(mx + 1.0f), (double)my, (double)mz);
        tessellator.func_78377_a((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)my, (double)mz);
        tessellator.func_78377_a((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz);
        tessellator.func_78377_a((double)mx, (double)my, (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f));
        tessellator.func_78377_a((double)mx, (double)my, (double)(mz + 1.0f));
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f));
    }

    private static void renderHilightedBlock(RenderWorldLastEvent evt) {
        Coordinate c = RFTools.instance.clientInfo.getHilightedBlock();
        if (c == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        long time = System.currentTimeMillis();
        if (time > RFTools.instance.clientInfo.getExpireHilight()) {
            RFTools.instance.clientInfo.hilightBlock(null, -1L);
            return;
        }
        if ((time / 500L & 1L) == 0L) {
            return;
        }
        EntityClientPlayerMP p = mc.field_71439_g;
        double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)evt.partialTicks;
        double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)evt.partialTicks;
        double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)evt.partialTicks;
        GL11.glPushMatrix();
        GL11.glColor3ub((byte)-1, (byte)0, (byte)0);
        GL11.glLineWidth((float)3.0f);
        GL11.glTranslated((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        boolean depth = GL11.glIsEnabled((int)2929);
        GL11.glDisable((int)2929);
        boolean txt2D = GL11.glIsEnabled((int)3553);
        GL11.glDisable((int)3553);
        Tessellator tessellator = Tessellator.field_78398_a;
        float mx = c.getX();
        float my = c.getY();
        float mz = c.getZ();
        tessellator.func_78371_b(1);
        tessellator.func_78377_a((double)mx, (double)my, (double)mz);
        tessellator.func_78377_a((double)(mx + 1.0f), (double)my, (double)mz);
        tessellator.func_78377_a((double)mx, (double)my, (double)mz);
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f), (double)mz);
        tessellator.func_78377_a((double)mx, (double)my, (double)mz);
        tessellator.func_78377_a((double)mx, (double)my, (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f));
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)(my + 1.0f), (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz);
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f), (double)mz);
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f));
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f), (double)mz);
        tessellator.func_78377_a((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz);
        tessellator.func_78377_a((double)(mx + 1.0f), (double)my, (double)mz);
        tessellator.func_78377_a((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)my, (double)mz);
        tessellator.func_78377_a((double)(mx + 1.0f), (double)(my + 1.0f), (double)mz);
        tessellator.func_78377_a((double)mx, (double)my, (double)(mz + 1.0f));
        tessellator.func_78377_a((double)(mx + 1.0f), (double)my, (double)(mz + 1.0f));
        tessellator.func_78377_a((double)mx, (double)my, (double)(mz + 1.0f));
        tessellator.func_78377_a((double)mx, (double)(my + 1.0f), (double)(mz + 1.0f));
        tessellator.func_78381_a();
        if (depth) {
            GL11.glEnable((int)2929);
        }
        if (txt2D) {
            GL11.glEnable((int)3553);
        }
        GL11.glPopMatrix();
    }
}

