/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.multiblock;

import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraftforge.common.util.ForgeDirection;

public class MultiBlockFormer {
    Queue<IMultiBlock> blocksToCheck = new LinkedList<IMultiBlock>();
    MultiBlockGrid theGrid;

    public void formGrid(IMultiBlock iMultiBlock) {
        this.theGrid = iMultiBlock.getNewGrid();
        iMultiBlock.setGrid(this.theGrid);
        this.theGrid.addBlock(iMultiBlock);
        this.blocksToCheck.add(iMultiBlock);
        while (!this.blocksToCheck.isEmpty()) {
            this.checkMultiBlock(this.blocksToCheck.remove());
        }
        iMultiBlock.getGrid().resetMultiBlocks();
    }

    private void checkMultiBlock(IMultiBlock iMultiBlock) {
        if (!iMultiBlock.isValidForForming()) {
            return;
        }
        iMultiBlock.onNeighborBlockChange();
        iMultiBlock.setInvalidForForming();
        for (byte by = 0; by < ForgeDirection.VALID_DIRECTIONS.length; by = (byte)(by + 1)) {
            IMultiBlock iMultiBlock2;
            if (!iMultiBlock.isSideConnected(by) || (iMultiBlock2 = iMultiBlock.getConnectedSide(by)) == null || !iMultiBlock2.isValidForForming()) continue;
            if (iMultiBlock2.getGrid() == null && this.theGrid.canAddBlock(iMultiBlock2)) {
                iMultiBlock2.setGrid(this.theGrid);
                this.theGrid.addBlock(iMultiBlock2);
                this.blocksToCheck.add(iMultiBlock2);
                continue;
            }
            if (this.theGrid.canAddBlock(iMultiBlock2) && iMultiBlock2.getGrid() != null && this.theGrid.canGridsMerge(iMultiBlock2.getGrid())) {
                if (this.theGrid == iMultiBlock2.getGrid()) continue;
                if (this.theGrid.size() >= iMultiBlock2.getGrid().size()) {
                    this.theGrid.mergeGrids(iMultiBlock2.getGrid());
                    continue;
                }
                iMultiBlock2.getGrid().mergeGrids(this.theGrid);
                this.theGrid = iMultiBlock2.getGrid();
                continue;
            }
            iMultiBlock.setNotConnected(by);
            iMultiBlock2.setNotConnected((byte)(by ^ 1));
        }
    }
}

