/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.fluid;

import cofh.lib.util.helpers.FluidHelper;
import cofh.thermaldynamics.duct.fluid.FluidGrid;
import cofh.thermaldynamics.duct.fluid.TileFluidDuct;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class FluidGridSuper
extends FluidGrid {
    int nodeTracker;
    boolean isSendingFluid;
    TileFluidDuct[] nodeList = null;

    public FluidGridSuper(World world) {
        super(world);
    }

    @Override
    public void tickGrid() {
        super.tickGrid();
        int n = 0;
        if (this.nodeList == null) {
            this.nodeList = new TileFluidDuct[this.nodeSet.size()];
            for (IMultiBlock iMultiBlock : this.nodeSet) {
                this.nodeList[n] = (TileFluidDuct)iMultiBlock;
                ++n;
            }
        }
    }

    public int sendFluid(FluidStack fluidStack, boolean bl) {
        int n;
        if (fluidStack == null || !FluidHelper.isFluidEqualOrNull((FluidStack)this.myTank.getFluid(), (FluidStack)fluidStack) || this.isSendingFluid) {
            return 0;
        }
        int n2 = fluidStack.amount;
        int n3 = this.myTank.fill(fluidStack, !bl);
        if ((n2 -= n3) <= 0) {
            return fluidStack.amount;
        }
        int n4 = this.nodeTracker;
        TileFluidDuct[] tileFluidDuctArray = this.nodeList;
        if (tileFluidDuctArray == null || tileFluidDuctArray.length == 0) {
            return fluidStack.amount - n2;
        }
        this.isSendingFluid = true;
        for (n = this.nodeTracker; n < tileFluidDuctArray.length && n2 > 0; ++n) {
            if ((n2 -= this.trackInOut(tileFluidDuctArray[n].transfer(n2, bl, fluidStack, false), bl)) != 0) continue;
            this.nodeTracker = n + 1;
        }
        for (n = 0; n < tileFluidDuctArray.length && n < this.nodeTracker && n2 > 0; ++n) {
            if ((n2 -= this.trackInOut(tileFluidDuctArray[n].transfer(n2, bl, fluidStack, false), bl)) != 0) continue;
            this.nodeTracker = n + 1;
        }
        if (n2 > 0) {
            ++this.nodeTracker;
        }
        if (this.nodeTracker >= tileFluidDuctArray.length) {
            this.nodeTracker = 0;
        }
        if (bl) {
            this.nodeTracker = n4;
        }
        this.isSendingFluid = false;
        return fluidStack.amount - n2;
    }

    @Override
    public void onMajorGridChange() {
        super.onMajorGridChange();
        this.nodeList = null;
    }

    @Override
    public boolean canGridsMerge(MultiBlockGrid multiBlockGrid) {
        return multiBlockGrid instanceof FluidGridSuper;
    }

    @Override
    public void destroy() {
        this.nodeList = null;
        super.destroy();
    }
}

