/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.filter;

import cofh.api.item.ISpecialFilterFluid;
import cofh.api.item.ISpecialFilterItem;
import cofh.core.util.CoreUtils;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.attachments.ConnectionBase;
import cofh.thermaldynamics.duct.attachments.filter.IFilterConfig;
import cofh.thermaldynamics.duct.attachments.filter.IFilterFluid;
import cofh.thermaldynamics.duct.attachments.filter.IFilterItems;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FilterLogic
implements IFilterItems,
IFilterFluid,
IFilterConfig {
    public static final int[] maxFilterItems = new int[]{3, 6, 9, 12, 15};
    public static final int[] maxFilterItemWidth = new int[]{3, 3, 3, 4, 5};
    private static final int flagBlackList = 0;
    private static final int flagIgnoreMetadata = 1;
    private static final int flagIgnoreNBT = 2;
    private static final int flagIgnoreOreDictionary = 3;
    private static final int flagIgnoreMod = 4;
    public static final String[] flagTypes = new String[]{"whiteList", "metadata", "nbt", "oreDict", "modSorting"};
    private final ItemStack[] items;
    public boolean recalc = true;
    public final ConnectionBase connection;
    public final int type;
    public static final boolean[] defaultflags = new boolean[]{true, false, false, true, true};
    boolean[] flags = new boolean[]{true, false, false, true, true};
    TIntHashSet oreIds;
    LinkedList<ItemStack> quickItems;
    HashSet<String> modNames;
    HashSet<Fluid> fluidsSimple;
    HashSet<FluidStack> fluidsNBT;
    LinkedList<CustomFilterItem> customFilterItems;
    LinkedList<CustomFilterFluid> customFilterFluids;
    public static int[] options = new int[]{0, 1, 6, 6, 6};
    private final Duct.Type transferType;
    private int[] validFlags;
    public boolean levelsChanged;
    public static final Perm[] levelPerms = new Perm[]{Perm.SERVO, Perm.SERVO, Perm.FILTER, Perm.ALL};
    public static final int[][] minLevels = new int[][]{{1, 0, 0, 0}, {1, 0, 0, 0}, {1, 0, 0, 0}, {1, 0, 0, 0}, {1, 0, 0, 0}};
    public static final int[][] maxLevels = new int[][]{{ServoItem.maxSize[0], 0, 1, 0}, {ServoItem.maxSize[1], 0, 1, 0}, {ServoItem.maxSize[2], 3, 1, 64}, {ServoItem.maxSize[3], 3, 1, 128}, {ServoItem.maxSize[4], 3, 1, 320}};
    public static final int[] defaultLevels = new int[]{64, 0, 1, 0};
    public int[] validLevels;
    public static final String[] levelNames = new String[]{"stacksize", "routeType", "antiSpam", "stockSize"};
    private final int[] levels = new int[defaultLevels.length];
    public static final int levelStackSize = 0;
    public static final int levelRouteMode = 1;
    public static final int levelConservativeMode = 2;
    public static final int levelRetainSize = 3;

    public FilterLogic(int n, Duct.Type type, ConnectionBase connectionBase) {
        this.type = n;
        this.transferType = type;
        this.items = new ItemStack[maxFilterItems[n]];
        if (type == Duct.Type.ITEM) {
            this.quickItems = new LinkedList();
        } else if (type == Duct.Type.FLUID) {
            this.fluidsSimple = new HashSet();
            this.fluidsNBT = new HashSet();
        }
        this.connection = connectionBase;
        this.initLevels();
    }

    public int[] getValidLevels() {
        return this.validLevels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calcItems() {
        ItemStack[] itemStackArray = this.items;
        synchronized (this.items) {
            this.recalc = false;
            if (this.isItem()) {
                this.quickItems.clear();
                if (!this.flags[3]) {
                    if (this.oreIds == null) {
                        this.oreIds = new TIntHashSet();
                    } else {
                        this.oreIds.clear();
                    }
                } else {
                    this.oreIds = null;
                }
                if (!this.flags[4]) {
                    if (this.modNames == null) {
                        this.modNames = new HashSet();
                    } else {
                        this.modNames.clear();
                    }
                } else {
                    this.modNames = null;
                }
                this.customFilterItems = null;
            } else if (this.isFluid()) {
                this.fluidsSimple.clear();
                this.fluidsNBT.clear();
                this.customFilterFluids = null;
            }
            block3: for (ItemStack itemStack : this.items) {
                Object object;
                if (itemStack == null) continue;
                if (this.isItem()) {
                    if (itemStack.func_77973_b() instanceof ISpecialFilterItem) {
                        if (this.customFilterItems == null) {
                            this.customFilterItems = new LinkedList();
                        }
                        this.customFilterItems.add(new CustomFilterItem(itemStack));
                    }
                    if (!this.flags[4]) {
                        this.modNames.add(CoreUtils.getModName((Item)itemStack.func_77973_b()));
                    }
                    if (!this.flags[3] && (object = OreDictionaryArbiter.getAllOreIDs((ItemStack)itemStack)) != null) {
                        Iterator iterator = ((ArrayList)object).iterator();
                        while (iterator.hasNext()) {
                            Integer n = (Integer)iterator.next();
                            if (this.oreIds.contains(n.intValue())) continue;
                            this.oreIds.add(n.intValue());
                        }
                    }
                    object = itemStack.func_77946_l();
                    if (this.flags[1]) {
                        object.func_77964_b(0);
                    }
                    if (this.flags[2]) {
                        object.func_77982_d(null);
                    }
                    for (ItemStack itemStack2 : this.quickItems) {
                        if (!ItemHelper.itemsEqualWithMetadata((ItemStack)object, (ItemStack)itemStack2)) continue;
                        continue block3;
                    }
                    this.quickItems.add((ItemStack)object);
                    continue;
                }
                if (!this.isFluid()) continue;
                if (itemStack.func_77973_b() instanceof ISpecialFilterFluid) {
                    if (this.customFilterFluids == null) {
                        this.customFilterFluids = new LinkedList();
                    }
                    this.customFilterFluids.add(new CustomFilterFluid(itemStack));
                }
                if ((object = FluidHelper.getFluidForFilledItem((ItemStack)itemStack)) == null) continue;
                object = object.copy();
                ((FluidStack)object).amount = 1;
                if (((FluidStack)object).tag == null || this.flags[2]) {
                    this.fluidsSimple.add(object.getFluid());
                    continue;
                }
                this.fluidsNBT.add((FluidStack)object);
            }
            // ** MonitorExit[itemStackArray] (shouldn't be in output)
            return;
        }
    }

    public boolean isFluid() {
        return this.transferType == Duct.Type.FLUID;
    }

    public boolean isItem() {
        return this.transferType == Duct.Type.ITEM;
    }

    @Override
    public boolean matchesFilter(ItemStack itemStack) {
        Object object2;
        boolean bl;
        if (this.recalc) {
            this.calcItems();
        }
        boolean bl2 = bl = !this.flags[0];
        if (this.customFilterItems != null) {
            object2 = this.customFilterItems.iterator();
            while (object2.hasNext()) {
                CustomFilterItem object3 = (CustomFilterItem)object2.next();
                if (!object3.filter.matchesItem(object3.filterStack, itemStack)) continue;
                return bl;
            }
        }
        if (!this.flags[4] && this.modNames.contains(CoreUtils.getModName((Item)itemStack.func_77973_b()))) {
            return bl;
        }
        if (!this.flags[3] && !this.oreIds.isEmpty() && (object2 = OreDictionaryArbiter.getAllOreIDs((ItemStack)itemStack)) != null) {
            Iterator iterator = ((ArrayList)object2).iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                if (!this.oreIds.contains(n.intValue())) continue;
                return bl;
            }
        }
        for (ItemStack itemStack2 : this.quickItems) {
            if (itemStack2.func_77973_b() != itemStack.func_77973_b() || !this.flags[1] && itemStack2.func_77960_j() != itemStack.func_77960_j() || !this.flags[2] && !ItemHelper.doNBTsMatch((NBTTagCompound)itemStack.field_77990_d, (NBTTagCompound)itemStack2.field_77990_d)) continue;
            return bl;
        }
        return !bl;
    }

    @Override
    public boolean shouldIncRouteItems() {
        return this.levels[2] == 1;
    }

    @Override
    public int getMaxStock() {
        return this.levels[3] == 0 ? Integer.MAX_VALUE : this.levels[3];
    }

    @Override
    public ItemStack[] getFilterStacks() {
        return this.items;
    }

    @Override
    public void onChange() {
        this.recalc = true;
    }

    @Override
    public int filterStackGridWidth() {
        return maxFilterItemWidth[this.type];
    }

    @Override
    public boolean getFlag(int n) {
        return this.flags[n];
    }

    @Override
    public boolean setFlag(int n, boolean bl) {
        if (!FilterLogic.canAlterFlag(this.transferType, this.type, n)) {
            return false;
        }
        if (this.connection.tile.world().field_72995_K) {
            this.connection.sendFilterConfigPacketFlag(n, bl);
        } else {
            this.connection.tile.func_70296_d();
        }
        this.flags[n] = bl;
        this.recalc = true;
        return true;
    }

    @Override
    public String flagType(int n) {
        return flagTypes[n];
    }

    @Override
    public int numFlags() {
        return this.flags.length;
    }

    public int[] validFlags() {
        return this.validFlags;
    }

    @Override
    public boolean canAlterFlag(int n) {
        return FilterLogic.canAlterFlag(this.transferType, this.type, n);
    }

    public static boolean canAlterFlag(Duct.Type type, int n, int n2) {
        return type == Duct.Type.ITEM && options[n] >= n2 || type == Duct.Type.FLUID && (n2 == 0 || n2 == 2);
    }

    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList = nBTTagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
            int n = nBTTagCompound2.func_74762_e("Slot");
            if (n < 0 || n >= this.items.length) continue;
            this.items[n] = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2);
        }
        this.recalc = true;
        this.handleFlagByte(nBTTagCompound.func_74771_c("Flags"));
        NBTTagCompound nBTTagCompound3 = nBTTagCompound.func_74775_l("Levels");
        for (int i = 0; i < this.levels.length; ++i) {
            this.levels[i] = nBTTagCompound3.func_74764_b("Level" + i) ? Math.max(minLevels[this.type][i], Math.min(maxLevels[this.type][i], nBTTagCompound3.func_74762_e("Level" + i))) : defaultLevels[i];
        }
    }

    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.func_74768_a("Slot", i);
            this.items[i].func_77955_b(nBTTagCompound2);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
        }
        nBTTagCompound.func_74782_a("Inventory", (NBTBase)nBTTagList);
        nBTTagCompound.func_74774_a("Flags", (byte)this.getFlagByte());
        NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
        for (int i = 0; i < this.levels.length; ++i) {
            nBTTagCompound3.func_74768_a("Level" + i, this.levels[i]);
        }
        nBTTagCompound.func_74782_a("Levels", (NBTBase)nBTTagCompound3);
    }

    @Override
    public boolean allowFluid(FluidStack fluidStack) {
        if (fluidStack == null) {
            return this.flags[0];
        }
        if (this.recalc) {
            this.calcItems();
        }
        if (this.customFilterFluids != null) {
            for (CustomFilterFluid customFilterFluid : this.customFilterFluids) {
                if (!customFilterFluid.filter.matchesFluid(customFilterFluid.filterStack, fluidStack)) continue;
                return !this.flags[0];
            }
        }
        if (fluidStack.tag == null || this.flags[2]) {
            return !this.flags[0] == this.fluidsSimple.contains(fluidStack.getFluid());
        }
        fluidStack = fluidStack.copy();
        fluidStack.amount = 1;
        return !this.flags[0] == this.fluidsNBT.contains(fluidStack);
    }

    public int getFlagByte() {
        int n = 0;
        for (int i = 0; i < this.flags.length; ++i) {
            if (!this.flags[i]) continue;
            n |= 1 << i;
        }
        return n;
    }

    public void handleFlagByte(int n) {
        for (int i = 0; i < this.flags.length; ++i) {
            this.flags[i] = this.canAlterFlag(i) ? (n & 1 << i) != 0 : defaultflags[i];
        }
    }

    public int getNumLevels() {
        return this.validLevels.length;
    }

    private void initLevels() {
        int n;
        TIntArrayList tIntArrayList = new TIntArrayList(this.levels.length);
        for (n = 0; n < this.levels.length; ++n) {
            this.levels[n] = Math.max(Math.min(defaultLevels[n], maxLevels[this.type][n]), minLevels[this.type][n]);
            if (n == 0 || n == 3 || !levelPerms[n].appliesTo(this) || minLevels[this.type][n] >= maxLevels[this.type][n]) continue;
            tIntArrayList.add(n);
        }
        this.validLevels = tIntArrayList.toArray();
        tIntArrayList.clear();
        for (n = 0; n < this.numFlags(); ++n) {
            if (!this.canAlterFlag(n)) continue;
            tIntArrayList.add(n);
        }
        this.validFlags = tIntArrayList.toArray();
    }

    public void incLevel(int n) {
        this.incLevel(n, 1, true);
    }

    public void decLevel(int n) {
        this.decLevel(n, 1, true);
    }

    public void incLevel(int n, int n2, boolean bl) {
        int n3 = this.getLevel(n) + n2;
        if (n3 > maxLevels[this.type][n]) {
            n3 = bl ? minLevels[this.type][n] : maxLevels[this.type][n];
        }
        this.setLevel(n, n3);
    }

    public void decLevel(int n, int n2, boolean bl) {
        int n3 = this.getLevel(n) - n2;
        if (n3 < minLevels[this.type][n]) {
            n3 = bl ? maxLevels[this.type][n] : minLevels[this.type][n];
        }
        this.setLevel(n, n3);
    }

    public void setLevel(int n, int n2) {
        this.setLevel(n, n2, true);
    }

    public void setLevel(int n, int n2, boolean bl) {
        if (n2 < minLevels[this.type][n]) {
            n2 = minLevels[this.type][n];
        }
        if (n2 > maxLevels[this.type][n]) {
            n2 = maxLevels[this.type][n];
        }
        if (this.levels[n] == n2) {
            return;
        }
        if (!levelPerms[n].appliesTo(this)) {
            return;
        }
        if (this.connection.tile.world().field_72995_K && bl) {
            this.connection.sendFilterConfigPacketLevel(n, n2);
        } else {
            this.connection.tile.func_70296_d();
            this.levelsChanged = true;
        }
        this.levels[n] = n2;
    }

    public int getLevel(int n) {
        return this.levels[n];
    }

    private static class CustomFilterFluid {
        public ISpecialFilterFluid filter;
        public ItemStack filterStack;

        public CustomFilterFluid(ItemStack itemStack) {
            this.filter = (ISpecialFilterFluid)itemStack.func_77973_b();
            this.filterStack = itemStack;
        }
    }

    private static class CustomFilterItem {
        public ISpecialFilterItem filter;
        public ItemStack filterStack;

        public CustomFilterItem(ItemStack itemStack) {
            this.filter = (ISpecialFilterItem)itemStack.func_77973_b();
            this.filterStack = itemStack;
        }
    }

    public static enum Perm {
        FILTER(true, false, Duct.Type.ITEM),
        SERVO(false, true, Duct.Type.ITEM),
        ALL(true, true, Duct.Type.ITEM);

        public final boolean filter;
        public final boolean servo;
        public final Duct.Type ductType;

        private Perm(boolean bl, boolean bl2, Duct.Type type) {
            this.filter = bl;
            this.servo = bl2;
            this.ductType = type;
        }

        public boolean appliesTo(FilterLogic filterLogic) {
            return !(filterLogic.transferType != this.ductType || filterLogic.connection.getId() == 3 && !this.filter || filterLogic.connection.getId() == 4 && !this.filter || filterLogic.connection.getId() == 2 && !this.servo || filterLogic.connection.getId() == 1 && !this.servo || filterLogic.connection.getId() == 6 && !this.servo || filterLogic.connection.getId() == 5 && !this.servo);
        }
    }
}

