/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct;

import cofh.thermaldynamics.duct.DuctFactory;
import cofh.thermaldynamics.render.TextureOverlay;
import cofh.thermaldynamics.render.TextureTransparent;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class Duct {
    public static final String REDSTONE_BLOCK = "minecraft:redstone_block";
    public static final String SIDE_DUCTS = "sideDucts";
    public ItemStack itemStack = null;
    public IIcon iconBaseTexture;
    public IIcon iconConnectionTexture;
    public IIcon iconFluidTexture;
    public IIcon iconFrameTexture;
    public IIcon iconFrameBandTexture;
    public IIcon iconFrameFluidTexture;
    public byte frameType = 0;
    public final int id;
    public final String unlocalizedName;
    public final int pathWeight;
    public final Type ductType;
    public final DuctFactory factory;
    public final String baseTexture;
    public final String connectionTexture;
    public final String fluidTexture;
    public final byte fluidTransparency;
    public final String frameTexture;
    public final String frameFluidTexture;
    public final byte frameFluidTransparency;
    public final boolean opaque;
    public final int type;
    public EnumRarity rarity = EnumRarity.common;

    public Duct(int n, boolean bl, int n2, int n3, String string, Type type, DuctFactory ductFactory, String string2, String string3, String string4, int n4, String string5, String string6, int n5) {
        this.id = n;
        this.pathWeight = n2;
        this.ductType = type;
        this.opaque = bl;
        this.type = n3;
        this.unlocalizedName = string;
        this.factory = ductFactory;
        this.baseTexture = string2;
        this.connectionTexture = string3;
        this.fluidTexture = string4;
        this.fluidTransparency = (byte)n4;
        this.frameTexture = string5;
        this.frameFluidTexture = string6;
        this.frameFluidTransparency = (byte)n5;
    }

    public Duct setRarity(int n) {
        this.rarity = EnumRarity.values()[n %= EnumRarity.values().length];
        return this;
    }

    public boolean isLargeTube() {
        return this.frameType == 2 || this.frameType == 4;
    }

    public void registerIcons(IIconRegister iIconRegister) {
        if (this.baseTexture != null) {
            this.iconBaseTexture = TextureOverlay.generateBaseTexture(iIconRegister, this.baseTexture, this.opaque ? null : "trans", null);
        }
        if (this.connectionTexture != null) {
            this.iconConnectionTexture = TextureOverlay.generateConnectionTexture(iIconRegister, this.connectionTexture);
        }
        if (this.fluidTexture != null) {
            this.iconFluidTexture = TextureTransparent.registerTransparentIcon(iIconRegister, this.fluidTexture, this.fluidTransparency);
        }
        if (this.frameTexture != null) {
            if (this.frameTexture.endsWith("_large")) {
                this.frameType = (byte)3;
                this.iconFrameTexture = iIconRegister.func_94245_a("thermaldynamics:duct/base/" + this.frameTexture);
            } else if (SIDE_DUCTS.equals(this.frameTexture)) {
                this.frameType = 1;
            } else {
                this.iconFrameTexture = TextureOverlay.generateFrameTexture(iIconRegister, this.frameTexture);
                this.iconFrameBandTexture = TextureOverlay.generateFrameBandTexture(iIconRegister, this.frameTexture);
                this.frameType = (byte)2;
            }
        }
        if (this.frameFluidTexture != null) {
            if (this.frameType == 0) {
                this.frameType = (byte)2;
            }
            this.iconFrameFluidTexture = TextureTransparent.registerTransparentIcon(iIconRegister, this.frameFluidTexture, this.frameFluidTransparency);
        }
    }

    public int compareTo(Duct duct) {
        return this.id > duct.id ? 1 : (this.id < duct.id ? -1 : 0);
    }

    public IIcon getBaseTexture(ItemStack itemStack) {
        return this.iconBaseTexture;
    }

    public static enum Type {
        ENERGY,
        FLUID,
        ITEM,
        TRANSPORT,
        STRUCTURAL,
        CRAFTING;

    }
}

