/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.block;

import cofh.thermaldynamics.block.Attachment;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.attachments.cover.Cover;
import cofh.thermaldynamics.duct.attachments.filter.FilterFluid;
import cofh.thermaldynamics.duct.attachments.filter.FilterItem;
import cofh.thermaldynamics.duct.attachments.relay.Relay;
import cofh.thermaldynamics.duct.attachments.retriever.RetrieverFluid;
import cofh.thermaldynamics.duct.attachments.retriever.RetrieverItem;
import cofh.thermaldynamics.duct.attachments.servo.ServoFluid;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;

public class AttachmentRegistry {
    public static final byte FACADE = 0;
    public static final byte SERVO_FLUID = 1;
    public static final byte SERVO_ITEM = 2;
    public static final byte FILTER_FLUID = 3;
    public static final byte FILTER_ITEM = 4;
    public static final byte RETRIEVER_FLUID = 5;
    public static final byte RETRIEVER_ITEM = 6;
    public static final byte RELAY = 7;

    public static Attachment createAttachment(TileTDBase tileTDBase, byte by, int n) {
        if (n == 0) {
            return new Cover(tileTDBase, by);
        }
        if (n == 1) {
            return new ServoFluid(tileTDBase, by);
        }
        if (n == 2) {
            return new ServoItem(tileTDBase, by);
        }
        if (n == 3) {
            return new FilterFluid(tileTDBase, by);
        }
        if (n == 4) {
            return new FilterItem(tileTDBase, by);
        }
        if (n == 5) {
            return new RetrieverFluid(tileTDBase, by);
        }
        if (n == 6) {
            return new RetrieverItem(tileTDBase, by);
        }
        if (n == 7) {
            return new Relay(tileTDBase, by);
        }
        throw new RuntimeException("Illegal Attachment ID");
    }
}

