/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import logisticspipes.LPConstants;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.buildcraft.subproxies.IBCPipePluggable;
import logisticspipes.proxy.object3d.interfaces.IIconTransformation;
import logisticspipes.proxy.object3d.interfaces.IModel3D;
import logisticspipes.proxy.object3d.operation.LPScale;
import logisticspipes.proxy.object3d.operation.LPTranslation;
import logisticspipes.renderer.IIconProvider;
import logisticspipes.renderer.LogisticsPipeWorldRenderer;
import logisticspipes.renderer.newpipe.LogisticsNewSolidBlockWorldRenderer;
import logisticspipes.renderer.state.PipeRenderState;
import logisticspipes.textures.Textures;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class LogisticsNewPipeWorldRenderer
implements ISimpleBlockRenderingHandler {
    private Map<LogisticsNewSolidBlockWorldRenderer.BlockRotation, IModel3D> requestBlock = null;

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        Tessellator tess = Tessellator.field_78398_a;
        TileEntity tile = world.func_147438_o(x, y, z);
        LogisticsTileGenericPipe pipeTile = (LogisticsTileGenericPipe)tile;
        PipeRenderState renderState = pipeTile.renderState;
        if (pipeTile.pipe instanceof PipeBlockRequestTable) {
            if (LogisticsPipeWorldRenderer.renderPass != 0) {
                return false;
            }
            IIconProvider icons = pipeTile.getPipeIcons();
            if (icons == null) {
                return false;
            }
            if (this.requestBlock != null) {
                // empty if block
            }
            this.requestBlock = new HashMap<LogisticsNewSolidBlockWorldRenderer.BlockRotation, IModel3D>();
            for (LogisticsNewSolidBlockWorldRenderer.BlockRotation rot : LogisticsNewSolidBlockWorldRenderer.BlockRotation.values()) {
                this.requestBlock.put(rot, LogisticsNewSolidBlockWorldRenderer.block.get((Object)rot).copy().apply(new LPScale(0.999)).apply(new LPTranslation(5.0E-4, 5.0E-4, 5.0E-4)));
            }
            SimpleServiceLocator.cclProxy.getRenderState().reset();
            SimpleServiceLocator.cclProxy.getRenderState().setUseNormals(true);
            SimpleServiceLocator.cclProxy.getRenderState().setAlphaOverride(255);
            LogisticsNewSolidBlockWorldRenderer.BlockRotation rotation = LogisticsNewSolidBlockWorldRenderer.BlockRotation.getRotation(((PipeBlockRequestTable)pipeTile.pipe).getRotation());
            int brightness = new LPPosition(x, y, z).getBlock(world).func_149677_c(world, x, y, z);
            tess.func_78386_a(1.0f, 1.0f, 1.0f);
            tess.func_78380_c(brightness);
            IIconTransformation icon = SimpleServiceLocator.cclProxy.createIconTransformer(Textures.LOGISTICS_REQUEST_TABLE_NEW);
            this.requestBlock.get((Object)rotation).render(new LPTranslation(x, y, z), icon);
            for (LogisticsNewSolidBlockWorldRenderer.CoverSides side : LogisticsNewSolidBlockWorldRenderer.CoverSides.values()) {
                if (pipeTile.renderState.pipeConnectionMatrix.isConnected(side.getDir(rotation))) continue;
                LogisticsNewSolidBlockWorldRenderer.texturePlate_Outer.get((Object)side).get((Object)rotation).render(new LPTranslation(x, y, z), icon);
                LogisticsNewSolidBlockWorldRenderer.texturePlate_Inner.get((Object)side).get((Object)rotation).render(new LPTranslation(x, y, z), icon);
            }
            return true;
        }
        boolean hasRendered = false;
        tess.func_78372_c(2.0E-5f, 2.0E-5f, 2.0E-5f);
        renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!pipeTile.tilePart.hasPipePluggable(dir)) continue;
            IBCPipePluggable p = pipeTile.tilePart.getBCPipePluggable(dir);
            p.renderPluggable(renderer, dir, LogisticsPipeWorldRenderer.renderPass, x, y, z);
            hasRendered = true;
        }
        tess.func_78372_c(-2.0E-5f, -2.0E-5f, -2.0E-5f);
        boolean[] solidSides = new boolean[6];
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            LPPosition pos = new LPPosition(pipeTile);
            pos.moveForward(dir);
            Block blockSide = pos.getBlock((IBlockAccess)pipeTile.func_145831_w());
            if (blockSide == null || !blockSide.isSideSolid((IBlockAccess)pipeTile.func_145831_w(), pos.getX(), pos.getY(), pos.getZ(), dir.getOpposite()) || renderState.pipeConnectionMatrix.isConnected(dir)) continue;
            solidSides[dir.ordinal()] = true;
        }
        if (!Arrays.equals(solidSides, renderState.solidSidesCache)) {
            renderState.solidSidesCache = (boolean[])solidSides.clone();
            renderState.cachedRenderer = null;
        }
        if (hasRendered) {
            block.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            renderer.func_147775_a(block);
            renderer.func_147784_q(block, x, y, z);
            block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        return hasRendered;
    }

    public int getRenderId() {
        return LPConstants.pipeModel;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }
}

