/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe;

import java.util.ArrayList;
import logisticspipes.LogisticsPipes;
import logisticspipes.items.ItemLogisticsPipe;
import logisticspipes.pipes.basic.LogisticsBlockGenericPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.object3d.interfaces.I3DOperation;
import logisticspipes.proxy.object3d.interfaces.IIconTransformation;
import logisticspipes.proxy.object3d.interfaces.IModel3D;
import logisticspipes.renderer.newpipe.LogisticsNewRenderPipe;
import logisticspipes.renderer.newpipe.LogisticsNewSolidBlockWorldRenderer;
import logisticspipes.textures.Textures;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class LogisticsNewPipeItemRenderer
implements IItemRenderer {
    private final boolean renderAsBlock;

    public LogisticsNewPipeItemRenderer(boolean flag) {
        this.renderAsBlock = flag;
    }

    private void renderPipeItem(RenderBlocks render, ItemStack item, float translateX, float translateY, float translateZ) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)16384);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)translateX, (float)translateY, (float)translateZ);
        LogisticsBlockGenericPipe block = LogisticsPipes.LogisticsPipeBlock;
        if (item.func_77973_b() instanceof ItemLogisticsPipe) {
            ItemLogisticsPipe lItem = (ItemLogisticsPipe)item.func_77973_b();
            int renderList = lItem.getNewPipeRenderList();
            if (renderList == -1) {
                lItem.setNewPipeRenderList(GL11.glGenLists((int)1));
                renderList = lItem.getNewPipeRenderList();
                GL11.glNewList((int)renderList, (int)4864);
                tessellator.func_78382_b();
                this.generatePipeRenderList(lItem.getNewPipeIconIndex());
                tessellator.func_78381_a();
                GL11.glEndList();
            }
            GL11.glCallList((int)renderList);
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void generatePipeRenderList(int texture) {
        ArrayList<Pair<IModel3D, IIconTransformation>> objectsToRender = new ArrayList<Pair<IModel3D, IIconTransformation>>();
        for (LogisticsNewRenderPipe.Corner corner : LogisticsNewRenderPipe.Corner.values()) {
            for (IModel3D model : LogisticsNewRenderPipe.corners_M.get((Object)corner)) {
                objectsToRender.add(new Pair<IModel3D, IIconTransformation>(model, LogisticsNewRenderPipe.basicTexture));
            }
        }
        for (Enum enum_ : LogisticsNewRenderPipe.Edge.values()) {
            objectsToRender.add(new Pair<IModel3D, IIconTransformation>(LogisticsNewRenderPipe.edges.get(enum_), LogisticsNewRenderPipe.basicTexture));
        }
        for (Enum enum_ : ForgeDirection.VALID_DIRECTIONS) {
            for (IModel3D model : LogisticsNewRenderPipe.texturePlate_Outer.get(enum_)) {
                IIconTransformation icon = Textures.LPnewPipeIconProvider.getIcon(texture);
                if (icon == null) continue;
                objectsToRender.add(new Pair<IModel3D, IIconTransformation>(model, icon));
            }
        }
        for (Pair pair : objectsToRender) {
            ((IModel3D)pair.getValue1()).render((I3DOperation)pair.getValue2());
        }
    }

    private void renderBlockItem(RenderBlocks render, ItemStack item, float translateX, float translateY, float translateZ) {
        GL11.glPushAttrib((int)16384);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)translateX, (float)translateY, (float)translateZ);
        LogisticsBlockGenericPipe block = LogisticsPipes.LogisticsPipeBlock;
        Tessellator tess = Tessellator.field_78398_a;
        LogisticsNewSolidBlockWorldRenderer.BlockRotation rotation = LogisticsNewSolidBlockWorldRenderer.BlockRotation.ZERO;
        tess.func_78382_b();
        IIconTransformation icon = SimpleServiceLocator.cclProxy.createIconTransformer(Textures.LOGISTICS_REQUEST_TABLE_NEW);
        LogisticsNewSolidBlockWorldRenderer.block.get((Object)rotation).render(icon);
        for (LogisticsNewSolidBlockWorldRenderer.CoverSides side : LogisticsNewSolidBlockWorldRenderer.CoverSides.values()) {
            LogisticsNewSolidBlockWorldRenderer.texturePlate_Outer.get((Object)side).get((Object)rotation).render(icon);
        }
        tess.func_78381_a();
        block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        GL11.glPopAttrib();
    }

    private void renderItem(RenderBlocks render, ItemStack item, float translateX, float translateY, float translateZ) {
        if (this.renderAsBlock) {
            this.renderBlockItem(render, item, translateX, translateY, translateZ);
        } else {
            this.renderPipeItem(render, item, translateX, translateY, translateZ);
        }
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                return true;
            }
            case EQUIPPED: {
                return true;
            }
            case EQUIPPED_FIRST_PERSON: {
                return true;
            }
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                if (this.renderAsBlock) {
                    this.renderItem((RenderBlocks)data[0], item, -0.5f, -0.5f, -0.5f);
                    break;
                }
                this.renderItem((RenderBlocks)data[0], item, -0.5f, -0.5f, -0.5f);
                break;
            }
            case EQUIPPED: {
                if (this.renderAsBlock) {
                    this.renderItem((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f);
                    break;
                }
                this.renderItem((RenderBlocks)data[0], item, -0.4f, 0.5f, 0.35f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                if (this.renderAsBlock) {
                    this.renderItem((RenderBlocks)data[0], item, 0.0f, 0.0f, 0.0f);
                    break;
                }
                this.renderItem((RenderBlocks)data[0], item, -0.4f, 0.5f, 0.35f);
                break;
            }
            case INVENTORY: {
                if (this.renderAsBlock) {
                    this.renderItem((RenderBlocks)data[0], item, -0.5f, -0.5f, -0.5f);
                    break;
                }
                this.renderItem((RenderBlocks)data[0], item, -0.5f, -0.5f, -0.5f);
                break;
            }
        }
    }
}

