/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import logisticspipes.LPConstants;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.PlayerConfig;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.pipes.basic.LogisticsBlockGenericPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.buildcraft.subproxies.IBCPipePluggable;
import logisticspipes.renderer.IIconProvider;
import logisticspipes.renderer.newpipe.LogisticsNewPipeWorldRenderer;
import logisticspipes.renderer.state.PipeRenderState;
import logisticspipes.textures.Textures;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class LogisticsPipeWorldRenderer
implements ISimpleBlockRenderingHandler {
    public static int renderPass = -1;
    private PlayerConfig config = LogisticsPipes.getClientPlayerConfig();
    private LogisticsNewPipeWorldRenderer newRenderer = new LogisticsNewPipeWorldRenderer();

    public static boolean renderPipe(RenderBlocks renderblocks, IBlockAccess iblockaccess, LogisticsBlockGenericPipe block, LogisticsTileGenericPipe pipe, int x, int y, int z) {
        if (pipe.pipe instanceof PipeBlockRequestTable) {
            if (renderPass != 0) {
                return false;
            }
            PipeRenderState state = pipe.renderState;
            IIconProvider icons = pipe.getPipeIcons();
            if (icons == null) {
                return false;
            }
            state.currentTexture = icons.getIcon(state.textureMatrix.getTextureIndex(ForgeDirection.UNKNOWN));
            block.setRenderAllSides();
            block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            renderblocks.func_147775_a((Block)block);
            renderblocks.func_147784_q((Block)block, x, y, z);
            return true;
        }
        renderblocks.func_147782_a(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        renderblocks.func_147784_q(Blocks.field_150348_b, x, y, z);
        renderblocks.func_147775_a((Block)block);
        PipeRenderState state = pipe.renderState;
        IIconProvider icons = pipe.getPipeIcons();
        if (icons == null) {
            return false;
        }
        if (renderPass == 0) {
            int renderMask;
            int mask;
            int dir;
            int connectivity = state.pipeConnectionMatrix.getMask();
            float[] dim = new float[6];
            if (!pipe.isOpaque()) {
                if (connectivity != 63) {
                    LogisticsPipeWorldRenderer.resetToCenterDimensions(dim);
                    state.currentTexture = icons.getIcon(state.textureMatrix.getTextureIndex(ForgeDirection.UNKNOWN));
                    LogisticsPipeWorldRenderer.renderTwoWayBlock(renderblocks, block, x, y, z, dim, connectivity ^ 0x3F);
                }
                for (dir = 0; dir < 6; ++dir) {
                    mask = 1 << dir;
                    if ((connectivity & mask) == 0) continue;
                    LogisticsPipeWorldRenderer.resetToCenterDimensions(dim);
                    dim[dir / 2] = dir % 2 == 0 ? 0.0f : 0.75f;
                    dim[dir / 2 + 3] = dir % 2 == 0 ? 0.25f : 1.0f;
                    renderMask = 3 << dir / 2 * 2 ^ 0x3F;
                    renderblocks.field_147871_s = dir < 2 ? 0 : 1;
                    renderblocks.field_147873_r = renderblocks.field_147871_s;
                    renderblocks.field_147869_t = renderblocks.field_147871_s;
                    renderblocks.field_147875_q = renderblocks.field_147871_s;
                    state.currentTexture = icons.getIcon(state.textureMatrix.getTextureIndex(ForgeDirection.VALID_DIRECTIONS[dir]));
                    LogisticsPipeWorldRenderer.renderTwoWayBlock(renderblocks, block, x, y, z, dim, renderMask);
                    renderblocks.field_147871_s = 0;
                    renderblocks.field_147873_r = 0;
                    renderblocks.field_147869_t = 0;
                    renderblocks.field_147875_q = 0;
                }
            } else {
                if (connectivity != 63) {
                    LogisticsPipeWorldRenderer.resetToCenterDimensions(dim);
                    state.currentTexture = icons.getIcon(Textures.LOGISTICSPIPE_OPAQUE_TEXTURE.normal);
                    LogisticsPipeWorldRenderer.renderOneWayBlock(renderblocks, block, x, y, z, dim, connectivity ^ 0x3F);
                    state.currentTexture = icons.getIcon(state.textureMatrix.getTextureIndex(ForgeDirection.UNKNOWN));
                    LogisticsPipeWorldRenderer.renderOneWayBlock(renderblocks, block, x, y, z, dim, connectivity ^ 0x3F);
                }
                for (dir = 0; dir < 6; ++dir) {
                    mask = 1 << dir;
                    if ((connectivity & mask) == 0) continue;
                    LogisticsPipeWorldRenderer.resetToCenterDimensions(dim);
                    dim[dir / 2] = dir % 2 == 0 ? 0.0f : 0.75f;
                    dim[dir / 2 + 3] = dir % 2 == 0 ? 0.25f : 1.0f;
                    renderMask = 3 << dir / 2 * 2 ^ 0x3F;
                    renderblocks.field_147871_s = dir < 2 ? 0 : 1;
                    renderblocks.field_147873_r = renderblocks.field_147871_s;
                    renderblocks.field_147869_t = renderblocks.field_147871_s;
                    renderblocks.field_147875_q = renderblocks.field_147871_s;
                    state.currentTexture = icons.getIcon(Textures.LOGISTICSPIPE_OPAQUE_TEXTURE.normal);
                    LogisticsPipeWorldRenderer.renderOneWayBlock(renderblocks, block, x, y, z, dim, 63);
                    state.currentTexture = icons.getIcon(state.textureMatrix.getTextureIndex(ForgeDirection.VALID_DIRECTIONS[dir]));
                    LogisticsPipeWorldRenderer.renderOneWayBlock(renderblocks, block, x, y, z, dim, renderMask);
                    renderblocks.field_147871_s = 0;
                    renderblocks.field_147873_r = 0;
                    renderblocks.field_147869_t = 0;
                    renderblocks.field_147875_q = 0;
                }
            }
        }
        renderblocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!pipe.tilePart.hasPipePluggable(dir)) continue;
            IBCPipePluggable p = pipe.tilePart.getBCPipePluggable(dir);
            p.renderPluggable(renderblocks, dir, renderPass, x, y, z);
        }
        return true;
    }

    private static void resetToCenterDimensions(float[] dim) {
        int i;
        for (i = 0; i < 3; ++i) {
            dim[i] = 0.25f;
        }
        for (i = 3; i < 6; ++i) {
            dim[i] = 0.75f;
        }
    }

    private static void renderOneWayBlock(RenderBlocks renderblocks, LogisticsBlockGenericPipe block, int x, int y, int z, float[] dim, int mask) {
        assert (mask != 0);
        block.setRenderMask(mask);
        renderblocks.func_147782_a((double)dim[2], (double)dim[0], (double)dim[1], (double)dim[5], (double)dim[3], (double)dim[4]);
        renderblocks.func_147784_q((Block)block, x, y, z);
    }

    private static void renderTwoWayBlock(RenderBlocks renderblocks, LogisticsBlockGenericPipe block, int x, int y, int z, float[] dim, int mask) {
        assert (mask != 0);
        block.setRenderMask(mask);
        renderblocks.func_147782_a((double)dim[2], (double)dim[0], (double)dim[1], (double)dim[5], (double)dim[3], (double)dim[4]);
        renderblocks.func_147784_q((Block)block, x, y, z);
        renderblocks.field_147842_e = true;
        block.setRenderMask((mask & 0x15) << 1 | (mask & 0x2A) >> 1);
        renderblocks.func_147782_a((double)dim[5], (double)dim[3], (double)dim[4], (double)dim[2], (double)dim[0], (double)dim[1]);
        renderblocks.func_147784_q((Block)block, x, y, z);
        renderblocks.field_147842_e = false;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity tile = world.func_147438_o(x, y, z);
        LogisticsTileGenericPipe pipeTile = (LogisticsTileGenericPipe)tile;
        SimpleServiceLocator.thermalDynamicsProxy.renderPipeConnections(pipeTile, renderer);
        if (this.config.isUseNewRenderer() && !pipeTile.renderState.forceRenderOldPipe) {
            return this.newRenderer.renderWorldBlock(world, x, y, z, block, modelId, renderer);
        }
        return LogisticsPipeWorldRenderer.renderPipe(renderer, world, (LogisticsBlockGenericPipe)block, pipeTile, x, y, z);
    }

    public int getRenderId() {
        return LPConstants.pipeModel;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }
}

