/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.api.core.INBTTagable;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class PipetteContents
implements INBTTagable {
    private FluidStack contents;

    public PipetteContents(NBTTagCompound nbttagcompound) {
        if (nbttagcompound != null) {
            this.readFromNBT(nbttagcompound);
        }
    }

    public FluidStack getContents() {
        return this.contents;
    }

    public void setContents(FluidStack contents) {
        this.contents = contents;
    }

    public boolean isFull() {
        if (this.contents == null) {
            return false;
        }
        return this.contents.getFluid().getID() > 0 && this.contents.amount >= 1000;
    }

    public void addTooltip(List<String> list) {
        if (this.contents == null) {
            return;
        }
        String descr = this.contents.getFluid().getLocalizedName(this.contents);
        descr = descr + " (" + this.contents.amount + " mb)";
        list.add(descr);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.contents = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbttagcompound);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        if (this.contents != null) {
            this.contents.writeToNBT(nbttagcompound);
        }
    }
}

