/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics.alleles;

import forestry.api.arboriculture.EnumFruitFamily;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.genetics.AlleleManager;
import forestry.arboriculture.FruitProviderNone;
import forestry.arboriculture.FruitProviderPod;
import forestry.arboriculture.FruitProviderRandom;
import forestry.arboriculture.FruitProviderRipening;
import forestry.core.genetics.alleles.AlleleCategorized;
import forestry.core.items.ItemFruit;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class AlleleFruit
extends AlleleCategorized
implements IAlleleFruit {
    public static IAlleleFruit fruitNone;
    public static IAlleleFruit fruitApple;
    public static IAlleleFruit fruitCocoa;
    public static IAlleleFruit fruitChestnut;
    public static IAlleleFruit fruitCoconut;
    public static IAlleleFruit fruitWalnut;
    public static IAlleleFruit fruitCherry;
    public static IAlleleFruit fruitDates;
    public static IAlleleFruit fruitPapaya;
    public static IAlleleFruit fruitLemon;
    public static IAlleleFruit fruitPlum;
    public static IAlleleFruit fruitJujube;
    private final IFruitProvider provider;

    public static void createAlleles() {
        fruitNone = new AlleleFruit("none", new FruitProviderNone("none", null));
        fruitApple = new AlleleFruit("apple", new FruitProviderRandom("apple", EnumFruitFamily.POMES, new ItemStack(Items.field_151034_e), 1.0f).setColour(0xFF2E2E).setOverlay("pomes"));
        List<IAlleleFruit> fruitAlleles = Arrays.asList(fruitNone, fruitApple, fruitCocoa = new AlleleFruit("cocoa", new FruitProviderPod("cocoa", EnumFruitFamily.JUNGLE, FruitProviderPod.EnumPodType.COCOA, new ItemStack[0])), fruitChestnut = new AlleleFruit("chestnut", new FruitProviderRipening("chestnut", EnumFruitFamily.NUX, ItemFruit.EnumFruit.CHESTNUT.getStack(), 1.0f).setRipeningPeriod(6).setColours(8336189, 12898890).setOverlay("nuts"), true), fruitWalnut = new AlleleFruit("walnut", new FruitProviderRipening("walnut", EnumFruitFamily.NUX, ItemFruit.EnumFruit.WALNUT.getStack(), 1.0f).setRipeningPeriod(8).setColours(16491080, 12898890).setOverlay("nuts"), true), fruitCherry = new AlleleFruit("cherry", new FruitProviderRipening("cherry", EnumFruitFamily.PRUNES, ItemFruit.EnumFruit.CHERRY.getStack(), 1.0f).setColours(0xFF2E2E, 12898890).setOverlay("berries"), true), fruitDates = new AlleleFruit("dates", new FruitProviderPod("dates", EnumFruitFamily.JUNGLE, FruitProviderPod.EnumPodType.DATES, ItemFruit.EnumFruit.DATES.getStack(4))), fruitPapaya = new AlleleFruit("papaya", new FruitProviderPod("papaya", EnumFruitFamily.JUNGLE, FruitProviderPod.EnumPodType.PAPAYA, ItemFruit.EnumFruit.PAPAYA.getStack())), fruitLemon = new AlleleFruit("lemon", new FruitProviderRipening("lemon", EnumFruitFamily.PRUNES, ItemFruit.EnumFruit.LEMON.getStack(), 1.0f).setColours(0xEEEE00, 0x99FF00).setOverlay("citrus"), true), fruitPlum = new AlleleFruit("plum", new FruitProviderRipening("plum", EnumFruitFamily.PRUNES, ItemFruit.EnumFruit.PLUM.getStack(), 1.0f).setColours(0x663446, 15662874).setOverlay("plums"), true));
        for (IAlleleFruit fruitAllele : fruitAlleles) {
            AlleleManager.alleleRegistry.registerAllele(fruitAllele, EnumTreeChromosome.FRUITS);
        }
    }

    public AlleleFruit(String name, IFruitProvider provider) {
        this(name, provider, false);
    }

    public AlleleFruit(String name, IFruitProvider provider, boolean isDominant) {
        super("forestry", "fruit", name, isDominant);
        this.provider = provider;
    }

    @Override
    public IFruitProvider getProvider() {
        return this.provider;
    }

    @Override
    public String getName() {
        return this.getProvider().getDescription();
    }
}

