/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import jds.bibliocraft.BiblioRenderHelper;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.Config;
import jds.bibliocraft.models.ModelFramedChest;
import jds.bibliocraft.tileentities.TileEntityFramedChest;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TileEntityFramedChestRenderer
extends TileEntitySpecialRenderer {
    private ModelFramedChest model = new ModelFramedChest();
    private int angle = 0;
    private float ishift = 0.0f;
    private float kshift = 0.0f;
    private float ishift2 = 0.0f;
    private float kshift2 = 0.0f;
    private String customTex = "none";
    private ResourceLocation customTexture = null;
    private ResourceLocation customTextureInside = null;
    private int degreeAngle;
    private boolean openChest = false;
    private boolean isDouble = false;
    private boolean isLeft = false;
    private ItemStack labelStack = null;
    private ItemStack labelStackPrev = null;
    private Minecraft mc = Minecraft.func_71410_x();
    private boolean fancyGraphics;
    private boolean fancyGraphicsCache;
    private RenderItem itemRenderer;
    private RenderManager renderManager = RenderManager.field_78727_a;
    private float yawValue;
    private float lidAngle = 0.0f;
    private float prevLidAngle = 0.0f;
    private ResourceLocation customChestFillerTexture = null;

    public TileEntityFramedChestRenderer() {
        this.itemRenderer = new RenderItem(){

            public byte getMiniBlockCount(ItemStack stack, byte original) {
                return 1;
            }

            public byte getMiniItemCount(ItemStack stack, byte original) {
                return 1;
            }

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        this.itemRenderer.func_76976_a(RenderManager.field_78727_a);
    }

    public void func_147500_a(TileEntity tileEntity, double i, double j, double k, float tick) {
        TileEntityFramedChest tile = (TileEntityFramedChest)tileEntity;
        this.angle = tile.getAngle();
        this.customTex = tile.getCustomTexString();
        this.customTexture = tile.getCustomTex();
        this.openChest = tile.getOpenChest();
        this.isDouble = tile.getIsDouble();
        this.isLeft = tile.getIsLeft();
        this.labelStack = tile.getLabelStack();
        this.lidAngle = tile.getLidAngle();
        this.prevLidAngle = tile.getPrevLidAngle();
        this.labelStackPrev = tile.labelStackPrev;
        if (this.labelStack != null) {
            if (this.labelStackPrev == null || !ItemStack.func_77989_b((ItemStack)this.labelStack, (ItemStack)this.labelStackPrev)) {
                tile.labelStackPrev = this.labelStack.func_77946_l();
                this.setChestInnardTexture(this.labelStack, tile);
            }
        } else {
            tile.labelStackPrev = null;
            tile.customChestFillerTexture = null;
        }
        float f1 = this.prevLidAngle + (this.lidAngle - this.prevLidAngle) * tick;
        f1 = 1.0f - f1;
        f1 = 1.0f - f1 * f1 * f1;
        boolean graphicState = this.mc.field_71474_y.field_74347_j;
        if (Config.forceFastRenderLabel) {
            this.mc.field_71474_y.field_74347_j = false;
            this.fancyGraphics = false;
        }
        this.yawValue = !this.fancyGraphics || Config.forceFastRenderLabel ? this.renderManager.field_78734_h.field_70177_z : 0.0f;
        this.ishift = 0.0f;
        this.kshift = 0.0f;
        switch (this.angle) {
            case 0: {
                this.degreeAngle = 0;
                this.ishift = 0.0f;
                this.kshift = 0.0f;
                this.ishift2 = -0.44f;
                this.kshift2 = 0.5f;
                break;
            }
            case 1: {
                this.degreeAngle = 270;
                this.ishift = -0.45f;
                this.kshift = 0.45f;
                this.ishift2 = 0.0f;
                this.kshift2 = 0.06f;
                break;
            }
            case 2: {
                this.degreeAngle = 180;
                this.ishift = -0.9f;
                this.kshift = 0.0f;
                this.ishift2 = 0.44f;
                this.kshift2 = 0.5f;
                break;
            }
            case 3: {
                this.degreeAngle = 90;
                this.ishift = -0.45f;
                this.kshift = -0.45f;
                this.ishift2 = 0.0f;
                this.kshift2 = 0.94f;
                break;
            }
        }
        if (this.labelStack != null) {
            EntityItem slot1Entity = new EntityItem(null, 0.0, 0.0, 0.0, this.labelStack);
            slot1Entity.field_70290_d = 0.0f;
            GL11.glPushMatrix();
            if (Config.isBlock(this.labelStack)) {
                GL11.glTranslated((double)(i + 0.5 + (double)this.ishift2), (double)(j + (double)0.23f), (double)(k + (double)this.kshift2));
            } else {
                GL11.glTranslated((double)(i + 0.5 + (double)this.ishift2), (double)(j + (double)0.21f), (double)(k + (double)this.kshift2));
            }
            GL11.glRotatef((float)((float)this.degreeAngle - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            if (Config.isBlock(this.labelStack)) {
                GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
            } else {
                GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
            }
            if (!this.labelStack.func_77977_a().toLowerCase().contains("map")) {
                RenderItem.field_82407_g = true;
            }
            this.itemRenderer.func_76986_a(slot1Entity, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            RenderItem.field_82407_g = false;
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(i + 0.95 + (double)this.ishift), (double)(j + 0.625), (double)(k + 0.5 + (double)this.kshift));
        GL11.glRotatef((float)this.degreeAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        if (this.customTextureInside != null && (this.lidAngle > 0.0f || this.customTex.contentEquals("none") || this.customTexture == null || this.customTex.contentEquals(""))) {
            this.func_147499_a(this.customTextureInside);
            if (this.isDouble) {
                this.model.renderLargeChestInside(this.isLeft);
            } else {
                this.model.renderSmallChestInside();
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.customTex.contentEquals("none") || this.customTexture == null || this.customTex.contentEquals("")) {
            this.func_147499_a(CommonProxy.FRAME_BLOCK);
        } else {
            this.func_147499_a(this.customTexture);
        }
        if (this.isDouble) {
            this.model.renderLargeChest(this.isLeft);
            GL11.glRotatef((float)(-(f1 * 90.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
            this.model.renderLargeLid(this.isLeft);
            if (this.isLeft) {
                this.func_147499_a(CommonProxy.IRON);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.5f);
                this.model.renderLatch();
            }
        } else {
            this.model.renderSmallChest();
            GL11.glRotatef((float)(-(f1 * 90.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
            this.model.renderSmallChestLid();
            this.func_147499_a(CommonProxy.IRON);
            this.model.renderLatch();
        }
        this.mc.field_71474_y.field_74347_j = graphicState;
        this.fancyGraphics = graphicState;
        GL11.glPopMatrix();
    }

    private void setChestInnardTexture(ItemStack stack, TileEntityFramedChest chest) {
        if (stack != null) {
            if (Config.isBlock(stack)) {
                IIcon icon;
                Block thing = Block.func_149634_a((Item)stack.func_77973_b());
                if (thing != null && (icon = thing.func_149691_a(2, stack.func_77960_j())) != null) {
                    String iconName = thing.func_149691_a(2, stack.func_77960_j()).func_94215_i();
                    if (iconName.contains("ic2")) {
                        iconName = iconName.replace(":5", "");
                    }
                    chest.customChestFillerTexture = BiblioRenderHelper.getBlockResource(iconName);
                    return;
                }
            } else {
                chest.customChestFillerTexture = BiblioRenderHelper.getItemResource(stack.func_77954_c());
                return;
            }
        }
        this.customTextureInside = null;
    }
}

