/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.network;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.BiblioSortingHelper;
import jds.bibliocraft.crafting.BiblioCraftingManager;
import jds.bibliocraft.gui.GuiAtlasMap;
import jds.bibliocraft.gui.GuiAtlasWaypointTransfer;
import jds.bibliocraft.gui.GuiStockCatalog;
import jds.bibliocraft.helpers.SortedListItem;
import jds.bibliocraft.items.ItemDrill;
import jds.bibliocraft.items.ItemRecipeBook;
import jds.bibliocraft.tileentities.TileEntityMapFrame;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ClientPacketHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        FMLProxyPacket packet = event.packet;
        if (packet != null) {
            if (packet.channel().equals("BiblioAStand")) {
                this.handlePlayerArmorUpdate(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioDrillText")) {
                this.handPlayerDrillTextUpdate(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioAtlas")) {
                this.handPlayerAtlasUpdate(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioAtlasSWP")) {
                this.handleAtlasSwap(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioAtlasTGUI")) {
                this.handleAtlasTransferGUI(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioPaneler")) {
                this.handlePanelerTextureStringPacket(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioRecipeText")) {
                this.handleRecipeBookText(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioStockLog")) {
                this.handleBiblioStockroomCatalog(packet.payload(), (EntityPlayer)player);
            }
        }
    }

    private void handleBiblioStockroomCatalog(ByteBuf packet, EntityPlayer player) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)packet);
        if (tags != null) {
            NBTTagList comp = tags.func_150295_c("compasses", 10);
            int[] compasses = new int[]{-1, -1, -1, -1, -1, -1, -1, -1};
            ItemStack[] compassStacks = new ItemStack[]{null, null, null, null, null, null, null, null};
            for (int i = 0; i < comp.func_74745_c(); ++i) {
                int compSlot;
                NBTTagCompound compTag = comp.func_150305_b(i);
                if (compTag == null) continue;
                String invName = "compass" + i;
                String invSlotName = "slot" + i;
                compasses[i] = compSlot = compTag.func_74762_e(invSlotName);
                if (compSlot == -1) continue;
                compassStacks[i] = ItemStack.func_77949_a((NBTTagCompound)compTag);
            }
            NBTTagList alphaTagList = tags.func_150295_c("alphaList", 10);
            ArrayList<SortedListItem> alphaList = BiblioSortingHelper.convertNBTTagListToArrayList(alphaTagList);
            NBTTagList quanaTagList = tags.func_150295_c("quantaList", 10);
            ArrayList<SortedListItem> quantaList = BiblioSortingHelper.convertNBTTagListToArrayList(quanaTagList);
            this.openCatalogGUI(player, alphaList, quantaList, compassStacks, compasses, tags.func_74779_i("title"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void openCatalogGUI(EntityPlayer player, ArrayList<SortedListItem> AlphaList, ArrayList<SortedListItem> QuantaList, ItemStack[] stacks, int[] compasses, String title) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiStockCatalog(player, AlphaList, QuantaList, stacks, compasses, title));
    }

    private void handleRecipeBookText(ByteBuf packet, EntityPlayer player) {
        String text = ByteBufUtils.readUTF8String((ByteBuf)packet);
        int currentSlot = packet.readInt();
        ItemStack currentBook = player.field_71071_by.func_70301_a(currentSlot);
        if (currentBook != null && currentBook.func_77973_b() instanceof ItemRecipeBook) {
            ItemRecipeBook book = (ItemRecipeBook)currentBook.func_77973_b();
            book.updateFromPacket(text);
        }
    }

    private void handlePanelerTextureStringPacket(ByteBuf packet, EntityPlayer player) {
        Block thing;
        ItemStack panels = ByteBufUtils.readItemStack((ByteBuf)packet);
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        String iconName = "none";
        if (panels != null && (thing = Block.func_149634_a((Item)panels.func_77973_b())) != null) {
            IIcon blockIcon = thing.func_149691_a(2, panels.func_77960_j());
            IIcon itemIcon = panels.func_77973_b().getIcon(panels, 0);
            if (blockIcon != null) {
                iconName = blockIcon.func_94215_i();
                if (iconName.contains("ic2")) {
                    iconName = iconName.replace(":5", "");
                } else if (iconName.contains("forestry:wood") && itemIcon != null) {
                    iconName = itemIcon.func_94215_i();
                }
            } else if (itemIcon != null) {
                iconName = itemIcon.func_94215_i();
            }
        }
        ByteBuf buffer = Unpooled.buffer();
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)iconName);
        buffer.writeInt(x);
        buffer.writeInt(y);
        buffer.writeInt(z);
        BiblioCraft.ch_BiblioPaneler.sendToServer(new FMLProxyPacket(buffer, "BiblioPaneler"));
    }

    private void handlePanelerRecipePacket(ByteBuf packet, EntityPlayer player) {
        ItemStack panels = ByteBufUtils.readItemStack((ByteBuf)packet);
        ItemStack input = ByteBufUtils.readItemStack((ByteBuf)packet);
        int x = packet.readInt();
        int y = packet.readInt();
        int z = packet.readInt();
        ItemStack output = BiblioCraftingManager.getInstance().findMatchingRecipeForPaneler(input, panels);
        ByteBuf buffer = Unpooled.buffer();
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)output);
        buffer.writeInt(x);
        buffer.writeInt(y);
        buffer.writeInt(z);
        BiblioCraft.ch_BiblioPaneler.sendToServer(new FMLProxyPacket(buffer, "BiblioPaneler"));
    }

    private void handleAtlasTransferGUI(ByteBuf packet, EntityPlayer player) {
        int z;
        int y;
        ItemStack atlas = ByteBufUtils.readItemStack((ByteBuf)packet);
        int x = packet.readInt();
        TileEntityMapFrame tile = (TileEntityMapFrame)player.field_70170_p.func_147438_o(x, y = packet.readInt(), z = packet.readInt());
        if (tile != null) {
            this.openWaypointTransferGUI(player.field_70170_p, player, atlas, tile);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void openWaypointTransferGUI(World world, EntityPlayer player, ItemStack stack, TileEntityMapFrame tile) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAtlasWaypointTransfer(world, player, stack, tile));
    }

    private void handleAtlasSwap(ByteBuf packet, EntityPlayer player) {
        player.field_70125_A = 50.0f;
        ItemStack atlas = ByteBufUtils.readItemStack((ByteBuf)packet);
        this.openMapGUI(player, atlas);
    }

    @SideOnly(value=Side.CLIENT)
    public void openMapGUI(EntityPlayer player, ItemStack stack) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAtlasMap(player.field_70170_p, player, stack));
    }

    private void handPlayerAtlasUpdate(ByteBuf packet, EntityPlayer player) {
        ItemStack atlas = ByteBufUtils.readItemStack((ByteBuf)packet);
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, atlas);
    }

    private void handlePlayerArmorUpdate(ByteBuf packet, EntityPlayer player) {
        ItemStack armor = null;
        int armorslot = -1;
        armor = ByteBufUtils.readItemStack((ByteBuf)packet);
        armorslot = packet.readInt();
        if (armorslot != -1) {
            player.field_71071_by.field_70460_b[armorslot] = armor;
        }
    }

    private void handPlayerDrillTextUpdate(ByteBuf packet, EntityPlayer player) {
        String displayText = ByteBufUtils.readUTF8String((ByteBuf)packet);
        ItemStack playerhand = player.func_70694_bm();
        if (playerhand != null && playerhand.func_77973_b() instanceof ItemDrill) {
            ItemDrill drill = (ItemDrill)playerhand.func_77973_b();
            drill.updateFromPacket(displayText);
        }
    }
}

