/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.rituals;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.RitualEffect;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.block.BlockSpectralContainer;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class RitualEffectWater
extends RitualEffect {
    public static final int aquasalusDrain = 5;
    public static final int offensaDrain = 20;
    public static final int sanctusDrain = 5;
    public static final int reductusDrain = 2;
    public static final int crystallosDrain = 10;

    @Override
    public void performEffect(IMasterRitualStone ritualStone) {
        String owner = ritualStone.getOwner();
        int currentEssence = SoulNetworkHandler.getCurrentEssence(owner);
        World world = ritualStone.getWorld();
        int x = ritualStone.getXCoord();
        int y = ritualStone.getYCoord();
        int z = ritualStone.getZCoord();
        boolean hasCrystallos = this.canDrainReagent(ritualStone, ReagentRegistry.crystallosReagent, 10, false);
        boolean hasAquasalus = this.canDrainReagent(ritualStone, ReagentRegistry.aquasalusReagent, 5, false);
        boolean hasOffensa = this.canDrainReagent(ritualStone, ReagentRegistry.offensaReagent, 20, false);
        if (hasAquasalus) {
            int hydrationRange = 4;
            int vertRange = 3;
            for (int i = -hydrationRange; i <= hydrationRange; ++i) {
                for (int j = -vertRange; j <= vertRange; ++j) {
                    for (int k = -hydrationRange; k <= hydrationRange; ++k) {
                        if (!SpellHelper.hydrateSoil(world, x + i, y + j, z + k)) continue;
                        this.canDrainReagent(ritualStone, ReagentRegistry.aquasalusReagent, 5, true);
                    }
                }
            }
        }
        if (hasOffensa) {
            boolean hasReductus = this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 2, false);
            boolean drainReductus = world.func_72820_D() % 100L == 0L;
            int range = 10;
            List<Entity> list = SpellHelper.getEntitiesInRange(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, range, range);
            for (Entity entity : list) {
                EntityLivingBase livingEntity;
                if (!(entity instanceof EntityLivingBase) || (livingEntity = (EntityLivingBase)entity) == SpellHelper.getPlayerForUsername(owner)) continue;
                if (hasReductus && this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 2, false) && livingEntity instanceof EntityPlayer) {
                    if (!drainReductus) continue;
                    this.canDrainReagent(ritualStone, ReagentRegistry.reductusReagent, 2, true);
                    continue;
                }
                if (livingEntity.func_70644_a(AlchemicalWizardry.customPotionDrowning)) continue;
                livingEntity.func_70690_d(new PotionEffect(AlchemicalWizardry.customPotionDrowning.field_76415_H, 100, 0));
                this.canDrainReagent(ritualStone, ReagentRegistry.offensaReagent, 20, true);
            }
        }
        Block block = world.func_147439_a(x, y + 1, z);
        if (world.func_147437_c(x, y + 1, z) && !(block instanceof BlockSpectralContainer)) {
            if (currentEssence < this.getCostPerRefresh()) {
                SoulNetworkHandler.causeNauseaToPlayer(owner);
            } else {
                for (int i = 0; i < 10; ++i) {
                    SpellHelper.sendIndexedParticleToAllAround(world, x, y, z, 20, world.field_73011_w.field_76574_g, 3, x, y, z);
                }
                world.func_147465_d(x, y + 1, z, Blocks.field_150355_j, 0, 3);
                SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh());
            }
        } else {
            int amount;
            boolean hasSanctus = this.canDrainReagent(ritualStone, ReagentRegistry.sanctusReagent, 5, false);
            if (!hasSanctus) {
                return;
            }
            TileEntity tile = world.func_147438_o(x, y + 1, z);
            if (tile instanceof IFluidHandler && (amount = ((IFluidHandler)tile).fill(ForgeDirection.DOWN, new FluidStack(FluidRegistry.WATER, 1000), false)) >= 1000) {
                ((IFluidHandler)tile).fill(ForgeDirection.DOWN, new FluidStack(FluidRegistry.WATER, 1000), true);
                this.canDrainReagent(ritualStone, ReagentRegistry.sanctusReagent, 5, true);
                SoulNetworkHandler.syphonFromNetwork(owner, this.getCostPerRefresh());
            }
        }
        if (hasCrystallos) {
            int range = 2;
            for (int i = -range; i <= range; ++i) {
                for (int j = -range; j <= range; ++j) {
                    for (int k = -range; k <= range; ++k) {
                        boolean bl = hasCrystallos = hasCrystallos && this.canDrainReagent(ritualStone, ReagentRegistry.crystallosReagent, 10, false);
                        if (!hasCrystallos) continue;
                        boolean success = false;
                        if (!world.func_147437_c(x + i, y + j, z + k) && SpellHelper.freezeWaterBlock(world, x + i, y + j, z + k)) {
                            success = true;
                        } else if (world.field_73012_v.nextInt(100) == 0 && world.isSideSolid(x + i, y + j - 1, z + k, ForgeDirection.UP)) {
                            success = true;
                        }
                        if (!success) continue;
                        this.canDrainReagent(ritualStone, ReagentRegistry.crystallosReagent, 10, true);
                    }
                }
            }
        }
    }

    @Override
    public int getCostPerRefresh() {
        return AlchemicalWizardry.ritualCostWater[1];
    }

    @Override
    public List<RitualComponent> getRitualComponentList() {
        ArrayList<RitualComponent> waterRitual = new ArrayList<RitualComponent>();
        waterRitual.add(new RitualComponent(-1, 0, 1, 1));
        waterRitual.add(new RitualComponent(-1, 0, -1, 1));
        waterRitual.add(new RitualComponent(1, 0, -1, 1));
        waterRitual.add(new RitualComponent(1, 0, 1, 1));
        return waterRitual;
    }
}

