/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import com.google.common.base.Preconditions;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.inventory.legacy.CustomSinks;
import openmods.inventory.legacy.ItemDistribution;
import openmods.utils.InventoryUtils;
import openperipheral.api.adapter.IAdapterWithConstraints;
import openperipheral.api.adapter.IPeripheralAdapter;
import openperipheral.api.adapter.IWorldPosProvider;
import openperipheral.api.adapter.method.Alias;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.Optionals;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.helpers.Index;

public class AdapterWorldInventory
implements IPeripheralAdapter,
IAdapterWithConstraints {
    private static final int ANY_SLOT = -1;
    private static final Index ANY_SLOT_INDEX = new Index(-1, 0);

    @Override
    public boolean canApply(Class<?> target) {
        return TileEntity.class.isAssignableFrom(target) || IWorldPosProvider.class.isAssignableFrom(target);
    }

    @Override
    public Class<?> getTargetClass() {
        return IInventory.class;
    }

    @Override
    public String getSourceId() {
        return "inventory-world";
    }

    private static void checkSlotId(IInventory inventory, Index slot, String name) {
        Preconditions.checkNotNull((Object)inventory, (Object)"Invalid inventory");
        if (slot.value != -1) {
            slot.checkElementIndex(name + " slot id", inventory.func_70302_i_());
        }
    }

    private static IWorldPosProvider getProvider(IInventory target) {
        if (target instanceof IWorldPosProvider) {
            return (IWorldPosProvider)target;
        }
        if (target instanceof TileEntity) {
            final TileEntity te = (TileEntity)target;
            return new IWorldPosProvider(){

                @Override
                public boolean isValid() {
                    return !te.func_145837_r();
                }

                @Override
                public World getWorld() {
                    return te.func_145831_w();
                }

                @Override
                public int getX() {
                    return te.field_145851_c;
                }

                @Override
                public int getY() {
                    return te.field_145848_d;
                }

                @Override
                public int getZ() {
                    return te.field_145849_e;
                }
            };
        }
        throw new IllegalArgumentException("Invalid target object " + String.valueOf(target));
    }

    private static TileEntity getNeighborTarget(IInventory target, ForgeDirection direction) {
        Preconditions.checkNotNull((Object)direction, (Object)"Invalid direction");
        Preconditions.checkArgument((direction != ForgeDirection.UNKNOWN ? 1 : 0) != 0, (Object)"Invalid direction");
        IWorldPosProvider provider = AdapterWorldInventory.getProvider(target);
        World world = provider.getWorld();
        return world.func_147438_o(provider.getX() + direction.offsetX, provider.getY() + direction.offsetY, provider.getZ() + direction.offsetZ);
    }

    @Alias(value={"pullItemIntoSlot"})
    @ScriptCallable(returnTypes={ReturnType.NUMBER}, description="Pull an item from a slot in another inventory into a slot in this one. Returns the amount of items moved")
    public int pullItem(IInventory target, @Arg(name="direction", description="The direction of the other inventory") ForgeDirection direction, @Arg(name="slot", description="The slot in the OTHER inventory that you're pulling from") Index fromSlot, @Optionals @Arg(name="maxAmount", description="The maximum amount of items you want to pull") Integer maxAmount, @Arg(name="intoSlot", description="The slot in the current inventory that you want to pull into") Index intoSlot) {
        TileEntity otherTarget = AdapterWorldInventory.getNeighborTarget(target, direction);
        if (otherTarget == null) {
            throw new IllegalArgumentException("Other block not found");
        }
        if (!(otherTarget instanceof IInventory)) {
            throw new IllegalArgumentException("Other block is not inventory");
        }
        IInventory otherInventory = InventoryUtils.getInventory((IInventory)((IInventory)otherTarget));
        IInventory thisInventory = InventoryUtils.getInventory((IInventory)target);
        if (otherTarget == target) {
            return 0;
        }
        if (maxAmount == null) {
            maxAmount = 64;
        }
        if (intoSlot == null) {
            intoSlot = ANY_SLOT_INDEX;
        }
        AdapterWorldInventory.checkSlotId(otherInventory, fromSlot, "input");
        AdapterWorldInventory.checkSlotId(thisInventory, intoSlot, "output");
        int amount = ItemDistribution.moveItemInto((IInventory)otherInventory, (int)fromSlot.value, (IInventory)thisInventory, (int)intoSlot.value, (int)maxAmount, (ForgeDirection)direction.getOpposite(), (boolean)true);
        if (amount > 0) {
            thisInventory.func_70296_d();
            otherInventory.func_70296_d();
        }
        return amount;
    }

    @Alias(value={"pushItemIntoSlot"})
    @ScriptCallable(returnTypes={ReturnType.NUMBER}, description="Push an item from the current inventory into pipe or slot on the other inventory. Returns the amount of items moved")
    public int pushItem(IInventory target, @Arg(name="direction", description="The direction of the other inventory") ForgeDirection direction, @Arg(name="slot", description="The slot in the current inventory that you're pushing from") Index fromSlot, @Optionals @Arg(name="maxAmount", description="The maximum amount of items you want to push") Integer maxAmount, @Arg(name="intoSlot", description="The slot in the other inventory that you want to push into (ignored when target is pipe") Index intoSlot) {
        int amount;
        TileEntity otherTarget = AdapterWorldInventory.getNeighborTarget(target, direction);
        Preconditions.checkNotNull((Object)otherTarget, (Object)"Other target not found");
        IInventory thisInventory = InventoryUtils.getInventory((IInventory)target);
        if (maxAmount == null) {
            maxAmount = 64;
        }
        if (intoSlot == null) {
            intoSlot = ANY_SLOT_INDEX;
        }
        AdapterWorldInventory.checkSlotId(thisInventory, fromSlot, "input");
        if (otherTarget instanceof IInventory) {
            IInventory otherInventory = InventoryUtils.getInventory((IInventory)((IInventory)otherTarget));
            AdapterWorldInventory.checkSlotId(otherInventory, intoSlot, "output");
            amount = ItemDistribution.moveItemInto((IInventory)thisInventory, (int)fromSlot.value, (IInventory)otherInventory, (int)intoSlot.value, (int)maxAmount, (ForgeDirection)direction, (boolean)true);
            if (amount > 0) {
                otherInventory.func_70296_d();
            }
        } else {
            CustomSinks.ICustomSink adapter = CustomSinks.createSink((TileEntity)otherTarget);
            if (adapter == null) {
                throw new IllegalArgumentException("Invalid target");
            }
            amount = ItemDistribution.moveItemInto((IInventory)thisInventory, (int)fromSlot.value, (CustomSinks.ICustomSink)adapter, (int)maxAmount, (ForgeDirection)direction, (boolean)true);
        }
        if (amount > 0) {
            thisInventory.func_70296_d();
        }
        return amount;
    }
}

