/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.inventory.legacy.ItemDistribution;
import openmods.utils.InventoryUtils;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.IPeripheralAdapter;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.Env;
import openperipheral.api.adapter.method.Optionals;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.architecture.IArchitecture;
import openperipheral.api.helpers.Index;
import openperipheral.integration.OpcAccess;

@Asynchronous
public class AdapterInventory
implements IPeripheralAdapter {
    private static final int ANY_SLOT = -1;

    @Override
    public Class<?> getTargetClass() {
        return IInventory.class;
    }

    @Override
    public String getSourceId() {
        return "inventory";
    }

    @ScriptCallable(returnTypes={ReturnType.STRING}, description="Get the name of this inventory")
    public String getInventoryName(IInventory target) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        return inventory != null ? inventory.func_145825_b() : null;
    }

    @ScriptCallable(returnTypes={ReturnType.NUMBER}, description="Get the size of this inventory")
    public int getInventorySize(IInventory target) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        return inventory != null ? inventory.func_70302_i_() : 0;
    }

    @Asynchronous(value=false)
    @ScriptCallable(description="Condense and tidy the stacks in an inventory")
    public void condenseItems(IInventory target) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        ArrayList stacks = Lists.newArrayList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack sta = inventory.func_70301_a(i);
            if (sta != null) {
                stacks.add(sta.func_77946_l());
            }
            inventory.func_70299_a(i, null);
        }
        for (ItemStack stack : stacks) {
            ItemDistribution.insertItemIntoInventory((IInventory)inventory, (ItemStack)stack, (ForgeDirection)ForgeDirection.UNKNOWN, (int)-1);
        }
        target.func_70296_d();
    }

    @Asynchronous(value=false)
    @ScriptCallable(description="Swap two slots in the inventory")
    public void swapStacks(IInventory target, @Arg(name="from", description="The first slot") Index fromSlot, @Arg(name="to", description="The other slot") Index intoSlot, @Optionals @Arg(name="fromDirection") ForgeDirection fromDirection, @Arg(name="fromDirection") ForgeDirection toDirection) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        Preconditions.checkNotNull((Object)inventory, (Object)"Invalid target!");
        int size = inventory.func_70302_i_();
        fromSlot.checkElementIndex("first slot id", size);
        intoSlot.checkElementIndex("second slot id", size);
        if (inventory instanceof ISidedInventory) {
            InventoryUtils.swapStacks((ISidedInventory)((ISidedInventory)inventory), (int)fromSlot.value, (ForgeDirection)((ForgeDirection)Objects.firstNonNull((Object)fromDirection, (Object)ForgeDirection.UNKNOWN)), (int)intoSlot.value, (ForgeDirection)((ForgeDirection)Objects.firstNonNull((Object)toDirection, (Object)ForgeDirection.UNKNOWN)));
        } else {
            InventoryUtils.swapStacks((IInventory)inventory, (int)fromSlot.value, (int)intoSlot.value);
        }
        inventory.func_70296_d();
    }

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Get details of an item in a particular slot")
    public Object getStackInSlot(IInventory target, @Arg(name="slotNumber", description="Slot number") Index slot, @Optionals @Arg(name="proxy", description="If true, method will return proxy instead of computing whole table") Boolean proxy) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        slot.checkElementIndex("slot id", inventory.func_70302_i_());
        ItemStack stack = inventory.func_70301_a(slot.value);
        return proxy == Boolean.TRUE ? OpcAccess.itemStackMetaBuilder.createProxy(stack) : stack;
    }

    @ScriptCallable(returnTypes={ReturnType.TABLE}, description="Get a table with all the items of the chest")
    public Map<Index, Object> getAllStacks(IInventory target, @Env(value="architecture") IArchitecture access, @Optionals @Arg(name="proxy", description="If false, method will compute whole table, instead of returning proxy") Boolean proxy) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        HashMap result = Maps.newHashMap();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            result.put(access.createIndex(i), proxy != Boolean.FALSE ? OpcAccess.itemStackMetaBuilder.createProxy(stack) : stack);
        }
        return result;
    }

    @Asynchronous(value=false)
    @ScriptCallable(description="Destroy a stack")
    public void destroyStack(IInventory target, @Arg(name="slotNumber", description="The slot number") Index slot) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        slot.checkElementIndex("slot id", inventory.func_70302_i_());
        inventory.func_70299_a(slot.value, null);
        inventory.func_70296_d();
    }

    @ScriptCallable(returnTypes={ReturnType.TABLE}, description="Get full stack information from id and/or damage")
    public ItemStack expandStack(IInventory target, @Arg(name="stack") ItemStack itemStack) {
        return itemStack;
    }
}

