/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import com.google.common.base.Preconditions;
import net.minecraft.tileentity.TileEntityDaylightDetector;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import openperipheral.api.adapter.IPeripheralAdapter;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;

public class AdapterDaylightSensor
implements IPeripheralAdapter {
    @Override
    public Class<?> getTargetClass() {
        return TileEntityDaylightDetector.class;
    }

    @Override
    public String getSourceId() {
        return "vanilla_daylight_sensor";
    }

    @ScriptCallable(returnTypes={ReturnType.BOOLEAN}, description="Get true if age has normal sky")
    public boolean hasSky(TileEntityDaylightDetector target) {
        World world = target.func_145831_w();
        return !world.field_73011_w.field_76576_e;
    }

    @ScriptCallable(returnTypes={ReturnType.NUMBER}, description="Get level of natural light (sky)")
    public int getSkyLight(TileEntityDaylightDetector target) {
        World world = target.func_145831_w();
        Preconditions.checkArgument((!world.field_73011_w.field_76576_e ? 1 : 0) != 0, (Object)"World has no sky");
        return world.func_72972_b(EnumSkyBlock.Sky, target.field_145851_c, target.field_145848_d, target.field_145849_e) - world.field_73008_k;
    }

    @ScriptCallable(returnTypes={ReturnType.NUMBER}, description="Get level of block light")
    public int getBlockLight(TileEntityDaylightDetector target) {
        World world = target.func_145831_w();
        return world.func_72972_b(EnumSkyBlock.Block, target.field_145851_c, target.field_145848_d, target.field_145849_e);
    }

    @ScriptCallable(returnTypes={ReturnType.NUMBER}, description="Get angle of sun (in degrees, 0 is zenith)")
    public float getCelestialAngle(TileEntityDaylightDetector target) {
        World world = target.func_145831_w();
        return world.func_72826_c(1.0f) * 360.0f;
    }
}

