/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.mystcraft.v2;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xcompwiz.mystcraft.api.hook.LinkPropertyAPI;
import com.xcompwiz.mystcraft.api.item.IItemPortalActivator;
import com.xcompwiz.mystcraft.api.linking.ILinkInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import openperipheral.api.helpers.ItemStackMetaProviderSimple;
import openperipheral.api.meta.IItemStackCustomMetaProvider;
import openperipheral.integration.mystcraft.v2.MystcraftAccess;

public class BookMetaProvider
extends ItemStackMetaProviderSimple<IItemPortalActivator>
implements IItemStackCustomMetaProvider<IItemPortalActivator> {
    @Override
    public String getKey() {
        return "myst_book";
    }

    private static ILinkInfo getLinkInfo(ItemStack stack) {
        if (MystcraftAccess.linkingApi == null) {
            return null;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return null;
        }
        return MystcraftAccess.linkingApi.createLinkInfo(tag);
    }

    @Override
    public boolean canApply(IItemPortalActivator target, ItemStack stack) {
        return BookMetaProvider.getLinkInfo(stack) != null;
    }

    @Override
    public Object getMeta(IItemPortalActivator target, ItemStack stack) {
        ChunkCoordinates coords;
        ILinkInfo linkInfo = BookMetaProvider.getLinkInfo(stack);
        if (linkInfo == null) {
            return null;
        }
        String unlocalizedName = stack.func_77977_a();
        boolean isLinkbook = "item.myst.linkbook".equals(unlocalizedName);
        boolean isAgebook = "item.myst.agebook".equals(unlocalizedName);
        HashMap result = Maps.newHashMap();
        result.put("type", isLinkbook ? "link" : (isAgebook ? "age" : "unknown"));
        result.put("destination", linkInfo.getDisplayName());
        result.put("dimension", linkInfo.getDimensionUID());
        LinkPropertyAPI linkPropertiesApi = MystcraftAccess.linkPropertiesApi;
        if (linkPropertiesApi != null) {
            Collection allProperties = linkPropertiesApi.getLinkProperties();
            HashSet flags = Sets.newHashSet();
            for (String flag : allProperties) {
                if (!linkInfo.getFlag(flag)) continue;
                flags.add(flag);
            }
            result.put("flags", flags);
        }
        if ((coords = linkInfo.getSpawn()) != null) {
            result.put("spawn", Lists.newArrayList((Object[])new Integer[]{coords.field_71574_a, coords.field_71572_b, coords.field_71573_c}));
        }
        result.put("spawnYaw", Float.valueOf(linkInfo.getSpawnYaw()));
        return result;
    }
}

