/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.mystcraft.v2;

import com.google.common.base.Preconditions;
import com.xcompwiz.mystcraft.api.item.IItemPageCollection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.inventory.GenericInventory;
import openmods.inventory.legacy.ItemDistribution;
import openmods.reflection.MethodAccess;
import openmods.reflection.ReflectionHelper;
import openmods.utils.BlockUtils;
import openperipheral.api.adapter.IPeripheralAdapter;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.Optionals;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.helpers.Index;
import openperipheral.integration.mystcraft.v2.MystcraftAccess;
import openperipheral.integration.mystcraft.v2.NotebookWrapper;

public class AdapterWritingDesk
implements IPeripheralAdapter {
    private final Class<?> CLASS = ReflectionHelper.getClass((String)"com.xcompwiz.mystcraft.tileentity.TileEntityDesk");
    private final MethodAccess.Function0<Integer> GET_MAX_NOTEBOOK_COUNT = MethodAccess.create(Integer.TYPE, this.CLASS, (String[])new String[]{"getMaxSurfaceTabCount"});
    private final MethodAccess.Function1<ItemStack, Byte> GET_NOTEBOOK = MethodAccess.create(ItemStack.class, this.CLASS, Byte.TYPE, (String[])new String[]{"getTabItem"});
    private final MethodAccess.Function2<Void, EntityPlayer, String> WRITE_SYMBOL = MethodAccess.create(Void.TYPE, this.CLASS, EntityPlayer.class, String.class, (String[])new String[]{"writeSymbol"});

    @Override
    public Class<?> getTargetClass() {
        return this.CLASS;
    }

    @Override
    public String getSourceId() {
        return "mystcraft_desk";
    }

    @ScriptCallable(description="Get the maximum number of notebooks this desk can store", returnTypes={ReturnType.NUMBER})
    public int getMaxNotebookCount(Object tileEntityDesk) {
        return (Integer)this.GET_MAX_NOTEBOOK_COUNT.call(tileEntityDesk);
    }

    @ScriptCallable(description="Get notebook wrapper", returnTypes={ReturnType.OBJECT})
    public NotebookWrapper getNotebook(TileEntity desk, @Arg(name="slot", description="The writing desk slot you are interested in") Index deskSlot) {
        return this.createInventoryWrapper(desk, deskSlot);
    }

    @ScriptCallable(returnTypes={ReturnType.NUMBER}, description="Push a page from the notebook into a specific slot in external inventory. Returns the amount of items moved")
    public int pushNotebookPage(TileEntity desk, @Arg(name="deskSlot") Index deskSlot, @Arg(name="direction", description="The direction of the other inventory. (north, south, east, west, up or down)") ForgeDirection direction, @Arg(name="fromSlot", description="The page slot in inventory that you're pushing from") Index fromSlot, @Optionals @Arg(name="intoSlot", description="The slot in the other inventory that you want to push into") Index intoSlot) {
        int result;
        int remains;
        NotebookWrapper wrapper = this.createInventoryWrapper(desk, deskSlot);
        ItemStack page = wrapper.getPageFromSlot(fromSlot);
        ItemStack removedPage = wrapper.removePage(page);
        Preconditions.checkNotNull((Object)removedPage, (Object)"No page in notebook");
        GenericInventory tmp = new GenericInventory("tmp", false, 1);
        tmp.func_70299_a(0, removedPage.func_77946_l());
        IInventory target = AdapterWritingDesk.getTargetTile(desk, direction);
        if (intoSlot == null) {
            intoSlot = new Index(-1, 0);
        }
        if ((remains = removedPage.field_77994_a - (result = ItemDistribution.moveItemInto((IInventory)tmp, (int)0, (IInventory)target, (int)intoSlot.value, (int)removedPage.field_77994_a, (ForgeDirection)direction, (boolean)true))) >= 0) {
            ItemStack returns = removedPage.func_77946_l();
            returns.field_77994_a = remains;
            wrapper.addPage(returns);
        }
        return result;
    }

    @ScriptCallable(returnTypes={ReturnType.BOOLEAN}, description="Pull an item from the target inventory into any slot in the current one. Returns true if item was consumed")
    public boolean pullNotebookPage(TileEntity desk, @Arg(name="deskSlot") Index deskSlot, @Arg(name="direction", description="The direction of the other inventory)") ForgeDirection direction, @Arg(name="fromSlot", description="The slot in the other inventory that you're pulling from") Index fromSlot) {
        IInventory inv = AdapterWritingDesk.getTargetTile(desk, direction);
        fromSlot.checkElementIndex("input slot", inv.func_70302_i_());
        ItemStack stack = inv.func_70301_a(fromSlot.value);
        Preconditions.checkNotNull((Object)stack, (Object)"Other inventory empty");
        NotebookWrapper wrapper = this.createInventoryWrapper(desk, deskSlot);
        ItemStack added = wrapper.addPage(stack);
        inv.func_70299_a(fromSlot.value, added);
        inv.func_70296_d();
        return added == null;
    }

    @ScriptCallable(description="Create a symbol page from the target symbol")
    public void writeSymbol(final TileEntity desk, @Arg(name="deskSlot") Index deskSlot, @Arg(name="notebookSlot", description="The source symbol to copy") Index notebookSlot) {
        Preconditions.checkNotNull((Object)MystcraftAccess.pageApi, (Object)"Functionality not available");
        NotebookWrapper wrapper = this.createInventoryWrapper(desk, deskSlot);
        ItemStack page = wrapper.getPageFromSlot(notebookSlot);
        final String symbol = MystcraftAccess.pageApi.getPageSymbol(page);
        if (symbol != null) {
            FakePlayerPool.instance.executeOnPlayer((WorldServer)desk.func_145831_w(), new FakePlayerPool.PlayerUser(){

                public void usePlayer(OpenModsFakePlayer fakePlayer) {
                    AdapterWritingDesk.this.WRITE_SYMBOL.call((Object)desk, (Object)fakePlayer, (Object)symbol);
                }
            });
        }
    }

    private static IInventory getTargetTile(TileEntity target, ForgeDirection direction) {
        Preconditions.checkArgument((direction != ForgeDirection.UNKNOWN ? 1 : 0) != 0, (Object)"Invalid direction");
        TileEntity targetTile = BlockUtils.getTileInDirection((TileEntity)target, (ForgeDirection)direction);
        Preconditions.checkArgument((boolean)(targetTile instanceof IInventory), (Object)"Target direction is not a valid inventory");
        return (IInventory)targetTile;
    }

    private NotebookWrapper createInventoryWrapper(TileEntity tile, Index slot) {
        ItemStack notebook = (ItemStack)this.GET_NOTEBOOK.call((Object)tile, (Object)slot.byteValue());
        Preconditions.checkState((notebook != null ? 1 : 0) != 0, (Object)"Empty slot");
        Item item = notebook.func_77973_b();
        Preconditions.checkState((boolean)(item instanceof IItemPageCollection), (Object)"Invalid item in slot");
        return new NotebookWrapper((WorldServer)tile.func_145831_w(), (IItemPageCollection)item, notebook);
    }
}

