/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.forestry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.item.ItemStack;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.IPeripheralAdapter;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;

public class AdapterBeeHousing
implements IPeripheralAdapter {
    private static final String MUTATION_RESULT = "result";
    private static final String MUTATION_CONDITIONS = "specialConditions";
    private static final String MUTATION_CHANCE = "chance";
    private static final String ALLELE_2 = "allele2";
    private static final String ALLELE_1 = "allele1";

    @Override
    public Class<?> getTargetClass() {
        return IBeeHousing.class;
    }

    @Override
    public String getSourceId() {
        return "forestry_bees";
    }

    @ScriptCallable(returnTypes={ReturnType.BOOLEAN}, description="Can the bees breed?")
    public boolean canBreed(IBeeHousing beeHousing) {
        return beeHousing.canBreed();
    }

    @ScriptCallable(returnTypes={ReturnType.TABLE}, description="Get the drone")
    public IIndividual getDrone(IBeeHousing beeHousing) {
        ItemStack drone = beeHousing.getDrone();
        if (drone != null) {
            return AlleleManager.alleleRegistry.getIndividual(drone);
        }
        return null;
    }

    @ScriptCallable(returnTypes={ReturnType.TABLE}, description="Get the queen")
    public IIndividual getQueen(IBeeHousing beeHousing) {
        ItemStack queen = beeHousing.getQueen();
        if (queen != null) {
            return AlleleManager.alleleRegistry.getIndividual(queen);
        }
        return null;
    }

    @Asynchronous
    @ScriptCallable(returnTypes={ReturnType.TABLE}, description="Get the full breeding list thingy. Experimental!")
    public List<Map<String, Object>> getBeeBreedingData(IBeeHousing housing) {
        ISpeciesRoot beeRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
        if (beeRoot == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (IMutation mutation : beeRoot.getMutations(false)) {
            HashMap mutationMap = Maps.newHashMap();
            try {
                IAllele[] template;
                IAllele allele2;
                IAllele allele1 = mutation.getAllele0();
                if (allele1 != null) {
                    mutationMap.put(ALLELE_1, allele1.getName());
                }
                if ((allele2 = mutation.getAllele1()) != null) {
                    mutationMap.put(ALLELE_2, allele2.getName());
                }
                if ((template = mutation.getTemplate()) != null && template.length > 0) {
                    mutationMap.put(MUTATION_RESULT, template[0].getName());
                }
                mutationMap.put(MUTATION_CHANCE, Float.valueOf(mutation.getBaseChance()));
                mutationMap.put(MUTATION_CONDITIONS, mutation.getSpecialConditions());
                result.add(mutationMap);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to get bee breeding information from %s, collected data: %s", mutation, mutationMap), e);
            }
        }
        return result;
    }

    @ScriptCallable(returnTypes={ReturnType.TABLE}, description="Get all known bees mutations")
    public List<Map<String, String>> listAllSpecies(IBeeHousing housing) {
        ISpeciesRoot beeRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
        if (beeRoot == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        for (IMutation mutation : beeRoot.getMutations(false)) {
            IAllele allele;
            IAllele[] template = mutation.getTemplate();
            if (template == null || template.length <= 0 || !((allele = template[0]) instanceof IAlleleSpecies)) continue;
            result.add(AdapterBeeHousing.serializeSpecies((IAlleleSpecies)allele));
        }
        return result;
    }

    @ScriptCallable(returnTypes={ReturnType.TABLE}, description="Get the parents for a particular mutation")
    public List<Map<String, Object>> getBeeParents(IBeeHousing housing, @Arg(name="childType", description="The type of bee you want the parents for") String childType) {
        ISpeciesRoot beeRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
        if (beeRoot == null) {
            return null;
        }
        ArrayList result = Lists.newArrayList();
        childType = childType.toLowerCase(Locale.ENGLISH);
        for (IMutation mutation : beeRoot.getMutations(false)) {
            IAllele allele;
            IAllele[] template = mutation.getTemplate();
            if (template == null || template.length < 1 || !((allele = template[0]) instanceof IAlleleSpecies)) continue;
            IAlleleSpecies species = (IAlleleSpecies)allele;
            String uid = species.getUID().toLowerCase(Locale.ENGLISH);
            String localizedName = species.getName().toLowerCase(Locale.ENGLISH);
            if (!localizedName.equals(childType) && !uid.equals(childType)) continue;
            Map<String, Object> parentMap = AdapterBeeHousing.serializeMutation(mutation);
            result.add(parentMap);
        }
        return result;
    }

    private static Map<String, String> serializeSpecies(IAlleleSpecies species) {
        HashMap result = Maps.newHashMap();
        result.put("name", species.getName());
        result.put("uid", species.getUID());
        return result;
    }

    private static Map<String, Object> serializeMutation(IMutation mutation) {
        IAllele allele2;
        HashMap parentMap = Maps.newHashMap();
        IAllele allele1 = mutation.getAllele0();
        if (allele1 instanceof IAlleleSpecies) {
            parentMap.put(ALLELE_1, AdapterBeeHousing.serializeSpecies((IAlleleSpecies)allele1));
        }
        if ((allele2 = mutation.getAllele1()) instanceof IAlleleSpecies) {
            parentMap.put(ALLELE_2, AdapterBeeHousing.serializeSpecies((IAlleleSpecies)allele2));
        }
        parentMap.put(MUTATION_CHANCE, Float.valueOf(mutation.getBaseChance()));
        parentMap.put(MUTATION_CONDITIONS, mutation.getSpecialConditions());
        return parentMap;
    }
}

