/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import openmods.geometry.BoundingBoxBuilder;
import openmods.geometry.Box2d;
import openperipheral.addons.glasses.utils.IPointListBuilder;
import openperipheral.addons.glasses.utils.Point2d;
import openperipheral.addons.glasses.utils.PointList;
import openperipheral.addons.glasses.utils.RenderState;
import org.lwjgl.opengl.GL11;

public class PointListBuilder
implements IPointListBuilder<Point2d> {
    private final List<Point2d> points = Lists.newArrayList();
    private final BoundingBoxBuilder bbBuilder = BoundingBoxBuilder.create();

    @Override
    public void add(Point2d point) {
        this.bbBuilder.addPoint(point.x, point.y);
        this.points.add(point);
    }

    private static Point2d toBoundingBox(Box2d bb, Point2d point) {
        return new Point2d(point.x - bb.left, point.y - bb.top);
    }

    @Override
    public PointList<Point2d> buildPointList() {
        Box2d bb = this.bbBuilder.build();
        ArrayList relPoints = Lists.newArrayList();
        for (Point2d p : this.points) {
            relPoints.add(PointListBuilder.toBoundingBox(bb, p));
        }
        return new PointListImpl(relPoints);
    }

    @Override
    public Box2d buildBoundingBox() {
        return this.bbBuilder.build();
    }

    private static class PointListImpl
    extends PointList<Point2d> {
        public PointListImpl(List<Point2d> points) {
            super(points);
        }

        @Override
        protected void drawPoint(RenderState renderState, Point2d p) {
            GL11.glVertex2f((float)p.x, (float)p.y);
        }
    }
}

