/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.utils;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import openperipheral.addons.glasses.utils.IPointList;
import openperipheral.addons.glasses.utils.RenderState;

public abstract class PointList<T>
implements IPointList<T> {
    private final List<T> points;

    public PointList(List<T> points) {
        this.points = ImmutableList.copyOf(points);
    }

    @Override
    public void drawAllPoints(RenderState renderState) {
        for (T p : this.points) {
            this.drawPoint(renderState, p);
        }
    }

    protected abstract void drawPoint(RenderState var1, T var2);

    @Override
    public void drawPoint(RenderState renderState, int index) {
        T p = this.points.get(index);
        this.drawPoint(renderState, p);
    }

    @Override
    public Iterator<T> iterator() {
        return this.points.iterator();
    }

    @Override
    public int size() {
        return this.points.size();
    }
}

