/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.drawable;

import com.google.common.base.Strings;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.FontRenderer;
import openmods.geometry.Box2d;
import openmods.structured.StructureField;
import openperipheral.addons.glasses.drawable.Drawable;
import openperipheral.addons.glasses.drawable.DrawableType;
import openperipheral.addons.glasses.utils.RenderState;
import openperipheral.api.adapter.AdapterSourceName;
import openperipheral.api.adapter.Property;
import openperipheral.api.adapter.method.ScriptObject;
import org.lwjgl.opengl.GL11;

@ScriptObject
@AdapterSourceName(value="glasses_text")
public class Text
extends Drawable {
    @Property
    @StructureField
    public float x;
    @Property
    @StructureField
    public float y;
    @Property
    @StructureField
    public String text;
    @Property
    @StructureField
    public int color;
    @Property
    @StructureField
    public float alpha = 1.0f;
    @Property
    @StructureField
    public float scale = 1.0f;

    Text() {
    }

    public Text(float x, float y, String text, int color) {
        this.x = x;
        this.y = y;
        this.text = text;
        this.color = color;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawContents(RenderState renderState, float partialTicks) {
        renderState.setupTexturedRender();
        renderState.setColor(this.color, this.alpha);
        FontRenderer fontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        fontRenderer.func_78276_b(this.text, 0, 0, (int)(this.alpha * 255.0f) << 24 | this.color);
    }

    @Override
    public DrawableType getTypeEnum() {
        return DrawableType.TEXT;
    }

    @Override
    public boolean isVisible() {
        return this.alpha > 0.0f;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.updateBoundingBox();
    }

    private void updateBoundingBox() {
        int width;
        int height = Math.round(8.0f * this.scale);
        if (Strings.isNullOrEmpty((String)this.text)) {
            width = 0;
        } else {
            FontRenderer fontRenderer = FMLClientHandler.instance().getClient().field_71466_p;
            width = Math.round((float)fontRenderer.func_78256_a(this.text) * this.scale);
        }
        this.setBoundingBox(Box2d.fromOriginAndSize((float)this.x, (float)this.y, (float)width, (float)height));
    }
}

