/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.drawable;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import openmods.structured.StructureField;
import openperipheral.addons.glasses.drawable.BoundedShape;
import openperipheral.addons.glasses.utils.IPointListBuilder;
import openperipheral.addons.glasses.utils.RenderState;
import openperipheral.api.adapter.IndexedProperty;
import openperipheral.api.adapter.Property;
import org.lwjgl.opengl.GL11;

public abstract class LineStrip<P>
extends BoundedShape<P> {
    @Property
    @IndexedProperty(expandable=true, nullable=true)
    @StructureField
    public List<P> points = Lists.newArrayList();
    @Property
    @StructureField
    public float width = 1.0f;

    public LineStrip(P ... points) {
        this.points.addAll(Arrays.asList(points));
    }

    @Override
    protected void drawContents(RenderState renderState, float partialTicks) {
        if (this.points != null) {
            super.drawContents(renderState, partialTicks);
            renderState.setLineWidth(this.width);
            GL11.glBegin((int)3);
            this.pointList.drawAllPoints(renderState);
            GL11.glEnd();
        }
    }

    @Override
    protected boolean isVisible() {
        return this.pointList.size() > 1;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.width <= 0.0f) {
            this.width = 1.0f;
        }
    }

    @Override
    protected void addPoints(IPointListBuilder<P> builder) {
        for (P p : this.points) {
            if (p == null) continue;
            builder.add(p);
        }
    }
}

