/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import openperipheral.addons.glasses.NbtGuidProviders;
import openperipheral.addons.glasses.TerminalUtils;
import openperipheral.api.meta.IItemStackCustomMetaProvider;

public class NbtTerminalMetaProvider
implements IItemStackCustomMetaProvider<Item> {
    @Override
    public Class<? extends Item> getTargetClass() {
        return Item.class;
    }

    @Override
    public String getKey() {
        return "op_terminal_embedded";
    }

    @Override
    public boolean canApply(Item target, ItemStack stack) {
        return NbtGuidProviders.hasTerminalCapabilities(stack);
    }

    @Override
    public Object getMeta(Item target, ItemStack stack) {
        HashMap results = Maps.newHashMap();
        Optional<Long> terminalGuid = NbtGuidProviders.getTerminalGuid(stack);
        if (terminalGuid.isPresent()) {
            results.put("bridge_name", TerminalUtils.formatTerminalId((Long)terminalGuid.get()));
        }
        return results;
    }
}

