/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.base.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import openmods.utils.ItemUtils;
import openperipheral.addons.glasses.TerminalIdAccess;

public class NbtGuidProviders {
    private static final String MAIN_TAG = "OPA-Terminal";
    private static final String GUID_TAG = "Guid";

    public static NBTTagCompound getOrCreateTerminalTag(ItemStack stack) {
        NBTTagCompound itemTag = ItemUtils.getItemTag((ItemStack)stack);
        if (!itemTag.func_150297_b(MAIN_TAG, 10)) {
            NBTTagCompound result = new NBTTagCompound();
            itemTag.func_74782_a(MAIN_TAG, (NBTBase)result);
            return result;
        }
        return itemTag.func_74775_l(MAIN_TAG);
    }

    public static boolean hasTerminalCapabilities(ItemStack stack) {
        NBTTagCompound itemTag = stack.func_77978_p();
        if (itemTag == null) {
            return false;
        }
        return itemTag.func_150297_b(MAIN_TAG, 10);
    }

    public static Optional<Long> getTerminalGuid(ItemStack stack) {
        NBTTagCompound terminalTag;
        NBTTagCompound itemTag = stack.func_77978_p();
        if (itemTag != null && itemTag.func_150297_b(MAIN_TAG, 10) && (terminalTag = itemTag.func_74775_l(MAIN_TAG)).func_150297_b(GUID_TAG, 99)) {
            return Optional.of((Object)terminalTag.func_74763_f(GUID_TAG));
        }
        return Optional.absent();
    }

    public static void setTerminalGuid(ItemStack stack, Optional<Long> guid) {
        NBTTagCompound terminalTag = NbtGuidProviders.getOrCreateTerminalTag(stack);
        if (guid.isPresent()) {
            terminalTag.func_74772_a(GUID_TAG, ((Long)guid.get()).longValue());
        }
    }

    public static class NbtSetter
    extends TerminalIdAccess.HandSetterAdapter {
        @Override
        public boolean setFor(ItemStack stack, long guid) {
            NBTTagCompound itemTag = stack.func_77978_p();
            if (itemTag != null && itemTag.func_150297_b(NbtGuidProviders.MAIN_TAG, 10)) {
                NBTTagCompound terminalTag = itemTag.func_74775_l(NbtGuidProviders.MAIN_TAG);
                terminalTag.func_74772_a(NbtGuidProviders.GUID_TAG, guid);
                return true;
            }
            return false;
        }
    }

    public static class NbtGetter
    extends TerminalIdAccess.HelmetGetterAdapter {
        @Override
        public Optional<Long> getFor(ItemStack stack) {
            return NbtGuidProviders.getTerminalGuid(stack);
        }
    }
}

