/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import openperipheral.addons.Config;
import openperipheral.addons.glasses.GlassesEvent;
import openperipheral.addons.utils.GuiUtils;
import openperipheral.api.adapter.AdapterSourceName;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.Optionals;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.adapter.method.ScriptObject;

@ScriptObject
@Asynchronous
@AdapterSourceName(value="glasses_capture")
public class GuiCaptureControl {
    private final long guid;
    private final WeakReference<EntityPlayerMP> player;

    public GuiCaptureControl(long guid, WeakReference<EntityPlayerMP> player) {
        this.guid = guid;
        this.player = player;
    }

    protected EntityPlayer getPlayer() {
        EntityPlayer player = (EntityPlayer)this.player.get();
        if (player == null) {
            throw new IllegalStateException("Object is no longer valid");
        }
        return player;
    }

    @ScriptCallable(description="Stops capture for player")
    public void stopCapturing() {
        EntityPlayer player = this.getPlayer();
        new GlassesEvent.GlassesStopCaptureEvent(this.guid).sendToPlayer(player);
    }

    @ScriptCallable(description="Set background on capture mode screen")
    public void setBackground(@Arg(name="background") int background, @Optionals @Arg(name="alpha") Integer alpha) {
        EntityPlayer player = this.getPlayer();
        int a = alpha != null ? alpha << 24 : 0x2A000000;
        new GlassesEvent.GlassesChangeBackgroundEvent(this.guid, background & 0xFFFFFF | a).sendToPlayer(player);
    }

    @ScriptCallable(description="When enabled, holding key down for long time will generate multiple events")
    public void setKeyRepeat(@Arg(name="isEnabled") boolean keyRepeat) {
        EntityPlayer player = this.getPlayer();
        new GlassesEvent.GlassesSetKeyRepeatEvent(this.guid, keyRepeat).sendToPlayer(player);
    }

    @ScriptCallable(description="Set minimal distance and minimum period needed for ")
    public void setDragParameters(@Arg(name="distance") int threshold, @Arg(name="delay") int period) {
        Preconditions.checkArgument((threshold >= Config.minimalDragThreshold ? 1 : 0) != 0, (String)"Distance must be not less than %s", (Object[])new Object[]{Config.minimalDragThreshold});
        Preconditions.checkArgument((period >= Config.minimalDragPeriod ? 1 : 0) != 0, (String)"Update period must be not less than %s", (Object[])new Object[]{Config.minimalDragPeriod});
        EntityPlayer player = this.getPlayer();
        new GlassesEvent.GlassesSetDragParamsEvent(this.guid, period, threshold).sendToPlayer(player);
    }

    @ScriptCallable(description="Sets visiblity state of various vanilla GUI elements")
    public void toggleGuiElements(@Arg(name="visibility") Map<GuiUtils.GuiElements, Boolean> visiblity) {
        EntityPlayer player = this.getPlayer();
        new GlassesEvent.GlassesSetGuiVisibilityEvent(this.guid, visiblity).sendToPlayer(player);
    }
}

