/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.property;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import openperipheral.adapter.property.SingleTypeInfo;
import openperipheral.adapter.types.SingleArgType;
import openperipheral.adapter.types.classifier.TypeClassifier;
import openperipheral.api.adapter.IScriptType;
import openperipheral.api.property.ISingleCustomProperty;
import openperipheral.api.property.ISingleTypedCustomProperty;
import openperipheral.api.property.PropertyValueDocType;

public class SingleTypeInfoBuilder {
    private static final TypeToken<?> CUSTOM_PROPERTY_TYPE = TypeToken.of(ISingleCustomProperty.class);
    private static final TypeVariable<?> CUSTOM_PROPERTY_VALUE_TYPE;
    private static final TypeToken<?> CUSTOM_TYPED_PROPERTY_TYPE;
    private static final TypeVariable<?> CUSTOM_TYPED_PROPERTY_VALUE_TYPE;
    private static final ITypeProvider DELEGATING_TYPE_PROVIDER;
    private final TypeToken<?> fieldType;
    private Type overridenValueType;
    private IScriptType overridenValueDocType;
    private ITypesProvider typesProvider;

    private static ITypeProvider createConstantTypeProvider(final Type type) {
        return new ITypeProvider(){

            @Override
            public Type getType(Object target) {
                return type;
            }
        };
    }

    public SingleTypeInfoBuilder(Type fieldType) {
        this.fieldType = TypeToken.of((Type)fieldType);
    }

    public void overrideValueType(Class<?> type) {
        this.overridenValueType = type;
    }

    public void overrideValueDocType(IScriptType type) {
        this.overridenValueDocType = type;
    }

    private static ITypesProvider createTypesProvider(TypeToken<?> fieldType) {
        if (CUSTOM_PROPERTY_TYPE.isAssignableFrom(fieldType)) {
            if (CUSTOM_TYPED_PROPERTY_TYPE.isAssignableFrom(fieldType)) {
                return new CustomTypedPropertyTypesProvider(fieldType);
            }
            return new CustomPropertyTypesProvider(fieldType);
        }
        return new DefaultPropertyTypesProvider(fieldType.getType());
    }

    private ITypesProvider getTypesProvider() {
        if (this.typesProvider == null) {
            this.typesProvider = SingleTypeInfoBuilder.createTypesProvider(this.fieldType);
        }
        return this.typesProvider;
    }

    private static SingleTypeInfo createTypeInfo(final ITypeProvider valueTypeProvider, IScriptType valueDocType) {
        Preconditions.checkNotNull((Object)valueTypeProvider, (Object)"Failed to deduce value type");
        Preconditions.checkNotNull((Object)valueDocType, (Object)"Failed to deduce value doc type");
        return new SingleTypeInfo(valueDocType){

            @Override
            public Type getValueType(Object target) {
                return valueTypeProvider.getType(target);
            }
        };
    }

    public SingleTypeInfo build() {
        ITypeProvider valueTypeProvider = this.overridenValueType == null ? this.getTypesProvider().getValueType() : SingleTypeInfoBuilder.createConstantTypeProvider(this.overridenValueType);
        IScriptType valueDocType = this.overridenValueDocType == null ? (this.overridenValueType == null ? this.getTypesProvider().getValueDocType() : TypeClassifier.INSTANCE.classifyType(this.overridenValueType)) : this.overridenValueDocType;
        return SingleTypeInfoBuilder.createTypeInfo(valueTypeProvider, valueDocType);
    }

    static {
        CUSTOM_TYPED_PROPERTY_TYPE = TypeToken.of(ISingleTypedCustomProperty.class);
        TypeVariable<Class<T>>[] vars = ISingleCustomProperty.class.getTypeParameters();
        CUSTOM_PROPERTY_VALUE_TYPE = vars[0];
        vars = ISingleTypedCustomProperty.class.getTypeParameters();
        CUSTOM_TYPED_PROPERTY_VALUE_TYPE = vars[0];
        DELEGATING_TYPE_PROVIDER = new ITypeProvider(){

            @Override
            public Type getType(Object target) {
                return ((ISingleTypedCustomProperty)target).getType();
            }
        };
    }

    private static class DefaultPropertyTypesProvider
    implements ITypesProvider {
        private final Type fieldType;

        public DefaultPropertyTypesProvider(Type fieldType) {
            this.fieldType = fieldType;
        }

        @Override
        public ITypeProvider getValueType() {
            return SingleTypeInfoBuilder.createConstantTypeProvider(this.fieldType);
        }

        @Override
        public IScriptType getValueDocType() {
            return TypeClassifier.INSTANCE.classifyType(this.fieldType);
        }
    }

    private static class CustomTypedPropertyTypesProvider
    extends CustomPropertyProviderBase {
        public CustomTypedPropertyTypesProvider(TypeToken<?> fieldType) {
            super(fieldType, CUSTOM_TYPED_PROPERTY_VALUE_TYPE);
        }

        @Override
        public ITypeProvider getValueType() {
            return DELEGATING_TYPE_PROVIDER;
        }
    }

    private static class CustomPropertyTypesProvider
    extends CustomPropertyProviderBase {
        public CustomPropertyTypesProvider(TypeToken<?> fieldType) {
            super(fieldType, CUSTOM_PROPERTY_VALUE_TYPE);
        }

        @Override
        public ITypeProvider getValueType() {
            return SingleTypeInfoBuilder.createConstantTypeProvider(this.valueType);
        }
    }

    private static abstract class CustomPropertyProviderBase
    implements ITypesProvider {
        private final Class<?> fieldType;
        protected final Type valueType;

        public CustomPropertyProviderBase(TypeToken<?> fieldType, TypeVariable<?> var) {
            this.fieldType = fieldType.getRawType();
            this.valueType = fieldType.resolveType(var).getType();
        }

        @Override
        public IScriptType getValueDocType() {
            PropertyValueDocType customValueDoc = this.fieldType.getAnnotation(PropertyValueDocType.class);
            return customValueDoc == null ? TypeClassifier.INSTANCE.classifyType(this.valueType) : SingleArgType.valueOf(customValueDoc.value());
        }
    }

    private static interface ITypesProvider {
        public ITypeProvider getValueType();

        public IScriptType getValueDocType();
    }

    private static interface ITypeProvider {
        public Type getType(Object var1);
    }
}

