/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.property;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import openperipheral.adapter.property.IIndexedFieldManipulator;
import openperipheral.adapter.property.IIndexedPropertyAccessHandler;
import openperipheral.adapter.property.IPropertyExecutor;
import openperipheral.adapter.property.IndexedTypeInfo;
import openperipheral.adapter.property.PropertyUtils;
import openperipheral.api.converter.IConverter;
import org.apache.commons.lang3.ArrayUtils;

public class IndexedGetterExecutor
implements IPropertyExecutor {
    private final Field field;
    private final IIndexedFieldManipulator manipulator;
    private final IndexedTypeInfo typeInfo;
    private final IIndexedPropertyAccessHandler accessHandler;

    public IndexedGetterExecutor(Field field, IIndexedFieldManipulator manipulator, IndexedTypeInfo typeInfo, IIndexedPropertyAccessHandler accessHandler) {
        this.field = field;
        this.manipulator = manipulator;
        this.typeInfo = typeInfo;
        this.accessHandler = accessHandler;
    }

    @Override
    public Object[] call(IConverter converter, Object owner, Object ... args) {
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)"Getter should have exactly one argument (index)");
        Object index = converter.toJava(args[0], this.typeInfo.keyType);
        Preconditions.checkArgument((index != null ? 1 : 0) != 0, (Object)"Invalid index");
        Object target = PropertyUtils.getContents(owner, this.field);
        this.accessHandler.onGet(owner, target, this.field, index);
        Object result = this.manipulator.getField(owner, target, this.field, index);
        Object converted = converter.fromJava(result);
        return ArrayUtils.toArray((Object[])new Object[]{converted});
    }
}

