/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import openmods.Log;
import openperipheral.adapter.wrappers.AdapterWrapper;
import openperipheral.adapter.wrappers.ExternalAdapterWrapper;
import openperipheral.api.adapter.IAdapter;
import openperipheral.api.adapter.IAdapterWithConstraints;

public class AdapterRegistry {
    public static final AdapterRegistry PERIPHERAL_ADAPTERS = new AdapterRegistry();
    public static final AdapterRegistry OBJECT_ADAPTERS = new AdapterRegistry();
    private final Multimap<Class<?>, AdapterWrapper> externalAdapters = HashMultimap.create();

    public Map<Class<?>, Collection<AdapterWrapper>> listExternalAdapters() {
        return Collections.unmodifiableMap(this.externalAdapters.asMap());
    }

    public boolean addAdapter(IAdapter adapter) {
        AdapterWrapper wrapper;
        try {
            wrapper = this.wrapExternalAdapter(adapter);
        }
        catch (Throwable e) {
            Log.warn((Throwable)e, (String)"Something went terribly wrong while adding internal adapter '%s'. It will be disabled", (Object[])new Object[]{adapter.getClass()});
            return false;
        }
        Class<?> targetCls = adapter.getTargetClass();
        Preconditions.checkArgument((!Object.class.equals(targetCls) ? 1 : 0) != 0, (Object)"Can't add adapter for Object class");
        Log.trace((String)"Registering %s adapter (source id: %s) for %s", (Object[])new Object[]{wrapper.describe(), wrapper.source(), targetCls});
        this.externalAdapters.put(targetCls, (Object)wrapper);
        return true;
    }

    public Collection<AdapterWrapper> getExternalAdapters(Class<?> targetCls) {
        return Collections.unmodifiableCollection(this.externalAdapters.get(targetCls));
    }

    protected AdapterWrapper wrapExternalAdapter(IAdapter adapter) {
        return adapter instanceof IAdapterWithConstraints ? new ExternalAdapterWrapper.WithConstraints((IAdapterWithConstraints)adapter) : new ExternalAdapterWrapper(adapter);
    }
}

