/*
 * Decompiled with CFR 0.152.
 */
package openperipheral;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import openmods.Log;
import openmods.config.properties.ConfigProcessing;
import openperipheral.ApiSetup;
import openperipheral.CommandDump;
import openperipheral.Config;
import openperipheral.adapter.PeripheralTypeProvider;
import openperipheral.adapter.TileEntityBlacklist;
import openperipheral.adapter.types.classifier.MinecraftTypeClassifier;
import openperipheral.adapter.types.classifier.TypeClassifier;
import openperipheral.api.peripheral.IOpenPeripheral;
import openperipheral.interfaces.cc.ModuleComputerCraft;
import openperipheral.interfaces.oc.ModuleOpenComputers;

@Mod(modid="OpenPeripheralCore", name="OpenPeripheralCore", version="1.3", dependencies="required-after:OpenMods@[0.9.1,0.10);after:ComputerCraft@[1.70,];after:OpenComputers@[1.5.0,];", acceptableRemoteVersions="*")
public class OpenPeripheralCore {
    private final ApiSetup apiSetup = new ApiSetup();

    @Mod.EventHandler
    public void construct(FMLConstructionEvent evt) {
        this.apiSetup.setupApis();
        this.apiSetup.installProviderAccess();
        if (Loader.isModLoaded((String)"OpenComputers")) {
            ModuleOpenComputers.init();
        }
        if (Loader.isModLoaded((String)"ComputerCraft")) {
            ModuleComputerCraft.init();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        this.apiSetup.installHolderAccess(evt.getAsmData());
        PeripheralTypeProvider.INSTANCE.initialize(evt.getModConfigurationDirectory());
        File configFile = evt.getSuggestedConfigurationFile();
        Configuration config = new Configuration(configFile);
        ConfigProcessing.processAnnotations((String)"OpenPeripheralCore", (Configuration)config, Config.class);
        if (config.hasChanged()) {
            config.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)TileEntityBlacklist.INSTANCE);
        FMLInterModComms.sendMessage((String)"OpenComputers", (String)"blacklistPeripheral", (String)IOpenPeripheral.class.getName());
        TypeClassifier.INSTANCE.registerClassifier(new MinecraftTypeClassifier());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        if (Loader.isModLoaded((String)"OpenComputers")) {
            ModuleOpenComputers.registerProvider();
        }
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent evt) {
        if (Loader.isModLoaded((String)"ComputerCraft")) {
            ModuleComputerCraft.registerProvider();
        }
    }

    @Mod.EventHandler
    public void processMessage(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            if (!m.isStringMessage()) continue;
            if ("ignoreTileEntity".equalsIgnoreCase(m.key)) {
                TileEntityBlacklist.INSTANCE.addToBlacklist(m.getStringValue());
                continue;
            }
            if (!"registerClassType".equalsIgnoreCase(m.key)) continue;
            String value = m.getStringValue();
            String[] fields = value.split("\\s+");
            if (fields.length != 2) {
                Log.warn((String)"Invalid IMC from %s: can't decode type '%s'", (Object[])new Object[]{m.getSender(), value});
                continue;
            }
            PeripheralTypeProvider.INSTANCE.setType(fields[0], fields[1]);
        }
    }

    @Mod.EventHandler
    public void severStart(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new CommandDump("op_dump", evt.getServer().func_71262_S()));
    }
}

