/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import fi.dy.masa.enderutilities.util.ItemType;
import fi.dy.masa.enderutilities.util.SlotRange;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class InventoryUtils {
    public static boolean tryMoveAllItemsWithinSlotRange(IInventory invSrc, IInventory invDst, int sideSrc, int sideDst, int slotMinSrc, int slotMaxSrc, int slotMinDst, int slotMaxDst) {
        return InventoryUtils.tryMoveAllItemsWithinSlotRange(invSrc, invDst, sideSrc, sideDst, slotMinSrc, slotMaxSrc, slotMinDst, slotMaxDst, false);
    }

    public static boolean tryMoveAllItemsWithinSlotRange(IInventory invSrc, IInventory invDst, int sideSrc, int sideDst, int slotMinSrc, int slotMaxSrc, int slotMinDst, int slotMaxDst, boolean ignoreStackLimit) {
        boolean movedAll = true;
        if (invSrc instanceof ISidedInventory) {
            int[] slotsSrc;
            ISidedInventory sidedSrc = (ISidedInventory)invSrc;
            for (int slotNum : slotsSrc = sidedSrc.func_94128_d(sideSrc)) {
                ItemStack stack;
                if (slotNum < slotMinSrc || slotNum > slotMaxSrc || (stack = invSrc.func_70301_a(slotNum)) == null || !sidedSrc.func_102008_b(slotNum, stack, sideSrc)) continue;
                stack = InventoryUtils.tryInsertItemStackToInventoryWithinSlotRange(invDst, stack, sideDst, slotMinDst, slotMaxDst, ignoreStackLimit);
                invSrc.func_70299_a(slotNum, stack);
                if (stack == null) continue;
                movedAll = false;
            }
        } else {
            int max = Math.min(slotMaxSrc, invSrc.func_70302_i_() - 1);
            for (int slotNum = slotMinSrc; slotNum <= max; ++slotNum) {
                ItemStack stack = invSrc.func_70301_a(slotNum);
                if (stack == null) continue;
                stack = InventoryUtils.tryInsertItemStackToInventoryWithinSlotRange(invDst, stack, sideDst, slotMinDst, slotMaxDst, ignoreStackLimit);
                invSrc.func_70299_a(slotNum, stack);
                if (stack == null) continue;
                movedAll = false;
            }
        }
        return movedAll;
    }

    public static boolean tryMoveAllItems(IInventory invSrc, IInventory invDst, int sideSrc, int sideDst) {
        return InventoryUtils.tryMoveAllItems(invSrc, invDst, sideSrc, sideDst, false);
    }

    public static boolean tryMoveAllItems(IInventory invSrc, IInventory invDst, int sideSrc, int sideDst, boolean ignoreStackLimit) {
        return InventoryUtils.tryMoveAllItemsWithinSlotRange(invSrc, invDst, sideSrc, sideDst, 0, invSrc.func_70302_i_() - 1, 0, invDst.func_70302_i_() - 1, ignoreStackLimit);
    }

    public static boolean tryMoveMatchingItems(IInventory invSrc, IInventory invDst, int sideSrc, int sideDst, boolean ignoreStackLimit) {
        return InventoryUtils.tryMoveMatchingItemsWithinSlotRange(invSrc, invDst, sideSrc, sideDst, 0, invSrc.func_70302_i_() - 1, 0, invDst.func_70302_i_() - 1, ignoreStackLimit);
    }

    public static boolean tryMoveMatchingItemsWithinSlotRange(IInventory invSrc, IInventory invDst, int sideSrc, int sideDst, int slotMinSrc, int slotMaxSrc, int slotMinDst, int slotMaxDst) {
        return InventoryUtils.tryMoveMatchingItemsWithinSlotRange(invSrc, invDst, sideSrc, sideDst, slotMinSrc, slotMaxSrc, slotMinDst, slotMaxDst, false);
    }

    public static boolean tryMoveMatchingItemsWithinSlotRange(IInventory invSrc, IInventory invDst, int sideSrc, int sideDst, int slotMinSrc, int slotMaxSrc, int slotMinDst, int slotMaxDst, boolean ignoreStackLimit) {
        boolean movedAll = true;
        if (invSrc instanceof ISidedInventory) {
            int[] slotsSrc;
            ISidedInventory sidedSrc = (ISidedInventory)invSrc;
            for (int slotNum : slotsSrc = sidedSrc.func_94128_d(sideSrc)) {
                ItemStack stack;
                if (slotNum < slotMinSrc || slotNum > slotMaxSrc || (stack = invSrc.func_70301_a(slotNum)) == null || !sidedSrc.func_102008_b(slotNum, stack, sideSrc)) continue;
                if (InventoryUtils.getSlotOfFirstMatchingItemStackWithinSlotRange(invDst, stack, slotMinDst, slotMaxDst) != -1) {
                    stack = InventoryUtils.tryInsertItemStackToInventoryWithinSlotRange(invDst, stack, sideDst, slotMinDst, slotMaxDst, ignoreStackLimit);
                    invSrc.func_70299_a(slotNum, stack);
                }
                if (stack == null) continue;
                movedAll = false;
            }
        } else {
            int max = Math.min(slotMaxSrc, invSrc.func_70302_i_() - 1);
            for (int slotNum = slotMinSrc; slotNum <= max; ++slotNum) {
                ItemStack stack = invSrc.func_70301_a(slotNum);
                if (stack == null) continue;
                if (InventoryUtils.getSlotOfFirstMatchingItemStackWithinSlotRange(invDst, stack, slotMinDst, slotMaxDst) != -1) {
                    stack = InventoryUtils.tryInsertItemStackToInventoryWithinSlotRange(invDst, stack, sideDst, slotMinDst, slotMaxDst, ignoreStackLimit);
                    invSrc.func_70299_a(slotNum, stack);
                }
                if (stack == null) continue;
                movedAll = false;
            }
        }
        return movedAll;
    }

    public static void fillStacksOfMatchingItems(IInventory invSrc, IInventory invDst) {
        InventoryUtils.fillStacksOfMatchingItemsWithinSlotRange(invSrc, invDst, 0, 0, 0, invSrc.func_70302_i_() - 1, 0, invDst.func_70302_i_() - 1, false);
    }

    public static void fillStacksOfMatchingItemsWithinSlotRange(IInventory invSrc, IInventory invDst, int sideSrc, int sideDst, int slotMinSrc, int slotMaxSrc, int slotMinDst, int slotMaxDst, boolean ignoreStackLimit) {
        if (invSrc instanceof ISidedInventory) {
            int[] slotsSrc;
            ISidedInventory sidedSrc = (ISidedInventory)invSrc;
            for (int i : slotsSrc = sidedSrc.func_94128_d(sideSrc)) {
                ItemStack stack;
                if (i < slotMinSrc || i > slotMaxSrc || (stack = invSrc.func_70301_a(i)) == null || !sidedSrc.func_102008_b(i, stack, sideSrc)) continue;
                List<Integer> matchingSlots = InventoryUtils.getSlotNumbersOfMatchingItemStacksWithinSlotRange(invDst, stack, slotMinDst, slotMaxDst);
                for (int dstSlot : matchingSlots) {
                    if (dstSlot < slotMinDst || dstSlot > slotMaxDst) continue;
                    stack = InventoryUtils.tryInsertItemStackToSlot(invDst, stack, dstSlot, sideDst, ignoreStackLimit);
                    invSrc.func_70299_a(i, stack);
                }
            }
        } else {
            int max = Math.min(slotMaxSrc, invSrc.func_70302_i_() - 1);
            for (int i = slotMinSrc; i <= max; ++i) {
                ItemStack stack = invSrc.func_70301_a(i);
                if (stack == null) continue;
                List<Integer> matchingSlots = InventoryUtils.getSlotNumbersOfMatchingItemStacksWithinSlotRange(invDst, stack, slotMinDst, slotMaxDst);
                for (int dstSlot : matchingSlots) {
                    if (dstSlot < slotMinDst || dstSlot > slotMaxDst) continue;
                    stack = InventoryUtils.tryInsertItemStackToSlot(invDst, stack, dstSlot, ignoreStackLimit);
                    invSrc.func_70299_a(i, stack);
                }
            }
        }
    }

    public static ItemStack tryInsertItemStackToInventoryWithinSlotRange(IInventory inv, ItemStack stackIn, int side, int slotMin, int slotMax) {
        return InventoryUtils.tryInsertItemStackToInventoryWithinSlotRange(inv, stackIn, side, slotMin, slotMax, false);
    }

    public static ItemStack tryInsertItemStackToInventoryWithinSlotRange(IInventory inv, ItemStack stackIn, int side, int slotMin, int slotMax, boolean ignoreStackLimit) {
        if (inv instanceof ISidedInventory) {
            int[] slots;
            ISidedInventory sided = (ISidedInventory)inv;
            for (int i : slots = sided.func_94128_d(side)) {
                if (i < slotMin || i > slotMax || sided.func_70301_a(i) == null || (stackIn = InventoryUtils.tryInsertItemStackToSlot(inv, stackIn, i, side, ignoreStackLimit)) != null) continue;
                return null;
            }
            for (int i : slots) {
                if (i < slotMin || i > slotMax || (stackIn = InventoryUtils.tryInsertItemStackToSlot(inv, stackIn, i, side, ignoreStackLimit)) != null) continue;
                return null;
            }
        } else {
            int i;
            int max = Math.min(slotMax, inv.func_70302_i_() - 1);
            for (i = slotMin; i <= max; ++i) {
                if (inv.func_70301_a(i) == null || (stackIn = InventoryUtils.tryInsertItemStackToSlot(inv, stackIn, i, ignoreStackLimit)) != null) continue;
                return null;
            }
            for (i = slotMin; i <= max; ++i) {
                if ((stackIn = InventoryUtils.tryInsertItemStackToSlot(inv, stackIn, i, ignoreStackLimit)) != null) continue;
                return null;
            }
        }
        return stackIn;
    }

    public static ItemStack tryInsertItemStackToInventory(IInventory inv, ItemStack stackIn, int side) {
        return InventoryUtils.tryInsertItemStackToInventoryWithinSlotRange(inv, stackIn, side, 0, inv.func_70302_i_() - 1);
    }

    public static ItemStack tryInsertItemStackToInventory(IInventory inv, ItemStack stackIn, int side, boolean ignoreStackLimit) {
        return InventoryUtils.tryInsertItemStackToInventoryWithinSlotRange(inv, stackIn, side, 0, inv.func_70302_i_() - 1, ignoreStackLimit);
    }

    public static ItemStack tryInsertItemStackToExistingStacksInInventory(IInventory inv, ItemStack stackIn, int side, boolean ignoreStackLimit) {
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingItemStacks(inv, stackIn);
        for (int slot : slots) {
            if ((stackIn = InventoryUtils.tryInsertItemStackToSlot(inv, stackIn, slot, side, ignoreStackLimit)) != null) continue;
            return null;
        }
        return stackIn;
    }

    public static ItemStack tryInsertItemStackToSlot(IInventory inv, ItemStack stackIn, int slotNum) {
        return InventoryUtils.tryInsertItemStackToSlot(inv, stackIn, slotNum, false);
    }

    public static ItemStack tryInsertItemStackToSlot(IInventory inv, ItemStack stackIn, int slotNum, boolean ignoreStackLimit) {
        return InventoryUtils.tryInsertItemStackToSlot(inv, stackIn, slotNum, 0, ignoreStackLimit);
    }

    public static ItemStack tryInsertItemStackToSlot(IInventory inv, ItemStack stackIn, int slotNum, int side, boolean ignoreStackLimit) {
        int num;
        if (inv instanceof ISidedInventory ? !InventoryUtils.isItemStackValidForSlot((ISidedInventory)inv, stackIn, slotNum, side) : !InventoryUtils.isItemStackValidForSlot(inv, stackIn, slotNum)) {
            return stackIn;
        }
        ItemStack targetStack = inv.func_70301_a(slotNum);
        int max = inv.func_70297_j_();
        if (!ignoreStackLimit) {
            max = Math.min(max, stackIn.func_77976_d());
        }
        if (targetStack == null) {
            if (max > 0 && max < stackIn.field_77994_a) {
                ItemStack stackTmp = stackIn.func_77946_l();
                stackTmp.field_77994_a = max;
                stackIn.field_77994_a -= max;
                inv.func_70299_a(slotNum, stackTmp);
                return stackIn;
            }
            if (max >= stackIn.field_77994_a) {
                inv.func_70299_a(slotNum, stackIn.func_77946_l());
                return null;
            }
        } else if (stackIn.func_77969_a(targetStack) && ItemStack.func_77970_a((ItemStack)stackIn, (ItemStack)targetStack) && (num = Math.min(max - targetStack.field_77994_a, stackIn.field_77994_a)) > 0) {
            targetStack.field_77994_a += num;
            stackIn.field_77994_a -= num;
            inv.func_70299_a(slotNum, targetStack);
            return stackIn.field_77994_a > 0 ? stackIn : null;
        }
        return stackIn;
    }

    public static boolean isItemStackValidForSlot(ISidedInventory sided, ItemStack stackIn, int slotNum, int side) {
        return sided.func_94041_b(slotNum, stackIn) && sided.func_102007_a(slotNum, stackIn, side);
    }

    public static boolean isItemStackValidForSlot(IInventory inv, ItemStack stackIn, int slotNum) {
        return inv.func_94041_b(slotNum, stackIn);
    }

    public static boolean areItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return stack1 == stack2;
        }
        return stack1.func_77969_a(stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static int getFirstEmptySlot(IInventory inv) {
        return InventoryUtils.getSlotOfFirstMatchingItemStack(inv, null);
    }

    public static int getLastEmptySlot(IInventory inv) {
        return InventoryUtils.getSlotOfLastMatchingItemStack(inv, null);
    }

    public static int getSlotOfFirstMatchingItem(IInventory inv, Item item) {
        return InventoryUtils.getSlotOfFirstMatchingItem(inv, item, Short.MAX_VALUE);
    }

    public static int getSlotOfFirstMatchingItem(IInventory inv, Item item, int damage) {
        int size = inv.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item || stack.func_77960_j() != damage && damage != Short.MAX_VALUE) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack getFirstMatchingItem(IInventory inv, Item item) {
        int slot = InventoryUtils.getSlotOfFirstMatchingItem(inv, item);
        return slot != -1 ? inv.func_70301_a(slot) : null;
    }

    public static int getSlotOfLastMatchingItem(IInventory inv, Item item) {
        return InventoryUtils.getSlotOfLastMatchingItem(inv, item, Short.MAX_VALUE);
    }

    public static int getSlotOfLastMatchingItem(IInventory inv, Item item, int damage) {
        int size = inv.func_70302_i_();
        for (int i = size - 1; i >= 0; --i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item || stack.func_77960_j() != damage && damage != Short.MAX_VALUE) continue;
            return i;
        }
        return -1;
    }

    public static int getSlotOfFirstMatchingItemStack(IInventory inv, ItemStack stackIn) {
        return InventoryUtils.getSlotOfFirstMatchingItemStackWithinSlotRange(inv, stackIn, 0, inv.func_70302_i_() - 1);
    }

    public static int getSlotOfFirstMatchingItemStackWithinSlotRange(IInventory inv, ItemStack stackIn, int slotMin, int slotMax) {
        int max = Math.min(inv.func_70302_i_() - 1, slotMax);
        for (int i = slotMin; i <= max; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!InventoryUtils.areItemStacksEqual(stack, stackIn)) continue;
            return i;
        }
        return -1;
    }

    public static int getSlotOfLastMatchingItemStack(IInventory inv, ItemStack stackIn) {
        return InventoryUtils.getSlotOfLastMatchingItemStackWithinSlotRange(inv, stackIn, 0, inv.func_70302_i_() - 1);
    }

    public static int getSlotOfLastMatchingItemStackWithinSlotRange(IInventory inv, ItemStack stackIn, int slotMin, int slotMax) {
        int max;
        for (int i = max = Math.min(inv.func_70302_i_() - 1, slotMax); i >= slotMin; --i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!InventoryUtils.areItemStacksEqual(stack, stackIn)) continue;
            return i;
        }
        return -1;
    }

    public static List<Integer> getSlotNumbersOfMatchingItems(IInventory inv, Item item) {
        return InventoryUtils.getSlotNumbersOfMatchingItems(inv, item, Short.MAX_VALUE);
    }

    public static List<Integer> getSlotNumbersOfMatchingItems(IInventory inv, Item item, int damage) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int size = inv.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item || stack.func_77960_j() != damage && damage != Short.MAX_VALUE) continue;
            slots.add(i);
        }
        return slots;
    }

    public static List<Integer> getSlotNumbersOfMatchingItemStacks(IInventory inv, ItemStack stackIn) {
        return InventoryUtils.getSlotNumbersOfMatchingItemStacksWithinSlotRange(inv, stackIn, 0, inv.func_70302_i_() - 1);
    }

    public static List<Integer> getSlotNumbersOfMatchingItemStacksWithinSlotRange(IInventory inv, ItemStack stackIn, int slotMin, int slotMax) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        int max = Math.min(inv.func_70302_i_() - 1, slotMax);
        for (int i = slotMin; i <= max; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!InventoryUtils.areItemStacksEqual(stack, stackIn)) continue;
            slots.add(i);
        }
        return slots;
    }

    public static List<Integer> getSlotNumbersOfMatchingItemStacks(IInventory inv, ItemStack stackTemplate, boolean useOreDict) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || !InventoryUtils.areItemStacksEqual(stack, stackTemplate) && (!useOreDict || !InventoryUtils.areItemStacksOreDictMatch(stack, stackTemplate))) continue;
            slots.add(i);
        }
        return slots;
    }

    public static ItemStack getItemStackByUUID(IInventory inv, UUID uuid, String containerTagName) {
        int size = inv.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || !uuid.equals(NBTUtils.getUUIDFromItemStack(stack, containerTagName, false))) continue;
            return stack;
        }
        return null;
    }

    public static ItemStack collectItemsFromInventory(IInventory inv, ItemStack stackTemplate, int maxAmount, boolean reverse) {
        return InventoryUtils.collectItemsFromInventory(inv, stackTemplate, maxAmount, reverse, false);
    }

    public static ItemStack collectItemsFromInventory(IInventory inv, ItemStack stackTemplate, int maxAmount, boolean reverse, boolean useOreDict) {
        int start;
        ItemStack stack = stackTemplate.func_77946_l();
        stack.field_77994_a = 0;
        int inc = reverse ? -1 : 1;
        for (int i = start = reverse ? inv.func_70302_i_() - 1 : 0; i >= 0 && i < inv.func_70302_i_() && stack.field_77994_a < maxAmount; i += inc) {
            int num;
            ItemStack stackTmp = inv.func_70301_a(i);
            if (stackTmp == null) continue;
            if (InventoryUtils.areItemStacksEqual(stackTmp, stackTemplate)) {
                num = Math.min(maxAmount - stack.field_77994_a, stackTmp.field_77994_a);
                stack.field_77994_a += num;
                stackTmp.field_77994_a -= num;
                inv.func_70299_a(i, (ItemStack)(stackTmp.field_77994_a > 0 ? stackTmp : null));
                continue;
            }
            if (!useOreDict || !InventoryUtils.areItemStacksOreDictMatch(stackTmp, stackTemplate)) continue;
            num = Math.min(maxAmount - stack.field_77994_a, stackTmp.field_77994_a);
            if (stack.field_77994_a == 0) {
                stack = stackTmp.func_77946_l();
                stack.field_77994_a = num;
            } else {
                stack.field_77994_a += num;
            }
            stackTmp.field_77994_a -= num;
            inv.func_70299_a(i, (ItemStack)(stackTmp.field_77994_a > 0 ? stackTmp : null));
        }
        return stack.field_77994_a > 0 ? stack : null;
    }

    public static ItemStack collectOneStackAndMoveOthers(IInventory invTarget, IInventory invStorage, ItemStack stackTemplate, boolean ignoreStackLimitOnTarget, boolean ignoreStackLimitOnStorage) {
        ItemStack stackTmp;
        int maxStackSize = invTarget.func_70297_j_();
        if (!ignoreStackLimitOnTarget) {
            maxStackSize = Math.min(maxStackSize, stackTemplate.func_77976_d());
        }
        ItemStack stack = InventoryUtils.collectItemsFromInventory(invTarget, stackTemplate, maxStackSize, true);
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingItemStacks(invTarget, stack);
        for (int slot : slots) {
            ItemStack stackTmp2 = invTarget.func_70301_a(slot);
            stackTmp2 = InventoryUtils.tryInsertItemStackToInventory(invStorage, stackTmp2, 0, ignoreStackLimitOnStorage);
            invTarget.func_70299_a(slot, stackTmp2);
        }
        if (stack != null && stack.field_77994_a < maxStackSize && (stackTmp = InventoryUtils.collectItemsFromInventory(invStorage, stack, maxStackSize - stack.field_77994_a, true)) != null) {
            stack.field_77994_a += stackTmp.field_77994_a;
        }
        return stack;
    }

    public static void leaveOneFullStackOfEveryItem(IInventory invTarget, IInventory invStorage, boolean reverse, boolean ignoreStackLimitOnTarget, boolean ignoreStackLimitOnStorage) {
        int start;
        int inc = reverse ? -1 : 1;
        for (int i = start = reverse ? invTarget.func_70302_i_() - 1 : 0; i >= 0 && i < invTarget.func_70302_i_(); i += inc) {
            ItemStack stack = invTarget.func_70301_a(i);
            if (stack == null) continue;
            stack = InventoryUtils.collectOneStackAndMoveOthers(invTarget, invStorage, stack, ignoreStackLimitOnTarget, ignoreStackLimitOnStorage);
            invTarget.func_70299_a(i, stack);
        }
    }

    public static boolean matchingStackFoundInSlotRange(IInventory inv, SlotRange slotRange, ItemStack stackTemplate, boolean ignoreMeta, boolean ignoreNbt) {
        if (stackTemplate == null) {
            return false;
        }
        Item item = stackTemplate.func_77973_b();
        int meta = stackTemplate.func_77960_j();
        int end = Math.min(slotRange.lastExc, inv.func_70302_i_());
        for (int i = slotRange.first; i < end; ++i) {
            ItemStack stackTmp = inv.func_70301_a(i);
            if (stackTmp == null || stackTmp.func_77973_b() != item || !ignoreMeta && meta != Short.MAX_VALUE && stackTmp.func_77960_j() != meta || !ignoreNbt && !ItemStack.func_77970_a((ItemStack)stackTemplate, (ItemStack)stackTmp)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInventoryEmpty(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null) continue;
            return false;
        }
        return true;
    }

    public static int getLargestExistingStackSize(IInventory inv) {
        int largestSize = -1;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || stack.field_77994_a <= largestSize) continue;
            largestSize = stack.field_77994_a;
        }
        return largestSize;
    }

    public static int getMinNonEmptyStackSize(IInventory inv) {
        int minSize = -1;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || minSize >= 0 && stack.field_77994_a >= minSize) continue;
            minSize = stack.field_77994_a;
        }
        return minSize;
    }

    public static boolean areItemStacksOreDictMatch(ItemStack stackTarget, ItemStack stackReference) {
        int[] ids;
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stackReference)) {
            List oreStacks = OreDictionary.getOres((String)OreDictionary.getOreName((int)id), (boolean)false);
            for (ItemStack oreStack : oreStacks) {
                if (!OreDictionary.itemMatches((ItemStack)stackTarget, (ItemStack)oreStack, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    public static int getNumberOfMatchingItemsInInventory(IInventory inv, ItemStack stackTemplate, boolean useOreDict) {
        int found = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackTmp = inv.func_70301_a(i);
            if (stackTmp == null || !InventoryUtils.areItemStacksEqual(stackTmp, stackTemplate) && (!useOreDict || !InventoryUtils.areItemStacksOreDictMatch(stackTmp, stackTemplate))) continue;
            found += stackTmp.field_77994_a;
        }
        return found;
    }

    public static boolean checkInventoryHasItems(IInventory inv, ItemStack stackTemplate, int amount, boolean useOreDict) {
        int found = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackTmp = inv.func_70301_a(i);
            if (stackTmp != null && (InventoryUtils.areItemStacksEqual(stackTmp, stackTemplate) || useOreDict && InventoryUtils.areItemStacksOreDictMatch(stackTmp, stackTemplate))) {
                found += stackTmp.field_77994_a;
            }
            if (found < amount) continue;
            return true;
        }
        return false;
    }

    public static boolean checkInventoryHasAllItems(IInventory invStorage, IInventory invTemplate, int amountPerStack, boolean useOreDict) {
        Integer amount;
        HashMap<ItemType, Integer> quantities = new HashMap<ItemType, Integer>();
        for (int i = 0; i < invTemplate.func_70302_i_(); ++i) {
            ItemStack stackTmp = invTemplate.func_70301_a(i);
            if (stackTmp == null) continue;
            ItemType item = new ItemType(stackTmp);
            amount = (Integer)quantities.get(item);
            amount = amount != null ? amount + amountPerStack : amountPerStack;
            quantities.put(item, amount);
        }
        Set items = quantities.keySet();
        for (ItemType item : items) {
            amount = (Integer)quantities.get(item);
            if (amount == null || InventoryUtils.checkInventoryHasItems(invStorage, item.getStack(), amount, useOreDict)) continue;
            return false;
        }
        return true;
    }

    public static Map<ItemType, Integer> getSlotCountPerItem(IInventory inv) {
        HashMap<ItemType, Integer> slots = new HashMap<ItemType, Integer>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stackTmp = inv.func_70301_a(i);
            if (stackTmp == null) continue;
            ItemType item = new ItemType(stackTmp);
            Integer count = (Integer)slots.get(item);
            count = count != null ? count + 1 : 1;
            slots.put(item, (int)count);
        }
        return slots;
    }

    public static ItemStack[] createInventorySnapshot(IInventory inv) {
        ItemStack[] items = new ItemStack[inv.func_70302_i_()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = ItemStack.func_77944_b((ItemStack)inv.func_70301_a(i));
        }
        return items;
    }

    public static boolean restockInventoryBasedOnTemplate(IInventory invTarget, IInventory invStorage, ItemStack[] template, int amountPerStack, boolean emptySlotsOnly, boolean useOreDict) {
        int i = 0;
        int amount = 0;
        boolean allSuccess = true;
        for (i = 0; i < template.length && i < invTarget.func_70302_i_(); ++i) {
            if (template[i] == null) continue;
            ItemStack stackExisting = invTarget.func_70301_a(i);
            if (emptySlotsOnly && stackExisting != null) continue;
            amount = Math.min(invTarget.func_70297_j_(), template[i].func_77976_d());
            if (stackExisting != null) {
                if (!useOreDict && !InventoryUtils.areItemStacksEqual(stackExisting, template[i]) || useOreDict && !InventoryUtils.areItemStacksOreDictMatch(stackExisting, template[i])) {
                    allSuccess = false;
                    continue;
                }
                amount = Math.max(amount - stackExisting.field_77994_a, 0);
            }
            if ((amount = Math.min(amount, amountPerStack)) <= 0) {
                allSuccess = false;
                continue;
            }
            ItemStack stackNew = InventoryUtils.collectItemsFromInventory(invStorage, template[i], amount, false, useOreDict);
            if (stackNew == null) {
                allSuccess = false;
                continue;
            }
            if (stackNew.field_77994_a < amount) {
                allSuccess = false;
            }
            if (stackExisting != null) {
                stackNew.field_77994_a += stackExisting.field_77994_a;
            }
            invTarget.func_70299_a(i, stackNew);
        }
        return allSuccess;
    }
}

