/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPosEU {
    public final int posX;
    public final int posY;
    public final int posZ;
    public final int dimension;
    public final int face;

    public BlockPosEU(int x, int y, int z) {
        this(x, y, z, 0, 0);
    }

    public BlockPosEU(int x, int y, int z, int dim) {
        this(x, y, z, dim, 0);
    }

    public BlockPosEU(int x, int y, int z, int dim, int side) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.dimension = dim;
        this.face = side;
    }

    public BlockPosEU add(int x, int y, int z) {
        return new BlockPosEU(this.posX + x, this.posY + y, this.posZ + z, this.dimension, this.face);
    }

    public BlockPosEU offset(ForgeDirection dir, int distance) {
        return new BlockPosEU(this.posX + dir.offsetX * distance, this.posY + dir.offsetY * distance, this.posZ + dir.offsetZ * distance, this.dimension, this.face);
    }

    public BlockPosEU clampCoords() {
        int x = MathHelper.func_76125_a((int)this.posX, (int)-30000000, (int)30000000);
        int y = MathHelper.func_76125_a((int)this.posY, (int)0, (int)255);
        int z = MathHelper.func_76125_a((int)this.posZ, (int)-30000000, (int)30000000);
        return new BlockPosEU(x, y, z, this.dimension, this.face);
    }

    public NBTTagCompound writeToTag(NBTTagCompound tag) {
        tag.func_74768_a("posX", this.posX);
        tag.func_74768_a("posY", this.posY);
        tag.func_74768_a("posZ", this.posZ);
        tag.func_74768_a("dim", this.dimension);
        tag.func_74774_a("face", (byte)this.face);
        return tag;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74782_a("BlockPos", (NBTBase)this.writeToTag(new NBTTagCompound()));
        return nbt;
    }

    public static BlockPosEU readFromTag(NBTTagCompound tag) {
        if (!(tag != null && tag.func_150297_b("posX", 3) && tag.func_150297_b("posY", 3) && tag.func_150297_b("posZ", 3) && tag.func_150297_b("dim", 3) && tag.func_150297_b("face", 1))) {
            return null;
        }
        int x = tag.func_74762_e("posX");
        int y = tag.func_74762_e("posY");
        int z = tag.func_74762_e("posZ");
        int dim = tag.func_74762_e("dim");
        byte face = tag.func_74771_c("face");
        return new BlockPosEU(x, y, z, dim, face);
    }

    public static BlockPosEU readFromNBT(NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_150297_b("BlockPos", 10)) {
            return null;
        }
        return BlockPosEU.readFromTag(nbt.func_74775_l("BlockPos"));
    }

    public static void removeFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        nbt.func_82580_o("BlockPos");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimension;
        result = 31 * result + this.face;
        result = 31 * result + this.posX;
        result = 31 * result + this.posY;
        result = 31 * result + this.posZ;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockPosEU other = (BlockPosEU)obj;
        if (this.dimension != other.dimension) {
            return false;
        }
        if (this.face != other.face) {
            return false;
        }
        if (this.posX != other.posX) {
            return false;
        }
        if (this.posY != other.posY) {
            return false;
        }
        return this.posZ == other.posZ;
    }

    public String toString() {
        return String.format("BlockPosEU:{x: %d, y: %d, z: %d, dim: %d, face: %d}", this.posX, this.posY, this.posZ, this.dimension, this.face);
    }
}

