/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.gui.client.GuiEnderUtilities;
import fi.dy.masa.enderutilities.gui.client.GuiToolWorkstation;
import fi.dy.masa.enderutilities.inventory.ContainerToolWorkstation;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesSided;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityToolWorkstation
extends TileEntityEnderUtilitiesSided {
    public static final int SLOT_TOOL = 0;
    public static final int SLOT_MODULES_START = 1;

    public TileEntityToolWorkstation() {
        super("toolworkstation", 10);
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        ItemStack[] stacksToKeep = this.compatibilityInventoryHandlingFrom04x(nbt);
        super.readFromNBTCustom(nbt);
        if (stacksToKeep != null) {
            this.itemStacks = stacksToKeep;
        }
    }

    private ItemStack[] compatibilityInventoryHandlingFrom04x(NBTTagCompound nbt) {
        int i;
        if (nbt.func_150297_b("Version", 8)) {
            return null;
        }
        String str = String.format("Tool Workstation compatibility item handling from 0.4.x to 0.5.0 starting for TE at: x: %d y: %d z: %d", this.field_145851_c, this.field_145848_d, this.field_145849_e);
        EnderUtilities.logger.warn(str);
        ItemStack[] stacks = new ItemStack[this.invSize];
        ItemStack[] stacksTmp = this.readItemsFromNBT(nbt, 20, "Items");
        if (stacksTmp[0] != null) {
            UtilItemModular.compatibilityAdjustInstalledModulePositions(stacksTmp[0]);
        }
        for (i = 0; i < 9; ++i) {
            stacksTmp[i + 1] = stacksTmp[i + 11];
        }
        for (i = 0; i < 10; ++i) {
            stacks[i] = stacksTmp[i];
        }
        nbt.func_82580_o("Items");
        return stacks;
    }

    @Override
    public void func_70299_a(int slotNum, ItemStack itemStack) {
        super.func_70299_a(slotNum, itemStack);
        if (!this.field_145850_b.field_72995_K && slotNum == 0 && this.itemStacks[0] != null) {
            NBTHelperTarget.compatibilityTransferTargetData(this.itemStacks[0]);
            UtilItemModular.compatibilityAdjustInstalledModulePositions(this.itemStacks[0]);
        }
    }

    @Override
    public boolean func_94041_b(int slotNum, ItemStack stack) {
        if (stack == null) {
            return true;
        }
        if (slotNum == 0) {
            return stack == null || stack.func_77973_b() instanceof IModular;
        }
        return stack.func_77973_b() instanceof IModule && !UtilItemModular.moduleTypeEquals(stack, ItemModule.ModuleType.TYPE_INVALID);
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public boolean func_102007_a(int slotNum, ItemStack itemStack, int side) {
        return false;
    }

    @Override
    public ContainerToolWorkstation getContainer(EntityPlayer player) {
        return new ContainerToolWorkstation(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiEnderUtilities getGui(EntityPlayer player) {
        return new GuiToolWorkstation(this.getContainer(player), this);
    }
}

