/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.gui.client.GuiCreationStation;
import fi.dy.masa.enderutilities.gui.client.GuiEnderUtilities;
import fi.dy.masa.enderutilities.inventory.ContainerCreationStation;
import fi.dy.masa.enderutilities.inventory.IModularInventoryCallback;
import fi.dy.masa.enderutilities.inventory.InventoryItemCallback;
import fi.dy.masa.enderutilities.inventory.InventoryItemCrafting;
import fi.dy.masa.enderutilities.inventory.InventoryStackArray;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderFurnace;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesSided;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.ItemType;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.MathHelper;

public class TileEntityCreationStation
extends TileEntityEnderUtilitiesSided
implements IModularInventoryCallback {
    public static final int GUI_ACTION_SELECT_MODULE = 0;
    public static final int GUI_ACTION_MOVE_ITEMS = 1;
    public static final int GUI_ACTION_SET_QUICK_ACTION = 2;
    public static final int GUI_ACTION_CLEAR_CRAFTING_GRID = 3;
    public static final int GUI_ACTION_RECIPE_LOAD = 4;
    public static final int GUI_ACTION_RECIPE_STORE = 5;
    public static final int GUI_ACTION_RECIPE_CLEAR = 6;
    public static final int GUI_ACTION_TOGGLE_MODE = 7;
    public static final int INV_SIZE_ITEMS = 27;
    public static final int INV_ID_MODULES = 1;
    public static final int INV_ID_CRAFTING_LEFT = 2;
    public static final int INV_ID_CRAFTING_RIGHT = 3;
    public static final int INV_ID_FURNACE = 4;
    public static final int COOKTIME_INC_SLOW = 12;
    public static final int COOKTIME_INC_FAST = 30;
    public static final int COOKTIME_DEFAULT = 1200;
    public static final int BURNTIME_USAGE_SLOW = 20;
    public static final int BURNTIME_USAGE_FAST = 120;
    public static final int MODE_BIT_LEFT_CRAFTING_OREDICT = 1;
    public static final int MODE_BIT_LEFT_CRAFTING_KEEPONE = 2;
    public static final int MODE_BIT_LEFT_CRAFTING_AUTOUSE = 4;
    public static final int MODE_BIT_RIGHT_CRAFTING_OREDICT = 8;
    public static final int MODE_BIT_RIGHT_CRAFTING_KEEPONE = 16;
    public static final int MODE_BIT_RIGHT_CRAFTING_AUTOUSE = 32;
    public static final int MODE_BIT_LEFT_FAST = 64;
    public static final int MODE_BIT_RIGHT_FAST = 128;
    public static final int MODE_BIT_SHOW_RECIPE_LEFT = 16384;
    public static final int MODE_BIT_SHOW_RECIPE_RIGHT = 32768;
    protected InventoryItemCrafting[] craftingInventories;
    private final ItemStack[][] craftingGridTemplates;
    protected final IInventory[] craftResults;
    protected final ItemStack[][] recipeItems;
    protected final InventoryStackArray furnaceInventory;
    protected InventoryItemCallback itemInventory = new InventoryItemCallback(null, 27, false, null, this);
    protected ItemStack[] furnaceItems;
    protected int selectedModule;
    protected int actionMode;
    protected Map<UUID, Long> clickTimes;
    protected int numPlayersUsing = 0;
    protected ItemStack[] smeltingResultCache;
    public int[] burnTimeRemaining;
    public int[] burnTimeFresh;
    public int[] cookTime;
    protected boolean[] inputDirty;
    protected int modeMask = 0;
    protected byte furnaceMode;
    protected int recipeLoadClickCount;

    public TileEntityCreationStation() {
        super("creationstation", 4);
        this.craftingInventories = new InventoryItemCrafting[2];
        this.craftingGridTemplates = new ItemStack[][]{null, null};
        this.craftResults = new InventoryCraftResult[]{new InventoryCraftResult(), new InventoryCraftResult()};
        this.recipeItems = new ItemStack[][]{new ItemStack[10], new ItemStack[10]};
        this.furnaceItems = new ItemStack[6];
        this.furnaceInventory = new InventoryStackArray(this.furnaceItems, 1024, 6, true, this, 4);
        this.clickTimes = new HashMap<UUID, Long>();
        this.smeltingResultCache = new ItemStack[2];
        this.burnTimeRemaining = new int[2];
        this.burnTimeFresh = new int[2];
        this.cookTime = new int[2];
        this.inputDirty = new boolean[]{true, true};
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        this.setSelectedModule(nbt.func_74771_c("SelModule"));
        this.actionMode = nbt.func_74771_c("QuickMode");
        this.modeMask = nbt.func_74771_c("FurnaceMode");
        for (int i = 0; i < 2; ++i) {
            this.burnTimeRemaining[i] = nbt.func_74762_e("BurnTimeRemaining" + i);
            this.burnTimeFresh[i] = nbt.func_74762_e("BurnTimeFresh" + i);
            this.cookTime[i] = nbt.func_74762_e("CookTime" + i);
        }
        super.readFromNBTCustom(nbt);
        this.furnaceItems = this.readItemsFromNBT(nbt, 6, "FurnaceItems");
        this.furnaceInventory.setStackArray(this.furnaceItems);
        this.itemInventory.setContainerItemStack(this.itemStacks[this.selectedModule]);
        this.readModeMaskFromModule();
        this.loadRecipe(0, this.getRecipeId(0));
        this.loadRecipe(1, this.getRecipeId(1));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        nbt.func_74774_a("QuickMode", (byte)this.actionMode);
        nbt.func_74774_a("SelModule", (byte)this.selectedModule);
        nbt.func_74774_a("FurnaceMode", (byte)(this.modeMask & 0xC0));
        for (int i = 0; i < 2; ++i) {
            nbt.func_74768_a("BurnTimeRemaining" + i, this.burnTimeRemaining[i]);
            nbt.func_74768_a("BurnTimeFresh" + i, this.burnTimeFresh[i]);
            nbt.func_74768_a("CookTime" + i, this.cookTime[i]);
        }
        this.writeItemsToNBT(nbt, this.furnaceItems, "FurnaceItems");
        super.func_145841_b(nbt);
    }

    @Override
    public NBTTagCompound getDescriptionPacketTag(NBTTagCompound nbt) {
        nbt = super.getDescriptionPacketTag(nbt);
        nbt.func_74774_a("msel", (byte)this.selectedModule);
        return nbt;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound nbt = packet.func_148857_g();
        this.selectedModule = nbt.func_74771_c("msel");
        this.itemInventory.setIsRemote(true);
        this.itemInventory.setContainerItemStack(this.itemStacks[this.selectedModule]);
        super.onDataPacket(net, packet);
    }

    public IInventory getItemInventory() {
        return this.itemInventory;
    }

    public InventoryItemCrafting getCraftingInventory(int id, Container container, EntityPlayer player) {
        if (this.craftingInventories[id] == null) {
            this.craftingInventories[id] = new InventoryItemCrafting(container, 3, 3, this.getContainerStack(), this.field_145850_b.field_72995_K, player, this, "CraftItems_" + id);
            this.craftingInventories[id].readFromContainerItemStack();
        }
        return this.craftingInventories[id];
    }

    public IInventory getCraftResultInventory(int id) {
        return this.craftResults[id];
    }

    public InventoryStackArray getFurnaceInventory() {
        return this.furnaceInventory;
    }

    public int getQuickMode() {
        return this.actionMode;
    }

    public void setQuickMode(int mode) {
        this.actionMode = mode;
    }

    public boolean isInventoryAccessible(EntityPlayer player) {
        return this.itemInventory.func_70300_a(player);
    }

    public int getSelectedModule() {
        return this.selectedModule;
    }

    public void setSelectedModule(int index) {
        this.selectedModule = MathHelper.func_76125_a((int)index, (int)0, (int)(this.invSize - 1));
    }

    public int getModeMask() {
        return this.modeMask;
    }

    protected int readModeMaskFromModule() {
        NBTTagCompound tag;
        this.modeMask &= 0xC0;
        if (this.itemStacks[this.selectedModule] != null && (tag = NBTUtils.getCompoundTag(this.itemStacks[this.selectedModule], null, "CreationStation", false)) != null) {
            this.modeMask |= tag.func_74765_d("ConfigMask");
        }
        return this.modeMask;
    }

    protected void writeModeMaskToModule() {
        if (this.itemStacks[this.selectedModule] != null) {
            NBTTagCompound tag = NBTUtils.getCompoundTag(this.itemStacks[this.selectedModule], null, "CreationStation", true);
            tag.func_74777_a("ConfigMask", (short)(this.modeMask & 0xFFFFFF3F));
        }
    }

    public int getRecipeId(int invId) {
        int s = invId == 1 ? 11 : 8;
        return this.modeMask >> s & 7;
    }

    public void setRecipeId(int invId, int recipeId) {
        int shift = invId == 1 ? 11 : 8;
        int mask = invId == 1 ? 14336 : 1792;
        this.modeMask = this.modeMask & ~mask | (recipeId & 7) << shift;
    }

    public boolean getShowRecipe(int invId) {
        return invId == 1 ? (this.modeMask & 0x8000) != 0 : (this.modeMask & 0x4000) != 0;
    }

    public void setShowRecipe(int invId, boolean show) {
        int mask;
        int n = mask = invId == 1 ? 32768 : 16384;
        this.modeMask = show ? (this.modeMask |= mask) : (this.modeMask &= ~mask);
    }

    public void getRecipeOutput(int invId, int recipeId) {
    }

    public ItemStack[] getRecipeItems(int invId) {
        invId = MathHelper.func_76125_a((int)invId, (int)0, (int)1);
        return this.recipeItems[invId];
    }

    public NBTTagCompound getRecipeTag(int invId, int recipeId, boolean create) {
        ItemStack stack = this.itemStacks[this.selectedModule];
        if (stack == null) {
            return null;
        }
        return NBTUtils.getCompoundTag(stack, "CreationStation", "Recipes_" + invId, create);
    }

    protected void loadRecipe(int invId, int recipeId) {
        NBTTagCompound tag = this.getRecipeTag(invId, recipeId, false);
        if (tag != null) {
            this.clearLoadedRecipe(invId);
            ItemStack[] items = this.getRecipeItems(invId);
            NBTUtils.readStoredItemsFromTag(tag, items, "Recipe_" + recipeId);
        } else {
            this.removeRecipe(invId, recipeId);
        }
    }

    protected void storeRecipe(int invId, int recipeId) {
        InventoryItemCrafting invCrafting = this.craftingInventories[invId = MathHelper.func_76125_a((int)invId, (int)0, (int)1)];
        if (invCrafting == null) {
            return;
        }
        NBTTagCompound tag = this.getRecipeTag(invId, recipeId, true);
        if (tag != null) {
            int invSize = invCrafting.func_70302_i_();
            ItemStack[] items = this.getRecipeItems(invId);
            for (int i = 0; i < invSize; ++i) {
                ItemStack stack = invCrafting.func_70301_a(i);
                if (stack != null) {
                    stack = stack.func_77946_l();
                    stack.field_77994_a = 1;
                }
                items[i] = stack;
            }
            items[items.length - 1] = ItemStack.func_77944_b((ItemStack)this.craftResults[invId].func_70301_a(0));
            NBTUtils.writeItemsToTag(tag, items, "Recipe_" + recipeId, true);
        }
    }

    protected void clearLoadedRecipe(int invId) {
        ItemStack[] items = this.getRecipeItems(invId);
        for (int i = 0; i < items.length; ++i) {
            items[i] = null;
        }
    }

    protected void removeRecipe(int invId, int recipeId) {
        NBTTagCompound tag = this.getRecipeTag(invId, recipeId, false);
        if (tag != null) {
            tag.func_82580_o("Recipe_" + recipeId);
        }
        this.clearLoadedRecipe(invId);
    }

    protected boolean addOneSetOfRecipeItemsIntoGrid(int invId, int recipeId) {
        InventoryItemCrafting invCrafting = this.craftingInventories[invId = MathHelper.func_76125_a((int)invId, (int)0, (int)1)];
        if (invCrafting == null) {
            return false;
        }
        int maskOreDict = invId == 1 ? 8 : 1;
        boolean useOreDict = (this.modeMask & maskOreDict) != 0;
        return InventoryUtils.restockInventoryBasedOnTemplate((IInventory)invCrafting, this.itemInventory, this.getRecipeItems(invId), 1, true, useOreDict);
    }

    protected void fillCraftingGrid(int invId, int recipeId) {
        InventoryItemCrafting invCrafting = this.craftingInventories[invId = MathHelper.func_76125_a((int)invId, (int)0, (int)1)];
        if (invCrafting == null) {
            return;
        }
        int largestStack = InventoryUtils.getLargestExistingStackSize((IInventory)invCrafting);
        if (largestStack == 1) {
            largestStack = 64;
        }
        ItemStack[] template = InventoryUtils.createInventorySnapshot((IInventory)invCrafting);
        int maskOreDict = invId == 1 ? 8 : 1;
        boolean useOreDict = (this.modeMask & maskOreDict) != 0;
        Map<ItemType, Integer> slotCounts = InventoryUtils.getSlotCountPerItem((IInventory)invCrafting);
        if (InventoryUtils.tryMoveAllItems((IInventory)invCrafting, this.itemInventory, 0, 0, true)) {
            for (Map.Entry<ItemType, Integer> entry : slotCounts.entrySet()) {
                int numSlots;
                int numFound;
                int maxSize;
                ItemType item = entry.getKey();
                if (item.getStack().func_77976_d() == 1 || (maxSize = (numFound = InventoryUtils.getNumberOfMatchingItemsInInventory(this.itemInventory, item.getStack(), useOreDict)) / (numSlots = entry.getValue().intValue())) >= largestStack) continue;
                largestStack = maxSize;
            }
            InventoryUtils.restockInventoryBasedOnTemplate((IInventory)invCrafting, this.itemInventory, template, largestStack, false, useOreDict);
        }
    }

    protected boolean clearCraftingGrid(int invId, EntityPlayer player) {
        InventoryItemCrafting inv = this.craftingInventories[MathHelper.func_76125_a((int)invId, (int)0, (int)1)];
        if (inv == null) {
            return false;
        }
        if (!InventoryUtils.tryMoveAllItems((IInventory)inv, this.itemInventory, 0, 0, true)) {
            return InventoryUtils.tryMoveAllItems((IInventory)inv, (IInventory)player.field_71071_by, 0, 0, false);
        }
        return true;
    }

    public boolean canCraftItems(int invId) {
        boolean useOreDict;
        int maskKeepOne = (invId = MathHelper.func_76125_a((int)invId, (int)0, (int)1)) == 1 ? 16 : 2;
        int maskAutoUse = invId == 1 ? 32 : 4;
        this.craftingGridTemplates[invId] = null;
        InventoryItemCrafting invCrafting = this.craftingInventories[invId];
        if (invCrafting == null) {
            return false;
        }
        if ((this.modeMask & maskAutoUse) != 0) {
            this.craftingGridTemplates[invId] = InventoryUtils.createInventorySnapshot((IInventory)invCrafting);
        }
        if ((this.modeMask & maskKeepOne) == 0) {
            return true;
        }
        if ((this.modeMask & maskAutoUse) == 0 && InventoryUtils.getMinNonEmptyStackSize((IInventory)invCrafting) <= 1) {
            return false;
        }
        int maskOreDict = invId == 1 ? 8 : 1;
        boolean bl = useOreDict = (this.modeMask & maskOreDict) != 0;
        return InventoryUtils.getMinNonEmptyStackSize((IInventory)invCrafting) > 1 || InventoryUtils.checkInventoryHasAllItems(this.itemInventory, (IInventory)invCrafting, 1, useOreDict);
    }

    public void restockCraftingGrid(int invId) {
        int maskAutoUse;
        this.recipeLoadClickCount = 0;
        int n = maskAutoUse = (invId = MathHelper.func_76125_a((int)invId, (int)0, (int)1)) == 1 ? 32 : 4;
        if ((this.modeMask & maskAutoUse) == 0) {
            return;
        }
        if (this.craftingInventories[invId] == null || this.craftingGridTemplates[invId] == null) {
            return;
        }
        int maskOreDict = invId == 1 ? 8 : 1;
        boolean useOreDict = (this.modeMask & maskOreDict) != 0;
        InventoryUtils.restockInventoryBasedOnTemplate((IInventory)this.craftingInventories[invId], this.itemInventory, this.craftingGridTemplates[invId], 1, true, useOreDict);
        this.craftingGridTemplates[invId] = null;
    }

    @Override
    public ItemStack getContainerStack() {
        return this.itemStacks[this.selectedModule];
    }

    @Override
    public void inventoryChanged(int invId) {
        if (invId == 4) {
            this.inputDirty[1] = true;
            this.inputDirty[0] = true;
            return;
        }
        this.itemInventory.setContainerItemStack(this.itemStacks[this.selectedModule]);
        this.readModeMaskFromModule();
        if (this.craftingInventories[0] != null) {
            this.craftingInventories[0].setContainerItemStack(this.itemStacks[this.selectedModule]);
        }
        if (this.craftingInventories[1] != null) {
            this.craftingInventories[1].setContainerItemStack(this.itemStacks[this.selectedModule]);
        }
        this.loadRecipe(0, this.getRecipeId(0));
        this.loadRecipe(1, this.getRecipeId(1));
    }

    @Override
    public int func_70302_i_() {
        return this.invSize;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public void func_70299_a(int slotNum, ItemStack stack) {
        super.func_70299_a(slotNum, stack);
        this.inventoryChanged(1);
    }

    @Override
    public ItemStack func_70298_a(int slotNum, int maxAmount) {
        ItemStack stack = super.func_70298_a(slotNum, maxAmount);
        this.inventoryChanged(1);
        return stack;
    }

    @Override
    public boolean func_94041_b(int slotNum, ItemStack stack) {
        if (stack == null) {
            return true;
        }
        if (!(stack.func_77973_b() instanceof IModule)) {
            return false;
        }
        IModule module = (IModule)stack.func_77973_b();
        ItemModule.ModuleType type = module.getModuleType(stack);
        if (!type.equals(ItemModule.ModuleType.TYPE_INVALID) && type.equals(ItemModule.ModuleType.TYPE_MEMORY_CARD)) {
            return module.getModuleTier(stack) >= 6 && module.getModuleTier(stack) <= 12;
        }
        return false;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    @Override
    public void func_70295_k_() {
        ++this.numPlayersUsing;
    }

    @Override
    public void func_70305_f() {
        if (--this.numPlayersUsing <= 0) {
            this.numPlayersUsing = 0;
            this.craftingInventories[0] = null;
            this.craftingInventories[1] = null;
        }
    }

    public void onLeftClickBlock(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Long last = this.clickTimes.get(player.func_110124_au());
        if (last != null && this.field_145850_b.func_82737_E() - last < 5L) {
            this.performGuiAction(player, 1, this.actionMode);
            player.field_70170_p.func_72956_a((Entity)player, "mob.endermen.portal", 0.2f, 1.8f);
            this.clickTimes.remove(player.func_110124_au());
        } else {
            this.clickTimes.put(player.func_110124_au(), this.field_145850_b.func_82737_E());
        }
    }

    @Override
    public void performGuiAction(EntityPlayer player, int action, int element) {
        if (action == 0 && element >= 0 && element < 4) {
            this.itemInventory.func_70296_d();
            this.setSelectedModule(element);
            this.inventoryChanged(1);
        } else if (action == 1 && element >= 0 && element < 6) {
            InventoryItemCallback inv = this.itemInventory;
            if (!inv.func_70300_a(player)) {
                return;
            }
            int playerMaxSlot = player.field_71071_by.func_70302_i_() - 5;
            int chestMaxSlot = this.itemInventory.func_70302_i_() - 1;
            switch (element) {
                case 0: {
                    InventoryUtils.tryMoveAllItemsWithinSlotRange((IInventory)player.field_71071_by, inv, 0, 0, 0, playerMaxSlot, 0, chestMaxSlot, true);
                    break;
                }
                case 1: {
                    InventoryUtils.tryMoveMatchingItemsWithinSlotRange((IInventory)player.field_71071_by, inv, 0, 0, 0, playerMaxSlot, 0, chestMaxSlot, true);
                    break;
                }
                case 2: {
                    InventoryUtils.leaveOneFullStackOfEveryItem((IInventory)player.field_71071_by, inv, false, false, true);
                    break;
                }
                case 3: {
                    InventoryUtils.fillStacksOfMatchingItemsWithinSlotRange(inv, (IInventory)player.field_71071_by, 0, 0, 0, chestMaxSlot, 0, playerMaxSlot, false);
                    break;
                }
                case 4: {
                    InventoryUtils.tryMoveMatchingItemsWithinSlotRange(inv, (IInventory)player.field_71071_by, 0, 0, 0, chestMaxSlot, 0, playerMaxSlot, false);
                    break;
                }
                case 5: {
                    InventoryUtils.tryMoveAllItemsWithinSlotRange(inv, (IInventory)player.field_71071_by, 0, 0, 0, chestMaxSlot, 0, playerMaxSlot, false);
                }
            }
        } else if (action == 2 && element >= 0 && element < 6) {
            this.actionMode = element;
        } else if (action == 3 && element >= 0 && element < 2) {
            InventoryItemCrafting inv = this.craftingInventories[element];
            if (InventoryUtils.isInventoryEmpty((IInventory)inv)) {
                this.setShowRecipe(element, false);
                this.clearLoadedRecipe(element);
                this.writeModeMaskToModule();
            } else {
                this.clearCraftingGrid(element, player);
            }
            this.recipeLoadClickCount = 0;
        } else if (action == 4 && element >= 0 && element < 10) {
            int invId = element / 5;
            int recipeId = element % 5;
            if (this.getRecipeId(invId) == recipeId && this.getShowRecipe(invId)) {
                if (this.recipeLoadClickCount == 0) {
                    if (this.addOneSetOfRecipeItemsIntoGrid(invId, recipeId)) {
                        ++this.recipeLoadClickCount;
                    }
                } else {
                    this.fillCraftingGrid(invId, recipeId);
                }
            } else {
                this.loadRecipe(invId, recipeId);
                this.setRecipeId(invId, recipeId);
                this.recipeLoadClickCount = 0;
            }
            this.setShowRecipe(invId, true);
            this.writeModeMaskToModule();
        } else if (action == 5 && element >= 0 && element < 10) {
            int invId = element / 5;
            int recipeId = element % 5;
            this.storeRecipe(invId, recipeId);
            this.setShowRecipe(invId, true);
            this.setRecipeId(invId, recipeId);
            this.writeModeMaskToModule();
        } else if (action == 6 && element >= 0 && element < 10) {
            int invId = element / 5;
            int recipeId = element % 5;
            this.removeRecipe(invId, recipeId);
            this.setShowRecipe(invId, false);
            this.writeModeMaskToModule();
            this.recipeLoadClickCount = 0;
        } else if (action == 7 && element >= 0 && element < 8) {
            switch (element) {
                case 0: {
                    this.modeMask ^= 1;
                    break;
                }
                case 1: {
                    this.modeMask ^= 2;
                    break;
                }
                case 2: {
                    this.modeMask ^= 4;
                    break;
                }
                case 3: {
                    this.modeMask ^= 0x20;
                    break;
                }
                case 4: {
                    this.modeMask ^= 0x10;
                    break;
                }
                case 5: {
                    this.modeMask ^= 8;
                    break;
                }
                case 6: {
                    this.modeMask ^= 0x40;
                    break;
                }
                case 7: {
                    this.modeMask ^= 0x80;
                    break;
                }
            }
            this.writeModeMaskToModule();
        }
    }

    public boolean isBurning(int id) {
        return this.burnTimeRemaining[id] > 0;
    }

    private void updateSmeltingResult(int id) {
        if (this.inputDirty[id]) {
            ItemStack inputStack = this.furnaceInventory.func_70301_a(id * 3);
            this.smeltingResultCache[id] = inputStack != null ? FurnaceRecipes.func_77602_a().func_151395_a(inputStack) : null;
            this.inputDirty[id] = false;
        }
    }

    public boolean hasFuelAvailable(int id) {
        ItemStack fuelStack = this.furnaceInventory.func_70301_a(id * 3 + 1);
        if (fuelStack == null) {
            return false;
        }
        return TileEntityEnderFurnace.itemContainsFluidFuel(fuelStack) || TileEntityEnderFurnace.getItemBurnTime(fuelStack) > 0;
    }

    public int consumeFuelItem(int id) {
        ItemStack fuelStack = this.furnaceInventory.func_70301_a(id * 3 + 1);
        if (fuelStack == null) {
            return 0;
        }
        int burnTime = TileEntityEnderFurnace.consumeFluidFuelDosage(fuelStack);
        if (burnTime > 0) {
            this.burnTimeFresh[id] = burnTime;
        } else {
            burnTime = TileEntityEnderFurnace.getItemBurnTime(fuelStack);
            if (burnTime > 0) {
                if (--fuelStack.field_77994_a <= 0) {
                    fuelStack = fuelStack.func_77973_b().getContainerItem(fuelStack);
                }
                this.burnTimeFresh[id] = burnTime;
                this.furnaceInventory.func_70299_a(id * 3 + 1, fuelStack);
            }
        }
        return burnTime;
    }

    public boolean canSmelt(int id) {
        ItemStack inputStack = this.furnaceInventory.func_70301_a(id * 3);
        if (inputStack == null || this.smeltingResultCache[id] == null) {
            return false;
        }
        int amount = 0;
        ItemStack outputStack = this.furnaceInventory.func_70301_a(id * 3 + 2);
        if (outputStack != null) {
            if (!InventoryUtils.areItemStacksEqual(this.smeltingResultCache[id], outputStack)) {
                return false;
            }
            amount = outputStack.field_77994_a;
        }
        return this.furnaceInventory.func_70297_j_() - amount >= this.smeltingResultCache[id].field_77994_a;
    }

    public void smeltItem(int id) {
        if (this.canSmelt(id)) {
            ItemStack stack = this.furnaceInventory.func_70301_a(id * 3 + 2);
            if (stack == null) {
                stack = this.smeltingResultCache[id].func_77946_l();
            } else {
                stack.field_77994_a += this.smeltingResultCache[id].field_77994_a;
            }
            this.furnaceInventory.func_70299_a(id * 3 + 2, stack);
            stack = this.furnaceInventory.func_70301_a(id * 3);
            if (--stack.field_77994_a <= 0) {
                stack = null;
                this.inputDirty[id] = true;
            }
            this.furnaceInventory.func_70299_a(id * 3, stack);
        }
    }

    protected void smeltingLogic(int id) {
        this.updateSmeltingResult(id);
        boolean dirty = false;
        boolean hasFuel = this.hasFuelAvailable(id);
        boolean isFastMode = id == 0 ? (this.modeMask & 0x40) != 0 : (this.modeMask & 0x80) != 0;
        int cookTimeIncrement = 12;
        if (this.burnTimeRemaining[id] == 0 && !hasFuel) {
            return;
        }
        if (isFastMode) {
            cookTimeIncrement = 30;
        }
        boolean canSmelt = this.canSmelt(id);
        if (this.burnTimeRemaining[id] > 0) {
            int btUse;
            int n = btUse = isFastMode ? 120 : 20;
            if (btUse > this.burnTimeRemaining[id]) {
                if (hasFuel && canSmelt) {
                    int n2 = id;
                    this.burnTimeRemaining[n2] = this.burnTimeRemaining[n2] + this.consumeFuelItem(id);
                    hasFuel = this.hasFuelAvailable(id);
                } else {
                    cookTimeIncrement = this.burnTimeRemaining[id] * cookTimeIncrement / btUse;
                    btUse = this.burnTimeRemaining[id];
                }
            }
            int n3 = id;
            this.burnTimeRemaining[n3] = this.burnTimeRemaining[n3] - btUse;
            dirty = true;
        } else if (canSmelt && hasFuel) {
            int n = id;
            this.burnTimeRemaining[n] = this.burnTimeRemaining[n] + this.consumeFuelItem(id);
            hasFuel = this.hasFuelAvailable(id);
            dirty = true;
        }
        if (canSmelt) {
            int n = id;
            this.cookTime[n] = this.cookTime[n] + cookTimeIncrement;
            if (this.cookTime[id] >= 1200) {
                this.smeltItem(id);
                canSmelt = this.canSmelt(id);
                if (canSmelt && this.cookTime[id] > 1200) {
                    int n4 = id;
                    this.cookTime[n4] = this.cookTime[n4] - 1200;
                } else {
                    this.cookTime[id] = 0;
                }
            }
            if (this.burnTimeRemaining[id] == 0 && hasFuel && canSmelt) {
                int n5 = id;
                this.burnTimeRemaining[n5] = this.burnTimeRemaining[n5] + this.consumeFuelItem(id);
            }
            dirty = true;
        } else if (this.cookTime[id] > 0) {
            int n = id;
            this.cookTime[n] = this.cookTime[n] - Math.min(this.cookTime[id], 6);
            dirty = true;
        }
        if (dirty) {
            this.func_70296_d();
        }
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.smeltingLogic(0);
        this.smeltingLogic(1);
    }

    public int getSmeltProgressScaled(int id, int i) {
        return this.cookTime[id] * i / 1200;
    }

    public int getBurnTimeRemainingScaled(int id, int i) {
        if (this.burnTimeFresh[id] == 0) {
            return 0;
        }
        return this.burnTimeRemaining[id] * i / this.burnTimeFresh[id];
    }

    @Override
    public ContainerCreationStation getContainer(EntityPlayer player) {
        return new ContainerCreationStation(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiEnderUtilities getGui(EntityPlayer player) {
        return new GuiCreationStation(this.getContainer(player), this);
    }
}

