/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.tool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.client.effects.Particles;
import fi.dy.masa.enderutilities.creativetab.CreativeTab;
import fi.dy.masa.enderutilities.event.PlayerItemPickupEvent;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.ILocationBound;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderCapacitor;
import fi.dy.masa.enderutilities.item.part.ItemLinkCrystal;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageAddEffects;
import fi.dy.masa.enderutilities.reference.ReferenceKeys;
import fi.dy.masa.enderutilities.reference.ReferenceNames;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.util.BlockUtils;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.EnergyBridgeTracker;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;

public class ItemEnderTool
extends ItemTool
implements IKeyBound,
IModular {
    public static final Item.ToolMaterial ENDER_ALLOY_ADVANCED = EnumHelper.addToolMaterial((String)"enderutilities.enderalloy.advanced", (int)Configs.harvestLevelEnderAlloyAdvanced.getInt(3), (int)2560, (float)12.0f, (float)4.0f, (int)15);
    public static final int ENDER_CHARGE_COST = 50;
    public float field_77864_a;
    public float field_77865_bY;
    private final Item.ToolMaterial material = ENDER_ALLOY_ADVANCED;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconEmpty;
    @SideOnly(value=Side.CLIENT)
    String[] parts;

    public ItemEnderTool() {
        super(2.0f, ENDER_ALLOY_ADVANCED, (Set)Sets.newHashSet((Object[])new Block[]{Blocks.field_150478_aa}));
        this.func_77625_d(1);
        this.func_77656_e(this.material.func_77997_a());
        this.setNoRepair();
        this.field_77864_a = this.material.func_77998_b();
        this.field_77865_bY = 2.0f + this.material.func_78000_c();
        this.func_77637_a(CreativeTab.ENDER_UTILITIES_TAB);
        this.func_77655_b(ReferenceNames.getPrefixedName("endertool"));
        this.func_111206_d(ReferenceTextures.getItemTextureName("endertool"));
    }

    public String func_77667_c(ItemStack stack) {
        ToolType toolType = this.getToolType(stack);
        if (toolType != ToolType.INVALID) {
            return super.func_77658_a() + "." + toolType.getName();
        }
        return super.func_77658_a();
    }

    public String func_77653_i(ItemStack stack) {
        ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (moduleStack != null && moduleStack.func_77973_b() instanceof ILocationBound) {
            String targetName;
            String itemName = StatCollector.func_74838_a((String)(this.func_77667_c(stack) + ".name")).trim();
            String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.WHITE.toString();
            if (moduleStack.func_82837_s()) {
                String pre = EnumChatFormatting.GREEN.toString() + EnumChatFormatting.ITALIC.toString();
                if (itemName.length() >= 14) {
                    return EUStringUtils.getInitialsWithDots(itemName) + " " + pre + moduleStack.func_82833_r() + rst;
                }
                return itemName + " " + pre + moduleStack.func_82833_r() + rst;
            }
            if (moduleStack.func_77973_b() instanceof ItemLinkCrystal && (targetName = ((ItemLinkCrystal)moduleStack.func_77973_b()).getTargetDisplayName(moduleStack)) != null) {
                return itemName + " " + EnumChatFormatting.GREEN.toString() + targetName + rst;
            }
        }
        return super.func_77653_i(stack);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (player != null && player.func_70093_af() && te != null && (te instanceof IInventory || te.getClass() == TileEntityEnderChest.class) && UtilItemModular.getSelectedModuleTier(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 1) {
            if (!world.field_72995_K) {
                UtilItemModular.setTarget(stack, player, x, y, z, side, hitX, hitY, hitZ, false, false);
            }
        } else if (this.getToolType(stack).equals(ToolType.HOE)) {
            if (world.field_72995_K) {
                return true;
            }
            if (this.isToolPowered(stack)) {
                if (!this.useHoeArea(stack, player, world, x, y, z, side, 1, 1)) {
                    this.useHoeToPlantArea(stack, player, world, x, y, z, side, hitX, hitY, hitZ, 1, 1);
                }
            } else if (!this.useHoe(stack, player, world, x, y, z, side)) {
                this.useHoeToPlant(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
            }
        } else if (player != null && !(player instanceof FakePlayer)) {
            int origSlot = player.field_71071_by.field_70461_c;
            int slot = origSlot >= InventoryPlayer.func_70451_h() - 1 ? 0 : origSlot + 1;
            ItemStack targetStack = player.field_71071_by.func_70301_a(slot);
            if (!(origSlot != 0 || targetStack != null && targetStack.func_77973_b() instanceof ItemBlock)) {
                slot = InventoryPlayer.func_70451_h() - 1;
                targetStack = player.field_71071_by.func_70301_a(slot);
            }
            if (targetStack != null && targetStack.func_77973_b() instanceof ItemBlock && BlockUtils.checkCanPlaceBlockAt(world, x, y, z, side, player, targetStack)) {
                if (world.field_72995_K) {
                    return true;
                }
                player.field_71071_by.field_70461_c = slot;
                boolean success = targetStack.func_77943_a(player, world, x, y, z, side, hitX, hitY, hitZ);
                player.field_71071_by.field_70461_c = origSlot;
                player.field_71071_by.func_70296_d();
                player.field_71069_bz.func_75142_b();
                return success;
            }
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int slot, boolean isCurrent) {
        super.func_77663_a(stack, world, player, slot, isCurrent);
        if (!world.field_72995_K && EnergyBridgeTracker.dimensionHasEnergyBridge(world.field_73011_w.field_76574_g) && (world.field_73011_w.field_76574_g == 1 || EnergyBridgeTracker.dimensionHasEnergyBridge(1))) {
            UtilItemModular.addEnderCharge(stack, 100, true);
        }
    }

    public boolean useHoeArea(ItemStack stack, EntityPlayer player, World world, int xIn, int yIn, int zIn, int side, int rWidth, int rHeight) {
        boolean northSouth = (MathHelper.func_76141_d((float)(player.field_70177_z * 4.0f / 360.0f + 0.5f)) & 1) == 0;
        boolean retValue = false;
        if (!northSouth) {
            int tmp = rWidth;
            rWidth = rHeight;
            rHeight = tmp;
        }
        for (int x = xIn - rWidth; x <= xIn + rWidth; ++x) {
            for (int z = zIn - rHeight; z <= zIn + rHeight; ++z) {
                retValue |= this.useHoe(stack, player, world, x, yIn, z, side);
            }
        }
        return retValue;
    }

    public boolean useHoe(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        if (!player.func_82247_a(x, y, z, side, stack)) {
            return false;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack, world, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            this.addToolDamage(stack, 1, (EntityLivingBase)player, (EntityLivingBase)player);
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        if (side != 0 && world.func_147439_a(x, y + 1, z).isAir((IBlockAccess)world, x, y + 1, z) && (block == Blocks.field_150349_c || block == Blocks.field_150346_d)) {
            if (!world.field_72995_K) {
                Block blockFarmland = Blocks.field_150458_ak;
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, blockFarmland.field_149762_H.func_150498_e(), (blockFarmland.field_149762_H.func_150497_c() + 1.0f) / 2.0f, blockFarmland.field_149762_H.func_150494_d() * 0.8f);
                world.func_147465_d(x, y, z, blockFarmland, 0, 3);
                world.func_147471_g(x, y, z);
                this.addToolDamage(stack, 1, (EntityLivingBase)player, (EntityLivingBase)player);
            }
            return true;
        }
        return false;
    }

    public boolean useHoeToPlantArea(ItemStack stack, EntityPlayer player, World world, int xIn, int yIn, int zIn, int side, float hitX, float hitY, float hitZ, int rWidth, int rHeight) {
        boolean northSouth = (MathHelper.func_76141_d((float)(player.field_70177_z * 4.0f / 360.0f + 0.5f)) & 1) == 0;
        boolean retValue = false;
        if (!northSouth) {
            int tmp = rWidth;
            rWidth = rHeight;
            rHeight = tmp;
        }
        for (int x = xIn - rWidth; x <= xIn + rWidth; ++x) {
            for (int z = zIn - rHeight; z <= zIn + rHeight; ++z) {
                retValue |= this.useHoeToPlant(stack, player, world, x, yIn, z, side, hitX, hitY, hitZ);
            }
        }
        return retValue;
    }

    public boolean useHoeToPlant(ItemStack toolStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        block6: {
            if (!UtilItemModular.useEnderCharge(toolStack, 50, false)) {
                return false;
            }
            IInventory inv = this.getLinkedInventoryWithChecks(toolStack, player);
            if (inv == null) break block6;
            if (inv instanceof ISidedInventory) {
                int[] slots;
                NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                ISidedInventory sided = (ISidedInventory)inv;
                for (int slotNum : slots = sided.func_94128_d(target.blockFace)) {
                    if (!sided.func_102008_b(slotNum, sided.func_70301_a(slotNum), target.blockFace) || !this.plantItemFromInventorySlot(world, player, (IInventory)sided, slotNum, x, y, z, side, hitX, hitY, hitZ)) continue;
                    UtilItemModular.useEnderCharge(toolStack, 50, true);
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageAddEffects(2, 3, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 8, 0.2, 0.3), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, 24.0));
                }
            } else {
                int size = inv.func_70302_i_();
                for (int slotNum = 0; slotNum < size; ++slotNum) {
                    if (!this.plantItemFromInventorySlot(world, player, inv, slotNum, x, y, z, side, hitX, hitY, hitZ)) continue;
                    if (this.getToolModeByName(toolStack, "DropsMode") == 2) {
                        UtilItemModular.useEnderCharge(toolStack, 50, true);
                    }
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageAddEffects(2, 3, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 8, 0.2, 0.3), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, 24.0));
                }
            }
        }
        return false;
    }

    private boolean plantItemFromInventorySlot(World world, EntityPlayer player, IInventory inv, int slotNum, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        ItemStack newStack;
        ItemStack plantStack = inv.func_70301_a(slotNum);
        if (plantStack != null && plantStack.func_77973_b() instanceof IPlantable && (newStack = plantStack.func_77946_l()).func_77943_a(player, world, x, y, z, side, hitX, hitY, hitZ)) {
            if (newStack.field_77994_a > 0) {
                inv.func_70299_a(slotNum, newStack);
            } else {
                inv.func_70299_a(slotNum, null);
            }
            inv.func_70296_d();
            if (inv instanceof InventoryPlayer) {
                player.field_71069_bz.func_75142_b();
            }
            return true;
        }
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public ToolType getToolType(ItemStack stack) {
        if (stack == null) {
            return ToolType.INVALID;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74779_i("ToolType").length() > 0) {
            return ToolType.valueOfType(nbt.func_74779_i("ToolType"));
        }
        this.setToolType(stack, ToolType.SHOVEL);
        return ToolType.SHOVEL;
    }

    public boolean setToolType(ItemStack stack, ToolType type) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74778_a("ToolType", type.getTypeString());
        return true;
    }

    public byte getToolModeByName(ItemStack stack, String name) {
        return NBTUtils.getByte(stack, null, name);
    }

    public void setToolModeByName(ItemStack stack, String name, byte value) {
        NBTUtils.setByte(stack, null, name, value);
    }

    public String getToolClass(ItemStack stack) {
        ToolType type;
        if (stack != null && !(type = this.getToolType(stack)).equals(ToolType.INVALID)) {
            return type.getTypeString();
        }
        return null;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        String tc = this.getToolClass(stack);
        return tc != null ? ImmutableSet.of((Object)tc) : super.getToolClasses(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.material.func_77997_a();
    }

    public boolean isToolBroken(ItemStack stack) {
        return stack == null || stack.func_77960_j() >= this.getMaxDamage(stack);
    }

    public boolean addToolDamage(ItemStack stack, int amount, EntityLivingBase living1, EntityLivingBase living2) {
        if (stack == null || this.isToolBroken(stack)) {
            return false;
        }
        amount = Math.min(amount, this.getMaxDamage(stack) - stack.func_77960_j());
        stack.func_77972_a(amount, living2);
        if (this.isToolBroken(stack)) {
            living1.func_70669_a(stack);
        }
        return true;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase living1, EntityLivingBase living2) {
        return this.addToolDamage(stack, 2, living1, living2);
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase living) {
        if (block.func_149688_o() != null && block.func_149688_o() == Material.field_151584_j && this.getToolType(stack).equals(ToolType.AXE)) {
            return false;
        }
        if (!this.isToolBroken(stack) && block.func_149712_f(world, x, y, z) > 0.0f) {
            int dmg = this.getToolModeByName(stack, "Powered") == 1 ? 2 : 1;
            return this.addToolDamage(stack, dmg, living, living);
        }
        return false;
    }

    private IInventory getLinkedInventoryWithChecks(ItemStack toolStack, EntityPlayer player) {
        byte mode = this.getToolModeByName(toolStack, "DropsMode");
        if (mode == 0) {
            return null;
        }
        if (mode == 1 && !(player instanceof FakePlayer) && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE) >= 0) {
            return player.field_71071_by;
        }
        if (mode == 2 && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE) >= 1 && UtilItemModular.useEnderCharge(toolStack, 50, false)) {
            return UtilItemModular.getBoundInventory(toolStack, player, 30);
        }
        return null;
    }

    public void handleHarvestDropsEvent(ItemStack toolStack, BlockEvent.HarvestDropsEvent event) {
        if (this.isToolBroken(toolStack) || event.world == null || event.world.field_72995_K) {
            return;
        }
        byte mode = this.getToolModeByName(toolStack, "DropsMode");
        if (mode == 0) {
            return;
        }
        EntityPlayer player = event.harvester;
        boolean isSilk = event.isSilkTouching;
        int numDropsOriginal = event.drops.size();
        if (mode != 2 && MinecraftForge.EVENT_BUS.post((Event)new PlayerItemPickupEvent(player, event.drops))) {
            return;
        }
        IInventory inv = this.getLinkedInventoryWithChecks(toolStack, player);
        if (inv != null) {
            Iterator iter = event.drops.iterator();
            if (inv instanceof InventoryPlayer) {
                while (iter.hasNext()) {
                    ItemStack stack = (ItemStack)iter.next();
                    if (stack == null || !isSilk && !(event.world.field_73012_v.nextFloat() < event.dropChance) || !player.field_71071_by.func_70441_a(stack.func_77946_l())) continue;
                    iter.remove();
                }
            } else {
                NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                while (iter.hasNext()) {
                    ItemStack stack = (ItemStack)iter.next();
                    if (stack == null || !isSilk && !(event.world.field_73012_v.nextFloat() < event.dropChance)) continue;
                    ItemStack stackTmp = InventoryUtils.tryInsertItemStackToInventory(inv, stack.func_77946_l(), target.blockFace);
                    if (stackTmp == null) {
                        iter.remove();
                        continue;
                    }
                    stack.field_77994_a = stackTmp.field_77994_a;
                }
            }
        } else if (this.getSelectedModuleTier(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) == 0) {
            NBTHelperTarget target = NBTHelperTarget.getTargetFromSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            if (!NBTHelperPlayer.canAccessSelectedModule(toolStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, player) || target.dimension != player.field_71093_bK && this.getMaxModuleTier(toolStack, ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE) < 2) {
                return;
            }
            WorldServer targetWorld = MinecraftServer.func_71276_C().func_71218_a(target.dimension);
            if (targetWorld == null) {
                return;
            }
            ChunkLoading.getInstance().loadChunkForcedWithPlayerTicket(player, target.dimension, target.posX >> 4, target.posZ >> 4, 30);
            Iterator iter = event.drops.iterator();
            while (iter.hasNext()) {
                ItemStack stack = (ItemStack)iter.next();
                if (stack == null || !isSilk && !(event.world.field_73012_v.nextFloat() < event.dropChance)) continue;
                EntityItem entityItem = new EntityItem((World)targetWorld, target.dPosX, target.dPosY + 0.125, target.dPosZ, stack.func_77946_l());
                entityItem.field_70179_y = 0.0;
                entityItem.field_70159_w = 0.0;
                entityItem.field_70181_x = 0.15;
                if (!targetWorld.func_72838_d((Entity)entityItem)) continue;
                Particles.spawnParticles((World)targetWorld, "portal", target.dPosX, target.dPosY, target.dPosZ, 3, 0.2, 1.0);
                iter.remove();
            }
        }
        if (event.drops.size() != numDropsOriginal) {
            if (mode == 2) {
                UtilItemModular.useEnderCharge(toolStack, 50, true);
            }
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageAddEffects(2, 3, (double)event.x + 0.5, (double)event.y + 0.5, (double)event.z + 0.5, 8, 0.2, 0.3), new NetworkRegistry.TargetPoint(event.world.field_73011_w.field_76574_g, (double)event.x, (double)event.y, (double)event.z, 24.0));
        }
        if (event.drops.size() == 0) {
            event.dropChance = 0.0f;
        }
    }

    public boolean func_150897_b(Block block) {
        return false;
    }

    public float func_150893_a(ItemStack stack, Block block) {
        if (this.isToolBroken(stack)) {
            return 0.2f;
        }
        if (this.canHarvestBlock(block, stack)) {
            return this.field_77864_a;
        }
        return 1.0f;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        if (this.isToolBroken(stack)) {
            return false;
        }
        return this.getToolType(stack).equals(ToolType.PICKAXE) ? block.func_149688_o() == Material.field_151576_e || block.func_149688_o() == Material.field_151592_s || block.func_149688_o() == Material.field_151588_w || block.func_149688_o() == Material.field_151598_x || block.func_149688_o() == Material.field_76233_E || block.func_149688_o() == Material.field_151573_f || block.func_149688_o() == Material.field_151574_g : (this.getToolType(stack).equals(ToolType.AXE) ? block.func_149688_o() == Material.field_151575_d || block.func_149688_o() == Material.field_151584_j || block.func_149688_o() == Material.field_151572_C || block.func_149688_o() == Material.field_151593_r || block.func_149688_o() == Material.field_151580_n || block.func_149688_o() == Material.field_151585_k || block.func_149688_o() == Material.field_151582_l : this.getToolType(stack).equals(ToolType.SHOVEL) && (block.func_149688_o() == Material.field_151578_c || block.func_149688_o() == Material.field_151577_b || block.func_149688_o() == Material.field_151595_p || block.func_149688_o() == Material.field_151597_y || block.func_149688_o() == Material.field_151596_z || block.func_149688_o() == Material.field_151571_B));
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (this.isToolBroken(stack)) {
            return 0.2f;
        }
        if (block.func_149688_o() != null && block.func_149688_o() == Material.field_151584_j && this.getToolType(stack).equals(ToolType.AXE)) {
            return 100.0f;
        }
        float eff = this.field_77864_a;
        if (this.getToolModeByName(stack, "Powered") == 1) {
            eff = EnchantmentHelper.func_77506_a((int)Enchantment.field_77349_p.field_77352_x, (ItemStack)stack) >= 5 ? 124.0f : 24.0f;
        }
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            return eff;
        }
        if (this.canHarvestBlock(block, stack)) {
            return eff;
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (stack != null && !this.isToolBroken(stack) && toolClass.equals(this.getToolClass(stack))) {
            return this.material.func_77996_d();
        }
        return -1;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.material.func_77995_e();
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        double dmg = this.field_77865_bY;
        dmg = this.isToolBroken(stack) ? 1.0 : (dmg += (double)this.getToolType(stack).getAttackDamage());
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", dmg, 0));
        return multimap;
    }

    public boolean isToolPowered(ItemStack stack) {
        return this.getToolModeByName(stack, "Powered") == 1;
    }

    public void cyclePoweredMode(ItemStack stack) {
        NBTUtils.cycleByteValue(stack, null, "Powered", 1);
    }

    public void cycleDropsMode(ItemStack stack) {
        NBTUtils.cycleByteValue(stack, null, "DropsMode", 2);
    }

    public void changePrivacyMode(ItemStack stack, EntityPlayer player) {
        NBTHelperPlayer data = NBTHelperPlayer.getPlayerDataFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (data != null && data.isOwner(player)) {
            data.isPublic = !data.isPublic;
            data.writeToSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (stack == null || ReferenceKeys.getBaseKey(key) != 1) {
            return;
        }
        if (key == 1) {
            this.cyclePoweredMode(stack);
        } else if (ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, ReferenceKeys.keypressActionIsReversed(key) || ReferenceKeys.keypressContainsShift(key));
        } else if (ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key) && !ReferenceKeys.keypressContainsControl(key)) {
            UtilItemModular.setTarget(stack, player, true);
        } else if (ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.cycleDropsMode(stack);
        } else if (ReferenceKeys.keypressContainsAlt(key) && !ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsControl(key)) {
            this.changePrivacyMode(stack, player);
        }
    }

    @Override
    public int getInstalledModuleCount(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getInstalledModuleCount(containerStack, moduleType);
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 5;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 3;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        if (!moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) || imodule.getModuleTier(moduleStack) == 0 || imodule.getModuleTier(moduleStack) == 1) {
            return this.getMaxModules(containerStack, moduleType);
        }
        return 0;
    }

    @Override
    public int getMaxModuleTier(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getMaxModuleTier(containerStack, moduleType);
    }

    @Override
    public int getSelectedModuleTier(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getSelectedModuleTier(containerStack, moduleType);
    }

    @Override
    public ItemStack getSelectedModuleStack(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        return UtilItemModular.getSelectedModuleStack(containerStack, moduleType);
    }

    @Override
    public boolean setSelectedModuleStack(ItemStack containerStack, ItemModule.ModuleType moduleType, ItemStack moduleStack) {
        return UtilItemModular.setSelectedModuleStack(containerStack, moduleType, moduleStack);
    }

    @Override
    public boolean changeSelectedModule(ItemStack containerStack, ItemModule.ModuleType moduleType, boolean reverse) {
        return UtilItemModular.changeSelectedModule(containerStack, moduleType, reverse);
    }

    @Override
    public List<NBTTagCompound> getAllModules(ItemStack containerStack) {
        return UtilItemModular.getAllModules(containerStack);
    }

    @Override
    public boolean setAllModules(ItemStack containerStack, List<NBTTagCompound> modules) {
        return UtilItemModular.setAllModules(containerStack, modules);
    }

    @Override
    public boolean setModule(ItemStack containerStack, int index, NBTTagCompound nbt) {
        return UtilItemModular.setModule(containerStack, index, nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        ItemStack linkCrystalStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        ItemStack capacitorStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR);
        int coreTier = this.getSelectedModuleTier(stack, ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE);
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
        String preDGreen = EnumChatFormatting.DARK_GREEN.toString();
        String preBlue = EnumChatFormatting.BLUE.toString();
        byte mode = this.getToolModeByName(stack, "DropsMode");
        String str = mode == 0 ? "enderutilities.tooltip.item.normal" : (mode == 1 ? "enderutilities.tooltip.item.endertool.playerinv" : "enderutilities.tooltip.item.endertool.remote");
        str = StatCollector.func_74838_a((String)str);
        list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.endertool.dropsmode") + ": " + preDGreen + str + rst);
        if (this.getToolType(stack).equals(ToolType.HOE)) {
            str = this.isToolPowered(stack) ? "enderutilities.tooltip.item.3x3" : "enderutilities.tooltip.item.1x1";
            str = StatCollector.func_74838_a((String)str);
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.mode") + ": " + preDGreen + str + rst);
        } else {
            str = this.isToolPowered(stack) ? "enderutilities.tooltip.item.fast" : "enderutilities.tooltip.item.normal";
            str = StatCollector.func_74838_a((String)str);
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.endertool.digmode") + ": " + preDGreen + str + rst);
        }
        str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.endercore") + ": ";
        if (coreTier >= 0) {
            String coreType = coreTier == 0 ? "enderutilities.tooltip.item.basic" : (coreTier == 1 ? "enderutilities.tooltip.item.enhanced" : "enderutilities.tooltip.item.advanced");
            coreType = StatCollector.func_74838_a((String)coreType);
            str = str + preDGreen + coreType + rst + " (" + preBlue + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.tier") + " " + (coreTier + 1) + rst + ")";
        } else {
            String preRed = EnumChatFormatting.RED.toString();
            str = str + preRed + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.none") + rst;
        }
        list.add(str);
        if (linkCrystalStack != null && linkCrystalStack.func_77973_b() instanceof ItemLinkCrystal) {
            String preWhiteIta = EnumChatFormatting.WHITE.toString() + EnumChatFormatting.ITALIC.toString();
            if (NBTHelperTarget.itemHasTargetTag(linkCrystalStack)) {
                ((ItemLinkCrystal)linkCrystalStack.func_77973_b()).addInformationSelective(linkCrystalStack, player, list, advancedTooltips, verbose);
            } else {
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.notargetset"));
            }
            int num = UtilItemModular.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            int sel = UtilItemModular.getClampedModuleSelection(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL) + 1;
            String dName = linkCrystalStack.func_82837_s() ? preWhiteIta + linkCrystalStack.func_82833_r() + rst + " " : "";
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selectedlinkcrystal.short") + String.format(" %s(%s%d%s / %s%d%s)", dName, preBlue, sel, rst, preBlue, num, rst));
        } else {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.nolinkcrystals"));
        }
        if (capacitorStack != null && capacitorStack.func_77973_b() instanceof ItemEnderCapacitor) {
            ((ItemEnderCapacitor)capacitorStack.func_77973_b()).addInformationSelective(capacitorStack, player, list, advancedTooltips, verbose);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advancedTooltips) {
        ArrayList<String> tmpList = new ArrayList<String>();
        boolean verbose = EnderUtilities.proxy.isShiftKeyDown();
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, null, false);
        if (nbt != null && nbt.func_74767_n("AddTooltips") && !nbt.func_74764_b("ench") && !nbt.func_74764_b("Items")) {
            this.addTooltips(stack, tmpList, verbose);
            if (!verbose && tmpList.size() > 1) {
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.holdshiftfordescription"));
            } else {
                list.addAll(tmpList);
            }
            return;
        }
        tmpList.clear();
        this.addInformationSelective(stack, player, tmpList, advancedTooltips, true);
        if (!verbose && tmpList.size() > 2) {
            tmpList.clear();
            this.addInformationSelective(stack, player, tmpList, advancedTooltips, false);
            list.add(tmpList.get(0));
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.holdshift"));
        } else {
            list.addAll(tmpList);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        ItemEnderUtilities.addTooltips(this.func_77667_c(stack) + ".tooltips", list, verbose);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        if (!Configs.disableItemEnderTools.getBoolean(false)) {
            for (int i = 0; i <= 3; ++i) {
                ItemStack stack = new ItemStack((Item)this, 1, 0);
                this.setToolType(stack, ToolType.valueOf(i));
                stack.func_77978_p().func_74757_a("AddTooltips", true);
                list.add(stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 5;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A() + "." + "enderpickaxe" + ".head.1");
        this.iconEmpty = iconRegister.func_94245_a(ReferenceTextures.getItemTextureName("empty"));
        this.parts = new String[]{"rod.1", "head.1", "head.2", "head.3", "head.1.glow", "head.2.glow", "head.3.glow", "head.1.broken", "head.2.broken", "head.3.broken", "head.1.glow.broken", "head.2.glow.broken", "head.3.glow.broken", "core.1", "core.2", "core.3", "capacitor.1", "capacitor.2", "capacitor.3", "linkcrystal.1", "linkcrystal.2"};
        this.iconArray = new IIcon[this.parts.length * 4];
        String prefix = this.func_111208_A() + ".";
        for (ToolType type : ToolType.values()) {
            int id = type.getId();
            int start = id * this.parts.length;
            for (int j = 0; id >= 0 && j < this.parts.length && start + j < this.iconArray.length; ++j) {
                this.iconArray[start + j] = iconRegister.func_94245_a(prefix + type.getName() + "." + this.parts[j]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        if (stack == null) {
            return this.field_77791_bV;
        }
        ToolType type = this.getToolType(stack);
        if (type.equals(ToolType.INVALID)) {
            return this.field_77791_bV;
        }
        int i = type.getId() * this.parts.length;
        int tier = 0;
        switch (renderPass) {
            case 0: {
                break;
            }
            case 1: {
                i += this.getToolModeByName(stack, "DropsMode") + 1;
                if (this.getToolModeByName(stack, "Powered") == 1) {
                    i += 3;
                }
                if (!this.isToolBroken(stack)) break;
                i += 6;
                break;
            }
            case 2: {
                tier = this.getMaxModuleTier(stack, ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE);
                if (tier >= 0) {
                    i += tier + 13;
                    break;
                }
                return this.iconEmpty;
            }
            case 3: {
                tier = this.getMaxModuleTier(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR);
                if (tier >= 0) {
                    i += tier + 16;
                    break;
                }
                return this.iconEmpty;
            }
            case 4: {
                ItemStack lcStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                tier = lcStack != null && lcStack.func_77973_b() instanceof ItemLinkCrystal ? ((ItemLinkCrystal)lcStack.func_77973_b()).getModuleTier(lcStack) : this.getMaxModuleTier(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                if (tier >= 0) {
                    i += tier + 19;
                    break;
                }
                return this.iconEmpty;
            }
            default: {
                return this.iconEmpty;
            }
        }
        if (i < 0 || i >= this.iconArray.length) {
            return this.iconEmpty;
        }
        return this.iconArray[i];
    }

    public static enum ToolType {
        PICKAXE(0, "pickaxe", "enderpickaxe", 2.0f),
        AXE(1, "axe", "enderaxe", 3.0f),
        SHOVEL(2, "shovel", "endershovel", 1.0f),
        HOE(3, "hoe", "enderhoe", 0.0f),
        INVALID(-1, "null", "null", 0.0f);

        private final int id;
        private final String typeString;
        private final String name;
        private final float attackDamage;
        private static final Map<Integer, ToolType> mapInt;
        private static final Map<String, ToolType> mapType;

        private ToolType(int id, String type, String name, float attackDamage) {
            this.id = id;
            this.typeString = type;
            this.name = name;
            this.attackDamage = attackDamage;
        }

        public int getId() {
            return this.id;
        }

        public String getTypeString() {
            return this.typeString;
        }

        public String getName() {
            return this.name;
        }

        public float getAttackDamage() {
            return this.attackDamage;
        }

        public boolean equals(ToolType other) {
            return this.id == other.getId();
        }

        public static ToolType valueOf(int id) {
            ToolType type = mapInt.get(id);
            if (type != null) {
                return type;
            }
            return INVALID;
        }

        public static ToolType valueOfType(String typeName) {
            ToolType type = mapType.get(typeName);
            if (type != null) {
                return type;
            }
            return INVALID;
        }

        static {
            mapInt = new HashMap<Integer, ToolType>();
            mapType = new HashMap<String, ToolType>();
            for (ToolType type : ToolType.values()) {
                mapInt.put(type.getId(), type);
                mapType.put(type.getTypeString(), type);
            }
        }
    }
}

