/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.part;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemEnderPart
extends ItemModule {
    public static final int MEMORY_CARD_TYPE_MISC = 0;
    public static final int MEMORY_CARD_TYPE_ITEMS_6B = 6;
    public static final int MEMORY_CARD_TYPE_ITEMS_8B = 8;
    public static final int MEMORY_CARD_TYPE_ITEMS_10B = 10;
    public static final int MEMORY_CARD_TYPE_ITEMS_12B = 12;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] slotBackgrounds;

    public ItemEnderPart() {
        this.func_77625_d(64);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("enderpart");
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77960_j();
        switch (damage) {
            case 0: 
            case 1: 
            case 2: {
                return super.func_77658_a() + "." + "enderalloy" + "." + damage;
            }
            case 10: 
            case 11: 
            case 12: {
                return super.func_77658_a() + "." + "endercore" + "." + (damage - 10) + ".inactive";
            }
            case 15: 
            case 16: 
            case 17: {
                return super.func_77658_a() + "." + "endercore" + "." + (damage - 15) + ".active";
            }
            case 20: {
                return super.func_77658_a() + "." + "enderstick";
            }
            case 21: {
                return super.func_77658_a() + "." + "enderrope";
            }
            case 40: {
                return super.func_77658_a() + "." + "enderrelic";
            }
            case 45: {
                return super.func_77658_a() + "." + "mobpersistence";
            }
            case 50: {
                return super.func_77658_a() + "." + "memorycard.misc";
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return super.func_77658_a() + "." + "memorycard.items" + "." + (damage - 51);
            }
        }
        return super.func_77658_a();
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        if (stack != null && stack.func_77960_j() == 40 && EntityUtils.spawnEnderCrystal(world, x, y, z)) {
            --stack.field_77994_a;
            return true;
        }
        return false;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase livingBase) {
        if (stack != null && this.getModuleType(stack).equals(ItemModule.ModuleType.TYPE_MOBPERSISTENCE) && livingBase instanceof EntityLiving && EntityUtils.applyMobPersistence((EntityLiving)livingBase)) {
            --stack.field_77994_a;
            return true;
        }
        return false;
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        String preWh = EnumChatFormatting.WHITE.toString();
        String preRed = EnumChatFormatting.RED.toString();
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
        String strOwner = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.owner");
        NBTHelperPlayer ownerData = NBTHelperPlayer.getPlayerDataFromItem(stack);
        if (ownerData != null && !ownerData.canAccess(player)) {
            list.add(String.format("%s: %s%s%s - %s%s%s", strOwner, preWh, ownerData.playerName, rst, preRed, StatCollector.func_74838_a((String)"enderutilities.tooltip.item.private"), rst));
            return;
        }
        int damage = stack.func_77960_j();
        NBTTagCompound nbt = stack.func_77978_p();
        if (damage >= 50 && damage <= 54 && (nbt == null || nbt.func_82582_d())) {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.memorycard.nodata"));
            return;
        }
        if (damage == 50) {
            ArrayList<String> listDataTypes = new ArrayList<String>();
            for (String key : nbt.func_150296_c()) {
                if (key == null || key.equals("display") || key.equals("RepairCost")) continue;
                listDataTypes.add("  " + key);
            }
            if (listDataTypes.size() > 0) {
                String str1 = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.memorycard.datatypecount.1");
                String str2 = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.memorycard.datatypecount.2");
                list.add(String.format("%s %d %s", str1, listDataTypes.size(), str2));
                list.addAll(listDataTypes);
            } else {
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.memorycard.nodata"));
            }
        } else if (damage >= 51 && damage <= 54) {
            ArrayList<String> lines = new ArrayList<String>();
            int itemCount = UtilItemModular.getFormattedItemListFromContainerItem(stack, lines, 20);
            if (lines.size() > 0) {
                NBTTagList tagList = NBTUtils.getStoredItemsList(stack, false);
                int stackCount = tagList != null ? tagList.func_74745_c() : 0;
                String str1 = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.memorycard.items.stackcount.1");
                String str2 = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.memorycard.items.stackcount.2");
                String str3 = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.memorycard.items.stackcount.3");
                list.add(String.format("%s %d %s %d %s", str1, stackCount, str2, itemCount, str3));
                list.addAll(lines);
            } else if (damage != 50) {
                list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.memorycard.unknowndata"));
            }
        }
        if (ownerData != null) {
            String mode = ownerData.isPublic ? StatCollector.func_74838_a((String)"enderutilities.tooltip.item.public") : StatCollector.func_74838_a((String)"enderutilities.tooltip.item.private");
            String modeColor = ownerData.isPublic ? EnumChatFormatting.GREEN.toString() : preRed;
            list.add(String.format("%s: %s%s%s - %s%s%s", strOwner, preWh, ownerData.playerName, rst, modeColor, mode, rst));
        }
    }

    public void activateEnderCore(ItemStack stack) {
        if (stack != null && stack.func_77960_j() >= 10 && stack.func_77960_j() <= 12) {
            stack.func_77964_b(stack.func_77960_j() + 5);
        }
    }

    @Override
    public ItemModule.ModuleType getModuleType(ItemStack stack) {
        if (stack.func_77960_j() >= 10 && stack.func_77960_j() <= 12) {
            return ItemModule.ModuleType.TYPE_ENDERCORE_INACTIVE;
        }
        if (stack.func_77960_j() >= 15 && stack.func_77960_j() <= 17) {
            return ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE;
        }
        if (stack.func_77960_j() == 45) {
            return ItemModule.ModuleType.TYPE_MOBPERSISTENCE;
        }
        if (stack.func_77960_j() >= 50 && stack.func_77960_j() <= 54) {
            return ItemModule.ModuleType.TYPE_MEMORY_CARD;
        }
        return ItemModule.ModuleType.TYPE_INVALID;
    }

    @Override
    public int getModuleTier(ItemStack stack) {
        if (this.getModuleType(stack).equals(ItemModule.ModuleType.TYPE_ENDERCORE_INACTIVE)) {
            return stack.func_77960_j() - 10;
        }
        if (this.getModuleType(stack).equals(ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE)) {
            return stack.func_77960_j() - 15;
        }
        if (this.getModuleType(stack).equals(ItemModule.ModuleType.TYPE_MOBPERSISTENCE)) {
            return 0;
        }
        if (stack.func_77960_j() == 50) {
            return 0;
        }
        if (this.getModuleType(stack).equals(ItemModule.ModuleType.TYPE_MEMORY_CARD)) {
            int tier = stack.func_77960_j() - 51;
            switch (tier) {
                case 0: {
                    return 6;
                }
                case 1: {
                    return 8;
                }
                case 2: {
                    return 10;
                }
                case 3: {
                    return 12;
                }
            }
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        if (!Configs.disableItemCraftingPart.getBoolean(false)) {
            int i;
            for (i = 0; i <= 2; ++i) {
                list.add(new ItemStack((Item)this, 1, i));
            }
            for (i = 10; i <= 12; ++i) {
                list.add(new ItemStack((Item)this, 1, i));
            }
            for (i = 15; i <= 17; ++i) {
                list.add(new ItemStack((Item)this, 1, i));
            }
            list.add(new ItemStack((Item)this, 1, 20));
            list.add(new ItemStack((Item)this, 1, 21));
            list.add(new ItemStack((Item)this, 1, 40));
            list.add(new ItemStack((Item)this, 1, 45));
            list.add(new ItemStack((Item)this, 1, 50));
            list.add(new ItemStack((Item)this, 1, 51));
            list.add(new ItemStack((Item)this, 1, 52));
            list.add(new ItemStack((Item)this, 1, 53));
            list.add(new ItemStack((Item)this, 1, 54));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        int j;
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A() + "." + "enderalloy" + ".0");
        this.iconArray = new IIcon[18];
        int i = 0;
        for (j = 0; j < 3; ++j) {
            this.iconArray[i] = iconRegister.func_94245_a(this.func_111208_A() + "." + "enderalloy" + "." + j);
            ++i;
        }
        for (j = 0; j < 3; ++j) {
            this.iconArray[i] = iconRegister.func_94245_a(this.func_111208_A() + "." + "endercore" + "." + j + ".inactive");
            ++i;
        }
        for (j = 0; j < 3; ++j) {
            this.iconArray[i] = iconRegister.func_94245_a(this.func_111208_A() + "." + "endercore" + "." + j + ".active");
            ++i;
        }
        this.iconArray[i++] = iconRegister.func_94245_a(this.func_111208_A() + "." + "enderstick");
        this.iconArray[i++] = iconRegister.func_94245_a(this.func_111208_A() + "." + "enderrope");
        this.iconArray[i++] = iconRegister.func_94245_a(this.func_111208_A() + "." + "enderrelic");
        this.iconArray[i++] = iconRegister.func_94245_a(this.func_111208_A() + "." + "mobpersistence");
        this.iconArray[i++] = iconRegister.func_94245_a(this.func_111208_A() + "." + "memorycard.misc");
        this.iconArray[i++] = iconRegister.func_94245_a(this.func_111208_A() + "." + "memorycard.items" + ".6b");
        this.iconArray[i++] = iconRegister.func_94245_a(this.func_111208_A() + "." + "memorycard.items" + ".8b");
        this.iconArray[i++] = iconRegister.func_94245_a(this.func_111208_A() + "." + "memorycard.items" + ".10b");
        this.iconArray[i++] = iconRegister.func_94245_a(this.func_111208_A() + "." + "memorycard.items" + ".12b");
        this.slotBackgrounds = new IIcon[3];
        this.slotBackgrounds[0] = iconRegister.func_94245_a(ReferenceTextures.getSlotBackgroundName("endercore"));
        this.slotBackgrounds[1] = iconRegister.func_94245_a(ReferenceTextures.getSlotBackgroundName("mobpersistence"));
        this.slotBackgrounds[2] = iconRegister.func_94245_a(ReferenceTextures.getSlotBackgroundName("memorycard"));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        if (damage >= 0 && damage <= 2) {
            return this.iconArray[damage];
        }
        if (damage >= 10 && damage <= 12) {
            return this.iconArray[damage - 7];
        }
        if (damage >= 15 && damage <= 17) {
            return this.iconArray[damage - 9];
        }
        if (damage == 20) {
            return this.iconArray[9];
        }
        if (damage == 21) {
            return this.iconArray[10];
        }
        if (damage == 40) {
            return this.iconArray[11];
        }
        if (damage == 45) {
            return this.iconArray[12];
        }
        if (damage >= 50 && damage <= 54) {
            return this.iconArray[damage - 37];
        }
        return this.field_77791_bV;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getGuiSlotBackgroundIconIndex(ItemModule.ModuleType moduleType) {
        if (ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE.equals(moduleType) || ItemModule.ModuleType.TYPE_ENDERCORE_ACTIVE.equals(moduleType)) {
            return this.slotBackgrounds[0];
        }
        if (ItemModule.ModuleType.TYPE_MOBPERSISTENCE.equals(moduleType)) {
            return this.slotBackgrounds[1];
        }
        if (ItemModule.ModuleType.TYPE_MEMORY_CARD.equals(moduleType)) {
            return this.slotBackgrounds[2];
        }
        return null;
    }
}

