/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.base;

import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.ILocationBound;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemLinkCrystal;
import fi.dy.masa.enderutilities.reference.ReferenceKeys;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.TooltipHelper;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperPlayer;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperTarget;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemLocationBound
extends ItemEnderUtilities
implements ILocationBound,
IKeyBound {
    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player != null && player.func_70093_af()) {
            if (!world.field_72995_K) {
                boolean adjustPosHit = stack.func_77973_b() == EnderUtilitiesItems.linkCrystal && ((ItemLinkCrystal)stack.func_77973_b()).getModuleTier(stack) == 0;
                this.setTarget(stack, player, x, y, z, side, hitX, hitY, hitZ, adjustPosHit, false);
            }
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && player != null && player.func_70093_af()) {
            this.setTarget(stack, player, true);
        }
        return stack;
    }

    @Override
    public String getTargetDisplayName(ItemStack stack) {
        NBTHelperTarget target = NBTHelperTarget.getTargetFromItem(stack);
        return target != null ? NBTHelperTarget.getTargetBlockDisplayName(target) : null;
    }

    public String func_77653_i(ItemStack stack) {
        if (stack.func_82837_s()) {
            NBTTagCompound tag = stack.field_77990_d.func_74775_l("display");
            return EnumChatFormatting.ITALIC.toString() + tag.func_74779_i("Name") + EnumChatFormatting.RESET.toString();
        }
        String targetName = this.getTargetDisplayName(stack);
        if (targetName != null && targetName.length() > 0) {
            String pre = EnumChatFormatting.GREEN.toString();
            String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.WHITE.toString();
            return super.func_77653_i(stack) + " " + pre + targetName + rst;
        }
        return super.func_77653_i(stack);
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        NBTHelperPlayer playerData;
        NBTHelperTarget target = this.getTarget(stack);
        if (target == null) {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.notargetset"));
            return;
        }
        String preBlue = EnumChatFormatting.BLUE.toString();
        String preDGreen = EnumChatFormatting.DARK_GREEN.toString();
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
        if (NBTHelperPlayer.canAccessItem(stack, player)) {
            String s;
            Block block;
            ItemStack targetStack;
            String dimName = TooltipHelper.getDimensionName(target.dimension, target.dimensionName, false);
            boolean showBlock = false;
            String blockName = "";
            Item item = stack.func_77973_b();
            if (item instanceof IModule && ((IModule)item).getModuleType(stack).equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) && ((IModule)item).getModuleTier(stack) == 1 && (targetStack = new ItemStack(block = Block.func_149684_b((String)target.blockName), 1, block.func_149692_a(target.blockMeta & 0xF))) != null && targetStack.func_77973_b() != null) {
                blockName = targetStack.func_82833_r();
                showBlock = true;
            }
            if (verbose) {
                s = StatCollector.func_74838_a((String)"enderutilities.tooltip.dimension") + ": " + preBlue + target.dimension + rst;
                if (dimName.length() > 0) {
                    s = s + " - " + preDGreen + dimName + rst;
                }
                list.add(s);
                list.add(String.format("x: %s%.2f%s y: %s%.2f%s z: %s%.2f%s", preBlue, target.dPosX, rst, preBlue, target.dPosY, rst, preBlue, target.dPosZ, rst));
                if (showBlock) {
                    list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.target") + ": " + preDGreen + blockName + rst);
                    if (advancedTooltips) {
                        list.add(String.format("%s meta: %d Side: %s (%d)", target.blockName, target.blockMeta, ForgeDirection.getOrientation((int)target.blockFace).toString(), target.blockFace));
                    }
                }
            } else {
                s = preDGreen + dimName + rst;
                if (dimName.length() == 0) {
                    s = StatCollector.func_74838_a((String)"enderutilities.tooltip.dimension.compact") + ": " + preBlue + target.dimension + rst;
                }
                if (showBlock) {
                    list.add(String.format("%s%s%s - %s @ %s%.2f%s %s%.2f%s %s%.2f%s", preDGreen, blockName, rst, s, preBlue, target.dPosX, rst, preBlue, target.dPosY, rst, preBlue, target.dPosZ, rst));
                } else {
                    list.add(String.format("%s @ %s%.2f%s %s%.2f%s %s%.2f%s", s, preBlue, target.dPosX, rst, preBlue, target.dPosY, rst, preBlue, target.dPosZ, rst));
                }
            }
        }
        if ((playerData = NBTHelperPlayer.getPlayerDataFromItem(stack)) == null) {
            return;
        }
        String strPublic = "";
        strPublic = playerData.isPublic ? EnumChatFormatting.GREEN.toString() + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.public") + rst : EnumChatFormatting.RED.toString() + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.private") + rst;
        if (verbose) {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.mode") + ": " + strPublic);
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.owner") + ": " + preDGreen + playerData.playerName + rst);
        } else {
            list.add(strPublic + " - " + preDGreen + playerData.playerName + rst);
        }
    }

    public void changePrivacyMode(ItemStack stack, EntityPlayer player) {
        if (!NBTHelperPlayer.itemHasPlayerTag(stack)) {
            NBTHelperPlayer.writePlayerTagToItem(stack, player, false);
        } else {
            NBTHelperPlayer data = NBTHelperPlayer.getPlayerDataFromItem(stack);
            if (data != null && data.isOwner(player)) {
                data.isPublic = !data.isPublic;
                data.writeToItem(stack);
            }
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (stack == null || player == null || ReferenceKeys.getBaseKey(key) != 1) {
            return;
        }
        if (ReferenceKeys.keypressContainsAlt(key) && !ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsControl(key)) {
            this.changePrivacyMode(stack, player);
        } else if (ReferenceKeys.keypressContainsAlt(key) && ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsControl(key)) {
            this.setTarget(stack, player, true);
        }
    }

    @Override
    public NBTHelperTarget getTarget(ItemStack stack) {
        return NBTHelperTarget.getTargetFromItem(stack);
    }

    public void setTarget(ItemStack stack, EntityPlayer player, boolean storeRotation) {
        int x = (int)player.field_70165_t;
        int y = (int)player.field_70163_u;
        int z = (int)player.field_70161_v;
        double hitX = player.field_70165_t - (double)x;
        double hitY = player.field_70163_u - (double)y;
        double hitZ = player.field_70161_v - (double)z;
        boolean adjustPosHit = stack.func_77973_b() == EnderUtilitiesItems.linkCrystal && ((ItemLinkCrystal)stack.func_77973_b()).getModuleTier(stack) == 0;
        this.setTarget(stack, player, x, y, z, ForgeDirection.UP.ordinal(), hitX, hitY, hitZ, adjustPosHit, storeRotation);
    }

    @Override
    public void setTarget(ItemStack stack, EntityPlayer player, int x, int y, int z, int side, double hitX, double hitY, double hitZ, boolean doHitOffset, boolean storeRotation) {
        if (!NBTHelperPlayer.canAccessItem(stack, player)) {
            return;
        }
        NBTHelperTarget.writeTargetTagToItem(stack, x, y, z, player.field_71093_bK, side, hitX, hitY, hitZ, doHitOffset, player.field_70177_z, player.field_70125_A, storeRotation);
        if (!NBTHelperPlayer.itemHasPlayerTag(stack)) {
            NBTHelperPlayer.writePlayerTagToItem(stack, player, true);
        }
    }
}

