/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.event.PlayerItemPickupEvent;
import fi.dy.masa.enderutilities.inventory.ContainerHandyBag;
import fi.dy.masa.enderutilities.inventory.InventoryItemModular;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemInventoryModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderPart;
import fi.dy.masa.enderutilities.reference.ReferenceKeys;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;

public class ItemHandyBag
extends ItemInventoryModular {
    public static final int MODE_RESTOCK_ENABLED = 1;
    public static final int MODE_PICKUP_MATCHING = 1;
    public static final int MODE_PICKUP_ALL = 2;
    public static final int DAMAGE_TIER_1 = 0;
    public static final int DAMAGE_TIER_2 = 1;
    public static final int INV_SIZE_TIER_1 = 27;
    public static final int INV_SIZE_TIER_2 = 55;
    public static final int GUI_ACTION_SELECT_MODULE = 0;
    public static final int GUI_ACTION_MOVE_ITEMS = 1;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemHandyBag() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("handybag");
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrent) {
        super.func_77663_a(stack, world, entity, slot, isCurrent);
        this.restockPlayerInventory(stack, world, entity);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return this.tryMoveItems(stack, world, player, x, y, z, side);
        }
        return super.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        NBTUtils.getUUIDFromItemStack(stack, "UUID", true);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + stack.func_77960_j();
    }

    public String func_77653_i(ItemStack stack) {
        ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
        if (moduleStack != null && moduleStack.func_77978_p() != null) {
            String itemName = super.func_77653_i(stack);
            String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.WHITE.toString();
            if (moduleStack.func_82837_s()) {
                String pre = EnumChatFormatting.GREEN.toString() + EnumChatFormatting.ITALIC.toString();
                if (itemName.length() >= 14) {
                    return EUStringUtils.getInitialsWithDots(itemName) + " " + pre + moduleStack.func_82833_r() + rst;
                }
                return itemName + " " + pre + moduleStack.func_82833_r() + rst;
            }
            return itemName;
        }
        return super.func_77653_i(stack);
    }

    @Override
    public void addInformationSelective(ItemStack containerStack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        if (containerStack.func_77978_p() == null) {
            return;
        }
        String preGreen = EnumChatFormatting.GREEN.toString();
        String preYellow = EnumChatFormatting.YELLOW.toString();
        String preRed = EnumChatFormatting.RED.toString();
        String preWhite = EnumChatFormatting.WHITE.toString();
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
        String strPickupMode = StatCollector.func_74838_a((String)("enderutilities.tooltip.item.pickupmode" + (verbose ? "" : ".short"))) + ": ";
        String strRestockMode = StatCollector.func_74838_a((String)("enderutilities.tooltip.item.restockmode" + (verbose ? "" : ".short"))) + ": ";
        int mode = this.getModeByName(containerStack, "PickupMode");
        strPickupMode = mode == 0 ? strPickupMode + preRed + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.disabled") + rst : (mode == 1 ? strPickupMode + preYellow + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.matching") + rst : strPickupMode + preGreen + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.all") + rst);
        mode = this.getModeByName(containerStack, "RestockMode");
        strRestockMode = mode == 0 ? strRestockMode + preRed + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.disabled") + rst : strRestockMode + preGreen + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.enabled") + rst;
        if (verbose) {
            list.add(strPickupMode);
            list.add(strRestockMode);
        } else {
            list.add(strPickupMode + " / " + strRestockMode);
        }
        int installed = this.getInstalledModuleCount(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
        if (installed > 0) {
            int slotNum = UtilItemModular.getStoredModuleSelection(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
            String preBlue = EnumChatFormatting.BLUE.toString();
            String preWhiteIta = preWhite + EnumChatFormatting.ITALIC.toString();
            String strShort = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selectedmemorycard.short");
            ItemStack moduleStack = this.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
            int max = this.getMaxModules(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
            if (moduleStack != null && moduleStack.func_77973_b() == EnderUtilitiesItems.enderPart) {
                String dName = moduleStack.func_82837_s() ? preWhiteIta + moduleStack.func_82833_r() + rst + " " : "";
                list.add(String.format("%s %s(%s%d%s / %s%d%s)", strShort, dName, preBlue, slotNum + 1, rst, preBlue, max, rst));
                ((ItemEnderPart)moduleStack.func_77973_b()).addInformationSelective(moduleStack, player, list, advancedTooltips, false);
                return;
            }
            String strNo = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selectedmemorycard.notinstalled");
            list.add(String.format("%s %s (%s%d%s / %s%d%s)", strShort, strNo, preBlue, slotNum + 1, rst, preBlue, max, rst));
        } else {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.nomemorycards"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        ItemHandyBag.addTooltips(super.func_77667_c(stack) + ".tooltips", list, verbose);
    }

    public void restockPlayerInventory(ItemStack stack, World world, Entity entity) {
        if (!world.field_72995_K && entity instanceof EntityPlayer && this.getModeByName(stack, "RestockMode") == 1) {
            EntityPlayer player;
            InventoryItemModular inv = player.field_71070_bA instanceof ContainerHandyBag ? ((ContainerHandyBag)player.field_71070_bA).inventoryItemModular : new InventoryItemModular(stack, player, ItemModule.ModuleType.TYPE_MEMORY_CARD);
            if (!inv.func_70300_a(player = (EntityPlayer)entity)) {
                return;
            }
            InventoryUtils.fillStacksOfMatchingItems(inv, (IInventory)player.field_71071_by);
            player.field_71070_bA.func_75142_b();
            player.field_71071_by.func_70296_d();
        }
    }

    public boolean tryMoveItems(ItemStack stack, World world, EntityPlayer player, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!world.field_72995_K && te != null && te instanceof IInventory) {
            InventoryItemModular inv = new InventoryItemModular(stack, player, ItemModule.ModuleType.TYPE_MEMORY_CARD);
            if (!inv.func_70300_a(player)) {
                return false;
            }
            int mode = this.getModeByName(stack, "RestockMode");
            if (mode == 1) {
                InventoryUtils.tryMoveAllItems(inv, (IInventory)te, 0, side);
                player.field_70170_p.func_72956_a((Entity)player, "mob.endermen.portal", 0.2f, 1.8f);
                return true;
            }
            mode = this.getModeByName(stack, "PickupMode");
            if (mode == 1) {
                InventoryUtils.tryMoveMatchingItems((IInventory)te, inv, side, 0, true);
                player.field_70170_p.func_72956_a((Entity)player, "mob.endermen.portal", 0.2f, 1.8f);
                return true;
            }
            if (mode == 2) {
                InventoryUtils.tryMoveAllItems((IInventory)te, inv, side, 0, true);
                player.field_70170_p.func_72956_a((Entity)player, "mob.endermen.portal", 0.2f, 1.8f);
                return true;
            }
        }
        return false;
    }

    public static boolean onItemPickupEvent(PlayerItemPickupEvent event) {
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return true;
        }
        boolean ret = true;
        boolean pickedUp = false;
        EntityPlayer player = event.entityPlayer;
        List<Integer> bagSlots = InventoryUtils.getSlotNumbersOfMatchingItems((IInventory)player.field_71071_by, EnderUtilitiesItems.handyBag);
        InventoryItemModular bagInv = null;
        InventoryItemModular openBagInv = null;
        ItemStack containerStack = null;
        if (player.field_71070_bA instanceof ContainerHandyBag) {
            openBagInv = ((ContainerHandyBag)player.field_71070_bA).inventoryItemModular;
            containerStack = openBagInv.getModularItemStack();
        }
        Iterator<ItemStack> iter = event.drops.iterator();
        block0: while (iter.hasNext()) {
            ItemStack stack = iter.next();
            if (stack == null) continue;
            if (InventoryUtils.tryInsertItemStackToExistingStacksInInventory((IInventory)player.field_71071_by, stack, 0, false) == null) {
                iter.remove();
                pickedUp = true;
                continue;
            }
            for (int slot : bagSlots) {
                byte pickupMode;
                ItemStack bagStack = player.field_71071_by.func_70301_a(slot);
                if (bagStack == null || bagStack.func_77973_b() != EnderUtilitiesItems.handyBag || !ItemHandyBag.bagIsOpenable(bagStack) || !(bagInv = bagStack == containerStack ? openBagInv : new InventoryItemModular(bagStack, player, ItemModule.ModuleType.TYPE_MEMORY_CARD)).func_70300_a(player) || (pickupMode = NBTUtils.getByte(bagStack, "HandyBag", "PickupMode")) != 2 && (pickupMode != 1 || InventoryUtils.getSlotOfFirstMatchingItemStack(bagInv, stack) == -1) || InventoryUtils.tryInsertItemStackToInventory(bagInv, stack, 0, true) != null) continue;
                iter.remove();
                pickedUp = true;
                continue block0;
            }
        }
        if (event.drops.isEmpty()) {
            event.setCanceled(true);
            ret = false;
        }
        if (pickedUp) {
            player.field_70170_p.func_72956_a((Entity)player, "random.pop", 0.2f, ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        return ret;
    }

    public static boolean onEntityItemPickupEvent(EntityItemPickupEvent event) {
        if (event.entityPlayer.field_70170_p.field_72995_K || event.item.field_70128_L || event.item.func_92059_d() == null || event.item.func_92059_d().func_77973_b() == null) {
            return true;
        }
        int origStackSize = event.item.func_92059_d().field_77994_a;
        EntityPlayer player = event.entityPlayer;
        if (InventoryUtils.tryInsertItemStackToExistingStacksInInventory((IInventory)player.field_71071_by, event.item.func_92059_d(), 0, false) == null) {
            event.setCanceled(true);
            FMLCommonHandler.instance().firePlayerItemPickupEvent(player, event.item);
            player.field_70170_p.func_72956_a((Entity)player, "random.pop", 0.2f, ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.func_71001_a((Entity)event.item, origStackSize);
            return false;
        }
        boolean ret = true;
        InventoryItemModular bagInv = null;
        InventoryItemModular openBagInv = null;
        ItemStack containerStack = null;
        if (player.field_71070_bA instanceof ContainerHandyBag) {
            openBagInv = ((ContainerHandyBag)player.field_71070_bA).inventoryItemModular;
            containerStack = openBagInv.getModularItemStack();
        }
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingItems((IInventory)player.field_71071_by, EnderUtilitiesItems.handyBag);
        for (int slot : slots) {
            ItemStack bagStack = player.field_71071_by.func_70301_a(slot);
            if (bagStack == null || bagStack.func_77973_b() != EnderUtilitiesItems.handyBag || !ItemHandyBag.bagIsOpenable(bagStack)) continue;
            bagInv = bagStack == containerStack ? openBagInv : new InventoryItemModular(bagStack, player, ItemModule.ModuleType.TYPE_MEMORY_CARD);
            byte pickupMode = NBTUtils.getByte(bagStack, "HandyBag", "PickupMode");
            if (pickupMode != 2 && (pickupMode != 1 || InventoryUtils.getSlotOfFirstMatchingItemStack(bagInv, event.item.func_92059_d()) == -1) || InventoryUtils.tryInsertItemStackToInventory(bagInv, event.item.func_92059_d(), 0, true) != null) continue;
            event.item.func_70106_y();
            event.setCanceled(true);
            ret = false;
            break;
        }
        if (event.item.func_92059_d().field_77994_a != origStackSize) {
            FMLCommonHandler.instance().firePlayerItemPickupEvent(player, event.item);
            player.field_70170_p.func_72956_a((Entity)player, "random.pop", 0.2f, ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.func_71001_a((Entity)event.item, origStackSize);
        }
        return ret;
    }

    public static boolean bagIsOpenable(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return true;
        }
        return !stack.func_77978_p().func_74775_l("HandyBag").func_74767_n("DisableOpen");
    }

    public static int getSlotContainingOpenableBag(EntityPlayer player) {
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingItems((IInventory)player.field_71071_by, EnderUtilitiesItems.handyBag);
        for (int slot : slots) {
            if (!ItemHandyBag.bagIsOpenable(player.field_71071_by.func_70301_a(slot))) continue;
            return slot;
        }
        return -1;
    }

    public static ItemStack getOpenableBag(EntityPlayer player) {
        int slotNum = ItemHandyBag.getSlotContainingOpenableBag(player);
        return slotNum != -1 ? player.field_71071_by.func_70301_a(slotNum) : null;
    }

    @Override
    public int getSizeModuleInventory(ItemStack containerStack) {
        return this.getMaxModules(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
    }

    @Override
    public int getSizeInventory(ItemStack containerStack) {
        return containerStack.func_77960_j() == 1 ? 55 : 27;
    }

    @Override
    public int getInventoryStackLimit(ItemStack containerStack) {
        int tier;
        ItemStack moduleStack = this.getSelectedModuleStack(containerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
        if (moduleStack != null && moduleStack.func_77973_b() instanceof IModule && (tier = ((IModule)moduleStack.func_77973_b()).getModuleTier(moduleStack)) >= 6 && tier <= 12) {
            return (int)Math.pow(2.0, tier);
        }
        return 0;
    }

    public static void performGuiAction(EntityPlayer player, int action, int element) {
        if (player.field_71070_bA instanceof ContainerHandyBag) {
            ContainerHandyBag container = (ContainerHandyBag)player.field_71070_bA;
            InventoryItemModular inv = container.inventoryItemModular;
            ItemStack stack = inv.getModularItemStack();
            if (stack != null && stack.func_77973_b() == EnderUtilitiesItems.handyBag) {
                int max = ((ItemHandyBag)stack.func_77973_b()).getMaxModules(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD);
                if (action == 0 && element >= 0 && element < max) {
                    UtilItemModular.setModuleSelection(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD, element);
                    inv.readFromContainerItemStack();
                } else if (action == 1 && element >= 0 && element <= 5) {
                    int bagMaxSlot = inv.func_70302_i_() - 1;
                    int playerMaxSlot = player.field_71071_by.func_70302_i_() - 5;
                    switch (element) {
                        case 0: {
                            InventoryUtils.tryMoveAllItemsWithinSlotRange((IInventory)player.field_71071_by, inv, 0, 0, 0, playerMaxSlot, 0, bagMaxSlot, true);
                            break;
                        }
                        case 1: {
                            InventoryUtils.tryMoveMatchingItemsWithinSlotRange((IInventory)player.field_71071_by, inv, 0, 0, 0, playerMaxSlot, 0, bagMaxSlot, true);
                            break;
                        }
                        case 2: {
                            InventoryUtils.leaveOneFullStackOfEveryItem((IInventory)player.field_71071_by, inv, false, false, true);
                            break;
                        }
                        case 3: {
                            InventoryUtils.fillStacksOfMatchingItemsWithinSlotRange(inv, (IInventory)player.field_71071_by, 0, 0, 0, bagMaxSlot, 0, playerMaxSlot, false);
                            break;
                        }
                        case 4: {
                            InventoryUtils.tryMoveMatchingItemsWithinSlotRange(inv, (IInventory)player.field_71071_by, 0, 0, 0, bagMaxSlot, 0, playerMaxSlot, false);
                            break;
                        }
                        case 5: {
                            InventoryUtils.tryMoveAllItemsWithinSlotRange(inv, (IInventory)player.field_71071_by, 0, 0, 0, bagMaxSlot, 0, playerMaxSlot, false);
                        }
                    }
                }
            }
        }
    }

    public int getModeByName(ItemStack stack, String name) {
        return NBTUtils.getByte(stack, "HandyBag", name);
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (ReferenceKeys.getBaseKey(key) != 1) {
            return;
        }
        if (ReferenceKeys.keypressContainsAlt(key) && !ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsControl(key)) {
            UtilItemModular.changePrivacyModeOnSelectedModuleAbs(stack, player, ItemModule.ModuleType.TYPE_MEMORY_CARD);
        } else if (!(ReferenceKeys.keypressContainsControl(key) || ReferenceKeys.keypressContainsShift(key) || ReferenceKeys.keypressContainsAlt(key))) {
            NBTUtils.cycleByteValue(stack, "HandyBag", "PickupMode", 2);
        } else if (!ReferenceKeys.keypressContainsControl(key) && ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            NBTUtils.toggleBoolean(stack, "HandyBag", "DisableOpen");
        } else if (!ReferenceKeys.keypressContainsControl(key) && ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key)) {
            NBTUtils.cycleByteValue(stack, "HandyBag", "RestockMode", 1);
        } else if (ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD, ReferenceKeys.keypressActionIsReversed(key) || ReferenceKeys.keypressContainsShift(key));
        }
    }

    @Override
    public boolean useAbsoluteModuleIndexing(ItemStack stack) {
        return true;
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 4;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        return moduleType.equals(ItemModule.ModuleType.TYPE_MEMORY_CARD) ? this.getMaxModules(containerStack) : 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        int tier;
        IModule imodule;
        if (moduleStack.func_77973_b() instanceof IModule && (imodule = (IModule)moduleStack.func_77973_b()).getModuleType(moduleStack).equals(ItemModule.ModuleType.TYPE_MEMORY_CARD) && (tier = imodule.getModuleTier(moduleStack)) >= 6 && tier <= 12) {
            return this.getMaxModules(containerStack);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        list.add(new ItemStack((Item)this, 1, 0));
        list.add(new ItemStack((Item)this, 1, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A() + ".0");
        this.iconArray = new IIcon[7];
        this.iconArray[0] = iconRegister.func_94245_a(this.func_111208_A() + ".0");
        this.iconArray[1] = iconRegister.func_94245_a(this.func_111208_A() + ".1");
        this.iconArray[2] = iconRegister.func_94245_a(ReferenceTextures.getItemTextureName("empty"));
        this.iconArray[3] = iconRegister.func_94245_a(this.func_111208_A() + ".overlay.locked");
        this.iconArray[4] = iconRegister.func_94245_a(this.func_111208_A() + ".overlay.pickup.matching");
        this.iconArray[5] = iconRegister.func_94245_a(this.func_111208_A() + ".overlay.pickup.all");
        this.iconArray[6] = iconRegister.func_94245_a(this.func_111208_A() + ".overlay.restock");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        switch (renderPass) {
            case 0: {
                int damage = stack.func_77960_j();
                return this.iconArray[damage <= 1 ? damage : 0];
            }
            case 1: {
                return ItemHandyBag.bagIsOpenable(stack) ? this.iconArray[2] : this.iconArray[3];
            }
            case 2: {
                int index = this.getModeByName(stack, "PickupMode");
                if (index == 1 || index == 2) {
                    return this.iconArray[index - 1 + 4];
                }
                return this.iconArray[2];
            }
            case 3: {
                return this.getModeByName(stack, "RestockMode") != 0 ? this.iconArray[6] : this.iconArray[2];
            }
        }
        return this.field_77791_bV;
    }
}

