/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.event.tasks.PlayerTaskScheduler;
import fi.dy.masa.enderutilities.event.tasks.TaskBuildersWand;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.reference.ReferenceKeys;
import fi.dy.masa.enderutilities.setup.Configs;
import fi.dy.masa.enderutilities.util.BlockInfo;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.BlockPosStateDist;
import fi.dy.masa.enderutilities.util.BlockUtils;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemBuildersWand
extends ItemLocationBoundModular {
    public static final int ENDER_CHARGE_COST = 10;
    public static final int MAX_BLOCKS = 6;
    public static final String WRAPPER_TAG_NAME = "BuildersWand";
    public static final String TAG_NAME_MODE = "Mode";
    public static final String TAG_NAME_CONFIGS = "Configs";
    public static final String TAG_NAME_CONFIG_PRE = "Mode_";
    public static final String TAG_NAME_DIMENSIONS = "Dim";
    public static final String TAG_NAME_BLOCKS = "Blocks";
    public static final String TAG_NAME_BLOCK_PRE = "Block_";
    public static final String TAG_NAME_BLOCK_SEL = "SelBlock";
    public static final String TAG_NAME_ALLOW_DIAGONALS = "Diag";
    public static final String TAG_NAME_GHOST_BLOCKS = "Ghost";
    public static final int BLOCK_TYPE_TARGETED = -1;
    public static final int BLOCK_TYPE_ADJACENT = -2;
    public static final boolean POS_START = true;
    public static final boolean POS_END = false;
    protected Map<UUID, Long> lastLeftClick = new HashMap<UUID, Long>();
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemBuildersWand() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77655_b("builderswand");
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        BlockPosEU pos = this.getPosition(stack, true);
        if (pos == null) {
            return super.func_77659_a(stack, world, player);
        }
        Mode mode = Mode.getMode(stack);
        if (!world.field_72995_K) {
            if (PlayerTaskScheduler.getInstance().hasTask(player, TaskBuildersWand.class)) {
                PlayerTaskScheduler.getInstance().removeTask(player, TaskBuildersWand.class);
                return stack;
            }
            if (mode != Mode.CUBE && mode != Mode.WALLS) {
                this.useWand(stack, world, player, pos);
                return stack;
            }
        }
        if ((mode == Mode.CUBE || mode == Mode.WALLS) && this.getPosition(stack, false) != null) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    @Override
    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            return super.func_77648_a(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
        }
        Mode mode = Mode.getMode(stack);
        if (mode == Mode.CUBE || mode == Mode.WALLS) {
            if (!world.field_72995_K && !player.func_70093_af()) {
                this.setPosition(stack, new BlockPosEU(x, y, z, player.field_71093_bK, side), false);
            }
            return true;
        }
        if (!(world.field_72995_K || player.func_70093_af() && ForgeDirection.getOrientation((int)side) == ForgeDirection.UP)) {
            return this.useWand(stack, world, player, new BlockPosEU(x, y, z, player.field_71093_bK, side));
        }
        return true;
    }

    public void onLeftClickBlock(EntityPlayer player, World world, ItemStack stack, int x, int y, int z, int dimension, int side) {
        if (world.field_72995_K) {
            return;
        }
        Long last = this.lastLeftClick.get(player.func_110124_au());
        if (last == null || world.func_82737_E() - last >= 4L) {
            if (!player.func_70093_af()) {
                this.setPosition(stack, new BlockPosEU(x, y, z, player.field_71093_bK, side), true);
            } else {
                this.setSelectedFixedBlockType(stack, world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
            }
        }
        this.lastLeftClick.put(player.func_110124_au(), world.func_82737_E());
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int itemInUseCount) {
        BlockPosEU pos;
        if (!world.field_72995_K && this.func_77626_a(stack) - itemInUseCount >= 20 && (pos = this.getPosition(stack, true)) != null) {
            this.useWand(stack, world, player, pos);
            player.field_70170_p.func_72956_a((Entity)player, "mob.endermen.portal", 0.4f, 0.7f);
        }
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return true;
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        String itemName = StatCollector.func_74838_a((String)(this.func_77667_c(stack) + ".name")).trim();
        if (stack.func_77978_p() == null) {
            return itemName;
        }
        String preBT = EnumChatFormatting.AQUA.toString();
        String preGreen = EnumChatFormatting.GREEN.toString();
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.WHITE.toString();
        if (itemName.length() >= 14) {
            itemName = EUStringUtils.getInitialsWithDots(itemName);
        }
        itemName = itemName + " M: " + preGreen + Mode.getMode(stack).getDisplayName() + rst;
        if (this.getAreaFlipped(stack)) {
            String strFlip = this.getAreaFlipAxis(stack, ForgeDirection.NORTH).toString().substring(0, 1);
            itemName = itemName + " F: " + preGreen + strFlip + rst;
        } else {
            itemName = itemName + " F: " + EnumChatFormatting.RED + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.no") + rst;
        }
        int sel = ItemBuildersWand.getSelectedBlockType(stack);
        if (sel >= 0) {
            ItemStack blockStack;
            BlockInfo blockInfo = ItemBuildersWand.getSelectedFixedBlockType(stack);
            if (blockInfo != null && (blockStack = new ItemStack(Block.func_149684_b((String)blockInfo.blockName), 1, blockInfo.meta)) != null && blockStack.func_77973_b() != null) {
                itemName = itemName + " B: " + preGreen + blockStack.func_82833_r() + rst;
            }
            itemName = itemName + " (" + (sel + 1) + "/" + 6 + ")";
        } else {
            String str = sel == -1 ? StatCollector.func_74838_a((String)"enderutilities.tooltip.item.blocktype.targeted") : StatCollector.func_74838_a((String)"enderutilities.tooltip.item.blocktype.adjacent");
            itemName = itemName + " B: " + preBT + str + rst;
        }
        return itemName;
    }

    @Override
    public void addInformationSelective(ItemStack stack, EntityPlayer player, List<String> list, boolean advancedTooltips, boolean verbose) {
        String str2;
        String str;
        if (stack.func_77978_p() == null) {
            list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.usetoolworkstation"));
            return;
        }
        String pre = EnumChatFormatting.DARK_GREEN.toString();
        String rst = EnumChatFormatting.RESET.toString() + EnumChatFormatting.GRAY.toString();
        Mode mode = Mode.getMode(stack);
        list.add(StatCollector.func_74838_a((String)"enderutilities.tooltip.item.mode") + ": " + pre + mode.getDisplayName() + rst);
        int sel = ItemBuildersWand.getSelectedBlockType(stack);
        if (sel >= 0) {
            ItemStack blockStack;
            BlockInfo blockInfo = ItemBuildersWand.getSelectedFixedBlockType(stack);
            if (blockInfo != null && (blockStack = new ItemStack(Block.func_149684_b((String)blockInfo.blockName), 1, blockInfo.meta)) != null && blockStack.func_77973_b() != null) {
                String str3 = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selectedblock");
                list.add(str3 + ": " + pre + blockStack.func_82833_r() + rst);
            }
        } else {
            str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.selectedblock");
            str2 = sel == -1 ? StatCollector.func_74838_a((String)"enderutilities.tooltip.item.blocktype.targeted") : StatCollector.func_74838_a((String)"enderutilities.tooltip.item.blocktype.adjacent");
            list.add(str + ": " + pre + str2 + rst);
        }
        str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.area.flipped");
        if (this.getAreaFlipped(stack)) {
            str2 = EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.yes") + rst;
            list.add(str + ": " + str2 + rst);
            str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.flipaxis");
            String preBlue = EnumChatFormatting.BLUE.toString();
            list.add(str + ": " + preBlue + this.getAreaFlipAxis(stack, ForgeDirection.UP) + rst);
        } else {
            str2 = EnumChatFormatting.RED + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.no") + rst;
            list.add(str + ": " + str2 + rst);
        }
        if (mode == Mode.EXTEND_CONTINUOUS) {
            str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.builderswand.allowdiagonals");
            str2 = NBTUtils.getBoolean(stack, WRAPPER_TAG_NAME, TAG_NAME_ALLOW_DIAGONALS) ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.yes") + rst : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.no") + rst;
            list.add(str + ": " + str2 + rst);
        }
        str = StatCollector.func_74838_a((String)"enderutilities.tooltip.item.builderswand.renderghostblocks");
        str2 = NBTUtils.getBoolean(stack, WRAPPER_TAG_NAME, TAG_NAME_GHOST_BLOCKS) ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.yes") + rst : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"enderutilities.tooltip.item.no") + rst;
        list.add(str + ": " + str2 + rst);
        super.addInformationSelective(stack, player, list, advancedTooltips, verbose);
    }

    @Override
    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        ItemBuildersWand.addTooltips(this.func_77667_c(stack) + ".tooltips", list, verbose);
    }

    public BlockPosEU getPosition(ItemStack stack, boolean isStart) {
        String tagName = isStart ? "Pos1" : "Pos2";
        NBTTagCompound tag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, tagName, false);
        if (tag != null) {
            return BlockPosEU.readFromTag(tag);
        }
        return null;
    }

    public void setPosition(ItemStack stack, BlockPosEU pos, boolean isStart) {
        String tagName = isStart ? "Pos1" : "Pos2";
        NBTTagCompound nbt = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, true);
        if (nbt != null && nbt.func_150297_b(tagName, 10)) {
            BlockPosEU oldPos = BlockPosEU.readFromTag(nbt.func_74775_l(tagName));
            if (oldPos != null && oldPos.equals(pos)) {
                nbt.func_82580_o(tagName);
            } else {
                nbt.func_74782_a(tagName, (NBTBase)pos.writeToTag(new NBTTagCompound()));
            }
        } else {
            NBTTagCompound tag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, tagName, true);
            pos.writeToTag(tag);
        }
    }

    public boolean useWand(ItemStack stack, World world, EntityPlayer player, BlockPosEU targetPos) {
        if (player.field_71093_bK != targetPos.dimension) {
            return false;
        }
        ArrayList<BlockPosStateDist> positions = new ArrayList<BlockPosStateDist>();
        BlockPosEU posStart = this.getPosition(stack, true);
        BlockPosEU posEnd = this.getPosition(stack, false);
        Mode mode = Mode.getMode(stack);
        if (mode == Mode.CUBE) {
            posStart = posStart != null ? posStart.offset(ForgeDirection.getOrientation((int)posStart.face), 1) : null;
            posEnd = posEnd != null ? posEnd.offset(ForgeDirection.getOrientation((int)posEnd.face), 1) : null;
            this.getBlockPositionsCube(stack, targetPos, world, positions, posStart, posEnd);
        } else if (mode == Mode.WALLS) {
            posStart = posStart != null ? posStart.offset(ForgeDirection.getOrientation((int)posStart.face), 1) : null;
            posEnd = posEnd != null ? posEnd.offset(ForgeDirection.getOrientation((int)posEnd.face), 1) : null;
            this.getBlockPositionsWalls(stack, targetPos, world, positions, posStart, posEnd);
        } else {
            this.getBlockPositions(stack, posStart != null ? posStart : targetPos, world, positions);
        }
        if (positions.size() <= 60) {
            for (int i = 0; i < positions.size(); ++i) {
                ItemBuildersWand.placeBlockToPosition(stack, world, player, (BlockPosStateDist)positions.get(i));
            }
            BlockPosEU pos = this.getPosition(stack, true);
            if (pos != null && mode != Mode.WALLS && mode != Mode.CUBE) {
                this.setPosition(stack, pos.offset(ForgeDirection.getOrientation((int)targetPos.face), 1), true);
            }
        } else {
            TaskBuildersWand task = new TaskBuildersWand(world, player.func_110124_au(), positions, Configs.valueBuildersWandBlocksPerTick);
            PlayerTaskScheduler.getInstance().addTask(player, task, 1);
        }
        return true;
    }

    public static boolean placeBlockToPosition(ItemStack wandStack, World world, EntityPlayer player, BlockPosStateDist pos) {
        if (!world.func_147437_c(pos.posX, pos.posY, pos.posZ)) {
            return false;
        }
        if (!UtilItemModular.useEnderCharge(wandStack, 10, false)) {
            return false;
        }
        BlockInfo blockInfo = null;
        blockInfo = ItemBuildersWand.getSelectedBlockType(wandStack) == -2 ? ItemBuildersWand.getBlockInfoForAdjacentBlock(world, pos.posX, pos.posY, pos.posZ, ForgeDirection.getOrientation((int)pos.face)) : pos.blockInfo;
        if (blockInfo == null || blockInfo.block.isAir((IBlockAccess)world, pos.posX, pos.posY, pos.posZ) || blockInfo.block.func_149688_o().func_76224_d()) {
            return false;
        }
        Block block = blockInfo.block;
        int meta = blockInfo.meta;
        if (player.field_71075_bZ.field_75098_d) {
            ItemStack targetStack = new ItemStack(block, 1, block.func_149692_a(meta));
            if (targetStack != null && targetStack.func_77973_b() instanceof ItemBlock && BlockUtils.checkCanPlaceBlockAt(world, pos.posX, pos.posY, pos.posZ, pos.face, player, targetStack) && ForgeHooks.onPlaceItemIntoWorld((ItemStack)targetStack, (EntityPlayer)player, (World)world, (int)pos.posX, (int)pos.posY, (int)pos.posZ, (int)pos.face, (float)0.5f, (float)0.5f, (float)0.5f)) {
                return true;
            }
        } else {
            ItemStack templateStack = new ItemStack(block, 1, block.func_149692_a(meta));
            IInventory inv = ItemBuildersWand.getInventoryWithItems(wandStack, templateStack, player);
            ItemStack targetStack = ItemBuildersWand.getItemToBuildWith(inv, templateStack, 1);
            if (targetStack != null && targetStack.func_77973_b() instanceof ItemBlock) {
                if (!BlockUtils.checkCanPlaceBlockAt(world, pos.posX, pos.posY, pos.posZ, pos.face, player, targetStack) || !ForgeHooks.onPlaceItemIntoWorld((ItemStack)targetStack, (EntityPlayer)player, (World)world, (int)pos.posX, (int)pos.posY, (int)pos.posZ, (int)pos.face, (float)0.5f, (float)0.5f, (float)0.5f)) {
                    if ((targetStack = InventoryUtils.tryInsertItemStackToInventory(inv, targetStack, 1)) != null) {
                        EntityItem item = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, targetStack);
                        world.func_72838_d((Entity)item);
                    }
                } else {
                    UtilItemModular.useEnderCharge(wandStack, 10, true);
                    return true;
                }
            }
        }
        return false;
    }

    public static IInventory getInventoryWithItems(ItemStack wandStack, ItemStack templateStack, EntityPlayer player) {
        InventoryPlayer inv = player.field_71071_by;
        int slot = InventoryUtils.getSlotOfFirstMatchingItemStack((IInventory)inv, templateStack);
        if (slot != -1) {
            return inv;
        }
        inv = UtilItemModular.getBoundInventory(wandStack, player, 30);
        if (inv != null && (slot = InventoryUtils.getSlotOfFirstMatchingItemStack((IInventory)inv, templateStack)) != -1) {
            return inv;
        }
        return null;
    }

    public static ItemStack getItemToBuildWith(IInventory inv, ItemStack templateStack, int amount) {
        int slot;
        if (inv != null && (slot = InventoryUtils.getSlotOfFirstMatchingItemStack(inv, templateStack)) != -1) {
            return inv.func_70298_a(slot, amount);
        }
        return null;
    }

    public void setSelectedFixedBlockType(ItemStack stack, Block block, int meta) {
        int sel = ItemBuildersWand.getSelectedBlockType(stack);
        if (sel < 0) {
            return;
        }
        NBTTagCompound blocksTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_BLOCKS, true);
        NBTTagCompound tag = NBTUtils.getCompoundTag(blocksTag, TAG_NAME_BLOCK_PRE + sel, true);
        tag.func_74778_a("Block", Block.field_149771_c.func_148750_c((Object)block));
        tag.func_74774_a("Meta", (byte)meta);
    }

    public static BlockInfo getSelectedFixedBlockType(ItemStack stack) {
        int sel = ItemBuildersWand.getSelectedBlockType(stack);
        if (sel < 0) {
            return null;
        }
        NBTTagCompound blocksTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_BLOCKS, false);
        NBTTagCompound tag = NBTUtils.getCompoundTag(blocksTag, TAG_NAME_BLOCK_PRE + sel, false);
        if (tag != null && tag.func_150297_b("Block", 8)) {
            return new BlockInfo(tag.func_74779_i("Block"), (int)tag.func_74771_c("Meta"));
        }
        return null;
    }

    public static int getSelectedBlockType(ItemStack stack) {
        int mode = Mode.getModeOrdinal(stack);
        NBTTagCompound configsTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_CONFIGS, true);
        NBTTagCompound tag = NBTUtils.getCompoundTag(configsTag, TAG_NAME_CONFIG_PRE + mode, true);
        return tag.func_74771_c(TAG_NAME_BLOCK_SEL);
    }

    public void changeSelectedBlockType(ItemStack stack, boolean reverse) {
        int mode = Mode.getModeOrdinal(stack);
        NBTTagCompound configsTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_CONFIGS, true);
        NBTTagCompound tag = NBTUtils.getCompoundTag(configsTag, TAG_NAME_CONFIG_PRE + mode, true);
        NBTUtils.cycleByteValue(tag, TAG_NAME_BLOCK_SEL, -2, 5, reverse);
    }

    public boolean getAreaFlipped(ItemStack stack) {
        int mode = Mode.getModeOrdinal(stack);
        NBTTagCompound wrapperTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_CONFIGS, true);
        NBTTagCompound tag = NBTUtils.getCompoundTag(wrapperTag, TAG_NAME_CONFIG_PRE + mode, true);
        return tag.func_74767_n("Flip");
    }

    public void toggleAreaFlipped(ItemStack stack, EntityPlayer player) {
        NBTTagCompound tag;
        int mode = Mode.getModeOrdinal(stack);
        NBTTagCompound wrapperTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_CONFIGS, true);
        boolean isFlipped = (tag = NBTUtils.getCompoundTag(wrapperTag, TAG_NAME_CONFIG_PRE + mode, true)).func_74767_n("Flip");
        tag.func_74757_a("Flip", !isFlipped);
        ForgeDirection dir = EntityUtils.getClosestLookingDirection((Entity)player);
        tag.func_74774_a("FlipAxis", (byte)dir.ordinal());
    }

    public ForgeDirection getAreaFlipAxis(ItemStack stack, ForgeDirection defaultFlipAxis) {
        int mode = Mode.getModeOrdinal(stack);
        NBTTagCompound wrapperTag = NBTUtils.getCompoundTag(stack, WRAPPER_TAG_NAME, TAG_NAME_CONFIGS, true);
        NBTTagCompound tag = NBTUtils.getCompoundTag(wrapperTag, TAG_NAME_CONFIG_PRE + mode, true);
        if (tag.func_150297_b("FlipAxis", 1)) {
            return ForgeDirection.getOrientation((int)tag.func_74771_c("FlipAxis"));
        }
        return defaultFlipAxis;
    }

    public ForgeDirection getAxisRight(ItemStack stack, BlockPosEU pos) {
        ForgeDirection face = ForgeDirection.getOrientation((int)pos.face);
        ForgeDirection axisRight = face.getRotation(ForgeDirection.DOWN);
        if (face == ForgeDirection.UP) {
            axisRight = face.getRotation(ForgeDirection.SOUTH);
        } else if (face == ForgeDirection.DOWN) {
            axisRight = face.getRotation(ForgeDirection.SOUTH);
        }
        if (this.getAreaFlipped(stack)) {
            ForgeDirection flipAxis = this.getAreaFlipAxis(stack, face);
            axisRight = axisRight.getRotation(flipAxis);
        }
        return axisRight;
    }

    public ForgeDirection getAxisUp(ItemStack stack, BlockPosEU pos) {
        ForgeDirection face = ForgeDirection.getOrientation((int)pos.face);
        ForgeDirection axisRight = face.getRotation(ForgeDirection.DOWN);
        ForgeDirection axisUp = face.getRotation(axisRight);
        if (face == ForgeDirection.UP) {
            axisRight = face.getRotation(ForgeDirection.SOUTH);
            axisUp = face.getRotation(axisRight);
        } else if (face == ForgeDirection.DOWN) {
            axisRight = face.getRotation(ForgeDirection.SOUTH);
            axisUp = face.getRotation(axisRight);
        }
        if (this.getAreaFlipped(stack)) {
            ForgeDirection flipAxis = this.getAreaFlipAxis(stack, face);
            axisUp = axisUp.getRotation(flipAxis);
        }
        return axisUp;
    }

    public void changeAreaDimensions(EntityPlayer player, ItemStack stack, boolean reverse) {
        BlockPosEU pos = this.getPosition(stack, true);
        Mode mode = Mode.getMode(stack);
        if (pos == null || mode == Mode.WALLS || mode == Mode.CUBE) {
            return;
        }
        int amount = reverse ? 1 : -1;
        Area area = new Area(stack);
        if (mode == Mode.COLUMN) {
            area.adjustFromPlanarizedFacing(ForgeDirection.EAST, amount, ForgeDirection.UP, ForgeDirection.EAST);
            area.writeToNBT(stack);
            return;
        }
        ForgeDirection faceAxis = ForgeDirection.getOrientation((int)pos.face);
        ForgeDirection axisRight = this.getAxisRight(stack, pos);
        ForgeDirection axisUp = this.getAxisUp(stack, pos);
        boolean isFlipped = this.getAreaFlipped(stack);
        ForgeDirection flipAxis = this.getAreaFlipAxis(stack, faceAxis);
        ForgeDirection faceAxisFlipped = isFlipped ? faceAxis.getRotation(flipAxis) : faceAxis;
        ForgeDirection lookDir = ForgeDirection.NORTH;
        if (faceAxisFlipped == ForgeDirection.UP || faceAxisFlipped == ForgeDirection.DOWN) {
            lookDir = EntityUtils.getHorizontalLookingDirection((Entity)player);
        } else {
            EntityUtils.LeftRight leftRight;
            lookDir = EntityUtils.getClosestLookingDirection((Entity)player);
            lookDir = Math.abs(player.field_70125_A) > 15.0f && (lookDir == faceAxisFlipped || lookDir == faceAxisFlipped.getOpposite()) ? EntityUtils.getVerticalLookingDirection((Entity)player) : ((leftRight = EntityUtils.getLookLeftRight((Entity)player, faceAxisFlipped)) == EntityUtils.LeftRight.RIGHT ? faceAxisFlipped.getRotation(ForgeDirection.DOWN) : faceAxisFlipped.getRotation(ForgeDirection.UP));
        }
        area.adjustFromPlanarizedFacing(lookDir, amount, axisUp, axisRight);
        area.writeToNBT(stack);
    }

    public void addAdjacent(World world, BlockPosEU center, Area area, int posV, int posH, List<BlockPosStateDist> positions, int blockType, boolean diagonals, BlockInfo blockInfo, ForgeDirection face, ForgeDirection axisRight, ForgeDirection axisUp) {
        BlockPosStateDist pos;
        if (posH < -area.rNegH || posH > area.rPosH || posV < -area.rNegV || posV > area.rPosV) {
            return;
        }
        int x = center.posX + posH * axisRight.offsetX + posV * axisUp.offsetX;
        int y = center.posY + posH * axisRight.offsetY + posV * axisUp.offsetY;
        int z = center.posZ + posH * axisRight.offsetZ + posV * axisUp.offsetZ;
        if (!world.func_147437_c(x, y, z)) {
            return;
        }
        int xb = x - face.offsetX;
        int yb = y - face.offsetY;
        int zb = z - face.offsetZ;
        Block block = world.func_147439_a(xb, yb, zb);
        int meta = world.func_72805_g(xb, yb, zb);
        if (block.isAir((IBlockAccess)world, xb, yb, zb) || block.func_149688_o().func_76224_d()) {
            return;
        }
        if ((blockType == -2 || blockType >= 0 && blockInfo != null || blockInfo != null && blockInfo.block == block && blockInfo.meta == meta) && !positions.contains(pos = new BlockPosStateDist(x, y, z, 0, center.face, blockType == -2 ? new BlockInfo(block, meta) : blockInfo))) {
            positions.add(pos);
            this.addAdjacent(world, center, area, posV - 1, posH + 0, positions, blockType, diagonals, blockInfo, face, axisRight, axisUp);
            this.addAdjacent(world, center, area, posV + 0, posH - 1, positions, blockType, diagonals, blockInfo, face, axisRight, axisUp);
            this.addAdjacent(world, center, area, posV + 0, posH + 1, positions, blockType, diagonals, blockInfo, face, axisRight, axisUp);
            this.addAdjacent(world, center, area, posV + 1, posH + 0, positions, blockType, diagonals, blockInfo, face, axisRight, axisUp);
            if (diagonals) {
                this.addAdjacent(world, center, area, posV - 1, posH - 1, positions, blockType, diagonals, blockInfo, face, axisRight, axisUp);
                this.addAdjacent(world, center, area, posV - 1, posH + 1, positions, blockType, diagonals, blockInfo, face, axisRight, axisUp);
                this.addAdjacent(world, center, area, posV + 1, posH - 1, positions, blockType, diagonals, blockInfo, face, axisRight, axisUp);
                this.addAdjacent(world, center, area, posV + 1, posH + 1, positions, blockType, diagonals, blockInfo, face, axisRight, axisUp);
            }
        }
    }

    public static BlockInfo getBlockInfoForAdjacentBlock(World world, int x, int y, int z, ForgeDirection faceAxis) {
        return new BlockInfo(world.func_147439_a(x - faceAxis.offsetX, y - faceAxis.offsetY, z - faceAxis.offsetZ), world.func_72805_g(x - faceAxis.offsetX, y - faceAxis.offsetY, z - faceAxis.offsetZ));
    }

    public BlockInfo getBlockInfoForTargeted(ItemStack stack, World world, BlockPosEU targeted) {
        int blockType = ItemBuildersWand.getSelectedBlockType(stack);
        if (blockType == -1 || blockType == -2) {
            return new BlockInfo(world.func_147439_a(targeted.posX, targeted.posY, targeted.posZ), world.func_72805_g(targeted.posX, targeted.posY, targeted.posZ));
        }
        if (blockType >= 0) {
            return ItemBuildersWand.getSelectedFixedBlockType(stack);
        }
        return null;
    }

    public BlockInfo getBlockInfoForBlockType(World world, int x, int y, int z, int face, int blockType, BlockInfo biTarget, BlockInfo biBound) {
        if (blockType == -1) {
            return biTarget;
        }
        if (blockType == -2) {
            return ItemBuildersWand.getBlockInfoForAdjacentBlock(world, x, y, z, ForgeDirection.getOrientation((int)face));
        }
        if (blockType >= 0) {
            return biBound;
        }
        return null;
    }

    public void getBlockPositions(ItemStack stack, BlockPosEU targeted, World world, List<BlockPosStateDist> positions) {
        int blockType = ItemBuildersWand.getSelectedBlockType(stack);
        BlockInfo biTarget = this.getBlockInfoForTargeted(stack, world, targeted);
        BlockInfo biBound = ItemBuildersWand.getSelectedFixedBlockType(stack);
        ForgeDirection face = ForgeDirection.getOrientation((int)targeted.face);
        ForgeDirection axisRight = face.getRotation(ForgeDirection.DOWN);
        ForgeDirection axisUp = face.getRotation(axisRight);
        if (face == ForgeDirection.UP) {
            axisRight = face.getRotation(ForgeDirection.SOUTH);
            axisUp = face.getRotation(axisRight);
        } else if (face == ForgeDirection.DOWN) {
            axisRight = face.getRotation(ForgeDirection.SOUTH);
            axisUp = face.getRotation(axisRight);
        }
        if (this.getAreaFlipped(stack)) {
            ForgeDirection flipAxis = this.getAreaFlipAxis(stack, face);
            axisRight = axisRight.getRotation(flipAxis);
            axisUp = axisUp.getRotation(flipAxis);
        }
        BlockPosEU center = targeted.offset(face, 1);
        Area area = new Area(stack);
        int dim = world.field_73011_w.field_76574_g;
        Mode mode = Mode.getMode(stack);
        switch (mode) {
            case COLUMN: {
                int z;
                int y;
                int x;
                for (int i = 0; i <= area.rPosH && world.func_147437_c(x = center.posX + i * face.offsetX, y = center.posY + i * face.offsetY, z = center.posZ + i * face.offsetZ); ++i) {
                    positions.add(new BlockPosStateDist(x, y, z, dim, targeted.face, biTarget));
                }
                break;
            }
            case LINE: {
                int z;
                int y;
                int x;
                int i;
                for (i = 0; i <= area.rPosH && world.func_147437_c(x = center.posX + i * axisRight.offsetX, y = center.posY + i * axisRight.offsetY, z = center.posZ + i * axisRight.offsetZ); ++i) {
                    positions.add(new BlockPosStateDist(x, y, z, dim, targeted.face, this.getBlockInfoForBlockType(world, x, y, z, targeted.face, blockType, biTarget, biBound)));
                }
                for (i = -1; i >= -area.rNegH && world.func_147437_c(x = center.posX + i * axisRight.offsetX, y = center.posY + i * axisRight.offsetY, z = center.posZ + i * axisRight.offsetZ); --i) {
                    positions.add(new BlockPosStateDist(x, y, z, dim, targeted.face, this.getBlockInfoForBlockType(world, x, y, z, targeted.face, blockType, biTarget, biBound)));
                }
                break;
            }
            case PLANE: {
                for (int v = -area.rNegV; v <= area.rPosV; ++v) {
                    for (int h = -area.rNegH; h <= area.rPosH; ++h) {
                        int x = center.posX + h * axisRight.offsetX + v * axisUp.offsetX;
                        int y = center.posY + h * axisRight.offsetY + v * axisUp.offsetY;
                        int z = center.posZ + h * axisRight.offsetZ + v * axisUp.offsetZ;
                        if (!world.func_147437_c(x, y, z)) continue;
                        positions.add(new BlockPosStateDist(x, y, z, dim, targeted.face, this.getBlockInfoForBlockType(world, x, y, z, targeted.face, blockType, biTarget, biBound)));
                    }
                }
                break;
            }
            case EXTEND_CONTINUOUS: {
                boolean diagonals = NBTUtils.getBoolean(stack, WRAPPER_TAG_NAME, TAG_NAME_ALLOW_DIAGONALS);
                this.addAdjacent(world, center, area, 0, 0, positions, blockType, diagonals, biTarget, face, axisRight, axisUp);
                break;
            }
            case EXTEND_AREA: {
                for (int v = -area.rNegV; v <= area.rPosV; ++v) {
                    for (int h = -area.rNegH; h <= area.rPosH; ++h) {
                        int x = center.posX + h * axisRight.offsetX + v * axisUp.offsetX;
                        int y = center.posY + h * axisRight.offsetY + v * axisUp.offsetY;
                        int z = center.posZ + h * axisRight.offsetZ + v * axisUp.offsetZ;
                        if (!world.func_147437_c(x, y, z)) continue;
                        int xb = x - face.offsetX;
                        int yb = y - face.offsetY;
                        int zb = z - face.offsetZ;
                        Block block = world.func_147439_a(xb, yb, zb);
                        int meta = world.func_72805_g(xb, yb, zb);
                        if (block.isAir((IBlockAccess)world, xb, yb, zb) || block.func_149688_o().func_76224_d() || blockType != -2 && (blockType < 0 || biBound == null) && (biTarget == null || biTarget.block != block || biTarget.meta != meta)) continue;
                        positions.add(new BlockPosStateDist(x, y, z, dim, targeted.face, this.getBlockInfoForBlockType(world, x, y, z, targeted.face, blockType, biTarget, biBound)));
                    }
                }
                break;
            }
        }
    }

    public void getBlockPositionsWalls(ItemStack stack, BlockPosEU targeted, World world, List<BlockPosStateDist> positions, BlockPosEU pos1, BlockPosEU pos2) {
        int z;
        int z2;
        int y;
        int x;
        if (pos1 == null || pos2 == null) {
            return;
        }
        int startX = Math.min(pos1.posX, pos2.posX);
        int startY = Math.min(pos1.posY, pos2.posY);
        int startZ = Math.min(pos1.posZ, pos2.posZ);
        int endX = Math.max(pos1.posX, pos2.posX);
        int endY = Math.max(pos1.posY, pos2.posY);
        int endZ = Math.max(pos1.posZ, pos2.posZ);
        if (endX - startX > 128 || endY - startY > 128 || endZ - startZ > 128) {
            return;
        }
        int blockType = ItemBuildersWand.getSelectedBlockType(stack);
        BlockInfo biTarget = this.getBlockInfoForTargeted(stack, world, targeted);
        BlockInfo biBound = ItemBuildersWand.getSelectedFixedBlockType(stack);
        int dim = world.field_73011_w.field_76574_g;
        for (x = startX; x <= endX; ++x) {
            for (y = startY; y <= endY; ++y) {
                positions.add(new BlockPosStateDist(x, y, startZ, dim, targeted.face, this.getBlockInfoForBlockType(world, x, y, startZ, targeted.face, blockType, biTarget, biBound)));
            }
        }
        for (x = startX; x <= endX; ++x) {
            for (y = startY; y <= endY; ++y) {
                positions.add(new BlockPosStateDist(x, y, endZ, dim, targeted.face, this.getBlockInfoForBlockType(world, x, y, endZ, targeted.face, blockType, biTarget, biBound)));
            }
        }
        for (x = startX; x <= endX; ++x) {
            for (z2 = startZ; z2 <= endZ; ++z2) {
                positions.add(new BlockPosStateDist(x, startY, z2, dim, targeted.face, this.getBlockInfoForBlockType(world, x, startY, z2, targeted.face, blockType, biTarget, biBound)));
            }
        }
        for (x = startX; x <= endX; ++x) {
            for (z2 = startZ; z2 <= endZ; ++z2) {
                positions.add(new BlockPosStateDist(x, endY, z2, dim, targeted.face, this.getBlockInfoForBlockType(world, x, endY, z2, targeted.face, blockType, biTarget, biBound)));
            }
        }
        for (z = startZ + 1; z <= endZ - 1; ++z) {
            for (y = startY + 1; y <= endY - 1; ++y) {
                positions.add(new BlockPosStateDist(startX, y, z, dim, targeted.face, this.getBlockInfoForBlockType(world, startX, y, z, targeted.face, blockType, biTarget, biBound)));
            }
        }
        for (z = startZ + 1; z <= endZ - 1; ++z) {
            for (y = startY + 1; y <= endY - 1; ++y) {
                positions.add(new BlockPosStateDist(endX, y, z, dim, targeted.face, this.getBlockInfoForBlockType(world, endX, y, z, targeted.face, blockType, biTarget, biBound)));
            }
        }
    }

    public void getBlockPositionsCube(ItemStack stack, BlockPosEU targeted, World world, List<BlockPosStateDist> positions, BlockPosEU pos1, BlockPosEU pos2) {
        if (pos1 == null || pos2 == null) {
            return;
        }
        int startX = Math.min(pos1.posX, pos2.posX);
        int startY = Math.min(pos1.posY, pos2.posY);
        int startZ = Math.min(pos1.posZ, pos2.posZ);
        int endX = Math.max(pos1.posX, pos2.posX);
        int endY = Math.max(pos1.posY, pos2.posY);
        int endZ = Math.max(pos1.posZ, pos2.posZ);
        if (endX - startX > 128 || endY - startY > 128 || endZ - startZ > 128) {
            return;
        }
        int blockType = ItemBuildersWand.getSelectedBlockType(stack);
        BlockInfo biTarget = this.getBlockInfoForTargeted(stack, world, targeted);
        BlockInfo biBound = ItemBuildersWand.getSelectedFixedBlockType(stack);
        int dim = world.field_73011_w.field_76574_g;
        for (int y = startY; y <= endY; ++y) {
            for (int z = startZ; z <= endZ; ++z) {
                for (int x = startX; x <= endX; ++x) {
                    positions.add(new BlockPosStateDist(x, y, z, dim, pos1.face, this.getBlockInfoForBlockType(world, x, y, z, targeted.face, blockType, biTarget, biBound)));
                }
            }
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (stack == null || ReferenceKeys.getBaseKey(key) != 1) {
            return;
        }
        if (!ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key)) {
            this.changeSelectedBlockType(stack, ReferenceKeys.keypressActionIsReversed(key));
        } else if (!ReferenceKeys.keypressContainsControl(key) && ReferenceKeys.keypressContainsShift(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            this.changeAreaDimensions(player, stack, ReferenceKeys.keypressActionIsReversed(key));
        } else if (ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsAlt(key)) {
            Mode.cycleMode(stack, ReferenceKeys.keypressActionIsReversed(key) || ReferenceKeys.keypressContainsShift(key));
        } else if (ReferenceKeys.keypressContainsControl(key) && ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, ReferenceKeys.keypressActionIsReversed(key));
        } else if (ReferenceKeys.keypressContainsControl(key) && !ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key)) {
            NBTUtils.toggleBoolean(stack, WRAPPER_TAG_NAME, TAG_NAME_ALLOW_DIAGONALS);
        } else if (!ReferenceKeys.keypressContainsControl(key) && ReferenceKeys.keypressContainsShift(key) && ReferenceKeys.keypressContainsAlt(key)) {
            NBTUtils.toggleBoolean(stack, WRAPPER_TAG_NAME, TAG_NAME_GHOST_BLOCKS);
        } else if (!(ReferenceKeys.keypressContainsControl(key) || ReferenceKeys.keypressContainsShift(key) || ReferenceKeys.keypressContainsAlt(key))) {
            this.toggleAreaFlipped(stack, player);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 600;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.block;
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 4;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL)) {
            return 3;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack == null || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        if (moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) && imodule.getModuleTier(moduleStack) != 1) {
            return 0;
        }
        return this.getMaxModules(containerStack, moduleType);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A() + ".0");
        this.iconArray = new IIcon[5];
        for (int i = 0; i < 5; ++i) {
            this.iconArray[i] = iconRegister.func_94245_a(this.func_111208_A() + "." + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getItemIconForUseDuration(int index) {
        if (index < this.iconArray.length) {
            return this.iconArray[index];
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        return this.getIcon(stack, renderPass, null, null, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        int index = 0;
        if (player != null && player.func_71011_bu() != null) {
            int inUse = 0;
            int maxUse = this.func_77626_a(stack);
            inUse = maxUse - useRemaining;
            index = MathHelper.func_76125_a((int)(inUse / 4), (int)0, (int)4);
        }
        return this.getItemIconForUseDuration(index);
    }

    public Mode getMode(ItemStack stack) {
        return Mode.getMode(stack);
    }

    public static enum Mode {
        EXTEND_CONTINUOUS("enderutilities.tooltip.item.extend.continuous"),
        EXTEND_AREA("enderutilities.tooltip.item.extend.area"),
        LINE("enderutilities.tooltip.item.build.line"),
        PLANE("enderutilities.tooltip.item.build.plane"),
        COLUMN("enderutilities.tooltip.item.build.column"),
        WALLS("enderutilities.tooltip.item.build.walls"),
        CUBE("enderutilities.tooltip.item.build.cube");

        private String unlocName;

        private Mode(String unlocName) {
            this.unlocName = unlocName;
        }

        public String getDisplayName() {
            return StatCollector.func_74838_a((String)this.unlocName);
        }

        public static Mode getMode(ItemStack stack) {
            return Mode.values()[Mode.getModeOrdinal(stack)];
        }

        public static void cycleMode(ItemStack stack, boolean reverse) {
            NBTUtils.cycleByteValue(stack, ItemBuildersWand.WRAPPER_TAG_NAME, ItemBuildersWand.TAG_NAME_MODE, Mode.values().length - 1, reverse);
        }

        public static int getModeOrdinal(ItemStack stack) {
            byte id = NBTUtils.getByte(stack, ItemBuildersWand.WRAPPER_TAG_NAME, ItemBuildersWand.TAG_NAME_MODE);
            return id >= 0 && id < Mode.values().length ? (int)id : 0;
        }
    }

    public class Area {
        public int rPosH;
        public int rNegH;
        public int rPosV;
        public int rNegV;
        public int maxRadius;

        public Area(int packed) {
            this.init(packed);
        }

        public Area(ItemStack stack) {
            int mode = Mode.getModeOrdinal(stack);
            NBTTagCompound wrapperTag = NBTUtils.getCompoundTag(stack, ItemBuildersWand.WRAPPER_TAG_NAME, ItemBuildersWand.TAG_NAME_CONFIGS, false);
            NBTTagCompound tag = NBTUtils.getCompoundTag(wrapperTag, ItemBuildersWand.TAG_NAME_CONFIG_PRE + mode, false);
            if (tag != null) {
                this.init(tag.func_74762_e(ItemBuildersWand.TAG_NAME_DIMENSIONS));
            } else {
                this.init(0x8080808);
            }
        }

        public void init(int packed) {
            this.init(packed & 0xFF, packed >> 8 & 0xFF, packed >> 16 & 0xFF, packed >> 24 & 0xFF);
        }

        public void init(int rPosH, int rNegH, int rPosV, int rNegV) {
            this.rPosH = rPosH;
            this.rNegH = rNegH;
            this.rPosV = rPosV;
            this.rNegV = rNegV;
            this.maxRadius = 64;
        }

        public Area adjustFromPlanarizedFacing(ForgeDirection dir, int amount, ForgeDirection upAxis, ForgeDirection rightAxis) {
            if (dir == upAxis) {
                this.rPosV = MathHelper.func_76125_a((int)(this.rPosV + amount), (int)0, (int)this.maxRadius);
            } else if (dir == upAxis.getOpposite()) {
                this.rNegV = MathHelper.func_76125_a((int)(this.rNegV + amount), (int)0, (int)this.maxRadius);
            } else if (dir == rightAxis) {
                this.rPosH = MathHelper.func_76125_a((int)(this.rPosH + amount), (int)0, (int)this.maxRadius);
            } else if (dir == rightAxis.getOpposite()) {
                this.rNegH = MathHelper.func_76125_a((int)(this.rNegH + amount), (int)0, (int)this.maxRadius);
            }
            return this;
        }

        public int getPacked() {
            return this.rPosH | this.rNegH << 8 | this.rPosV << 16 | this.rNegV << 24;
        }

        public void writeToNBT(ItemStack stack) {
            int mode = Mode.getModeOrdinal(stack);
            NBTTagCompound wrapperTag = NBTUtils.getCompoundTag(stack, ItemBuildersWand.WRAPPER_TAG_NAME, ItemBuildersWand.TAG_NAME_CONFIGS, true);
            NBTTagCompound tag = NBTUtils.getCompoundTag(wrapperTag, ItemBuildersWand.TAG_NAME_CONFIG_PRE + mode, true);
            tag.func_74768_a(ItemBuildersWand.TAG_NAME_DIMENSIONS, this.getPacked());
        }
    }
}

