/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fi.dy.masa.enderutilities.inventory.ContainerLargeStacks;
import fi.dy.masa.enderutilities.inventory.IContainerModularItem;
import fi.dy.masa.enderutilities.inventory.InventoryItem;
import fi.dy.masa.enderutilities.inventory.InventoryItemModules;
import fi.dy.masa.enderutilities.inventory.SlotGeneric;
import fi.dy.masa.enderutilities.inventory.SlotModuleModularItem;
import fi.dy.masa.enderutilities.item.ItemPickupManager;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageSyncSlot;
import fi.dy.masa.enderutilities.setup.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.SlotRange;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerPickupManager
extends ContainerLargeStacks
implements IContainerModularItem {
    public static final int NUM_MODULE_SLOTS = 3;
    public InventoryItem inventoryItemTransmit;
    public InventoryItemModules inventoryItemModules;
    public InventoryItem inventoryItemFilters;
    protected UUID containerUUID;
    protected SlotRange filterSlots;

    public ContainerPickupManager(EntityPlayer player, ItemStack containerStack) {
        super(player, new InventoryItem(containerStack, 1, player.field_70170_p.field_72995_K, player, "TransportItems"));
        this.containerUUID = NBTUtils.getUUIDFromItemStack(containerStack, "UUID", true);
        this.filterSlots = new SlotRange(0, 0);
        this.inventoryItemModules = new InventoryItemModules(containerStack, 4, player.field_70170_p.field_72995_K, player);
        this.inventoryItemModules.setHostInventory((IInventory)player.field_71071_by, this.containerUUID);
        this.inventoryItemModules.readFromContainerItemStack();
        byte preset = NBTUtils.getByte(containerStack, "PickupManager", "SelPreset");
        this.inventoryItemFilters = new InventoryItem(containerStack, 36, player.field_70170_p.field_72995_K, player, "FilterItems_" + preset);
        this.inventoryItemFilters.setHostInventory((IInventory)player.field_71071_by, this.containerUUID);
        this.inventoryItemFilters.setInventoryStackLimit(1);
        this.inventoryItemFilters.readFromContainerItemStack();
        this.inventoryItemTransmit = (InventoryItem)this.inventory;
        this.inventoryItemTransmit.setHostInventory((IInventory)player.field_71071_by, this.containerUUID);
        this.inventoryItemTransmit.setInventoryStackLimit(1024);
        this.inventoryItemTransmit.readFromContainerItemStack();
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(8, 174);
    }

    @Override
    protected void addCustomInventorySlots() {
        int j;
        int i;
        int start = this.field_75151_b.size();
        int posX = 8;
        int posY = 29;
        this.func_75146_a(new SlotGeneric(this.inventoryItemTransmit, 0, 89, posY));
        this.customInventorySlots = new SlotRange(start, 1);
        start = this.field_75151_b.size();
        posY = 47;
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new SlotGeneric(this.inventoryItemFilters, i * 9 + j, posX + j * 18, posY + i * 18));
            }
        }
        posY = 123;
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new SlotGeneric(this.inventoryItemFilters, i * 9 + j + 18, posX + j * 18, posY + i * 18));
            }
        }
        this.filterSlots = new SlotRange(start, 36);
        posX = 116;
        posY = 29;
        for (i = 0; i < 3; ++i) {
            this.func_75146_a(new SlotModuleModularItem(this.inventoryItemModules, i + 1, posX + i * 18, posY, ItemModule.ModuleType.TYPE_LINKCRYSTAL, this));
        }
    }

    @Override
    public ItemStack getModularItem() {
        return InventoryUtils.getItemStackByUUID((IInventory)this.player.field_71071_by, this.containerUUID, "UUID");
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.inventory.func_70305_f();
        this.inventoryItemModules.func_70305_f();
        this.inventoryItemFilters.func_70305_f();
    }

    protected boolean fakeSlotClick(int slotNum, int button, int type, EntityPlayer player) {
        Slot slot = slotNum >= 0 && slotNum < this.field_75151_b.size() ? this.func_75139_a(slotNum) : null;
        ItemStack stackCursor = player.field_71071_by.func_70445_o();
        if (!(type != 0 && type != 1 || button != 0 && button != 1)) {
            if (slot == null || slot.field_75224_c != this.inventoryItemFilters) {
                return false;
            }
            if (stackCursor != null) {
                ItemStack stackTmp = stackCursor.func_77946_l();
                stackTmp.field_77994_a = 1;
                slot.func_75215_d(stackTmp);
            } else {
                slot.func_75215_d(null);
            }
            return true;
        }
        if (this.isDragging) {
            if (type == 5 && (button == 2 || button == 6)) {
                if (stackCursor != null) {
                    ItemStack stackTmp = stackCursor.func_77946_l();
                    stackTmp.field_77994_a = 1;
                    Iterator iterator = this.draggedSlots.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        if (this.func_75139_a((int)i).field_75224_c != this.inventoryItemFilters) continue;
                        this.func_75139_a(i).func_75215_d(stackTmp.func_77946_l());
                    }
                }
                this.isDragging = false;
            } else if (type == 5 && (button == 1 || button == 5)) {
                this.draggedSlots.add(slotNum);
            }
        } else if (type == 5 && (button == 0 || button == 4)) {
            this.isDragging = true;
            this.draggingRightClick = button == 4;
            this.draggedSlots.clear();
        }
        return false;
    }

    @Override
    public ItemStack func_75144_a(int slotNum, int button, int type, EntityPlayer player) {
        boolean sent;
        if (this.isSlotInRange(this.filterSlots, slotNum)) {
            this.fakeSlotClick(slotNum, button, type, player);
            return null;
        }
        if (slotNum == -999 && type == 5) {
            Iterator iterator = this.draggedSlots.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (!this.isSlotInRange(this.filterSlots, i)) continue;
                this.fakeSlotClick(slotNum, button, type, player);
                return null;
            }
        }
        ItemStack modularStackPre = this.getModularItem();
        ItemStack stack = super.func_75144_a(slotNum, button, type, player);
        ItemStack modularStackPost = this.getModularItem();
        if (!player.field_70170_p.field_72995_K && modularStackPost != null && modularStackPost.func_77973_b() == EnderUtilitiesItems.pickupManager && (sent = ((ItemPickupManager)modularStackPost.func_77973_b()).tryTransportItemsFromTransportSlot(this.inventoryItemTransmit, player, modularStackPost)) && player instanceof EntityPlayerMP) {
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncSlot(this.field_75152_c, 0, this.func_75139_a(0).func_75211_c()), (EntityPlayerMP)player);
        }
        if (modularStackPre != modularStackPost) {
            this.inventoryItemTransmit.readFromContainerItemStack();
            this.inventoryItemModules.readFromContainerItemStack();
            this.inventoryItemFilters.readFromContainerItemStack();
        }
        this.func_75142_b();
        return stack;
    }
}

